/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.user.UserInterfaceMain;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientJobManager
extends JobManager {
    private static final String CLASS_NAME = Job.class.getName();
    private static final Logger logger = Logger.getLogger("com.sun.electric.tool.job");
    private Job.Inform[] serverJobQueue = new Job.Inform[0];
    private final ArrayList<EJob> serverJobs = new ArrayList();
    private final ArrayList<EJob> clientJobs = new ArrayList();
    private final IdReader reader;
    private final DataOutputStream clientOutputStream;
    private final Process process;
    private static int numStarted;
    private EditingPreferences currentEp = new EditingPreferences(true, IdManager.stdIdManager.getInitialTechPool());
    private boolean skipOneLine;
    private static Snapshot clientSnapshot;

    public ClientJobManager(String serverMachineName, int serverPort) throws IOException {
        this.process = null;
        System.out.println("Attempting to connect to port " + serverPort + " ...");
        Socket socket = new Socket(serverMachineName, serverPort);
        this.reader = new IdReader(new DataInputStream(new BufferedInputStream(socket.getInputStream())), IdManager.stdIdManager);
        this.clientOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public ClientJobManager(Process process, boolean skipOneLine) throws IOException {
        this.process = process;
        this.skipOneLine = skipOneLine;
        System.out.println("Attempting to connect to server subprocess ...");
        this.reader = new IdReader(new DataInputStream(new BufferedInputStream(process.getInputStream())), IdManager.stdIdManager);
        this.clientOutputStream = new DataOutputStream(new BufferedOutputStream(process.getOutputStream()));
    }

    void writeEJob(EJob ejob) throws IOException {
        this.writeEditingPreferences();
        this.clientOutputStream.writeByte(1);
        this.clientOutputStream.writeInt(ejob.jobKey.jobId);
        this.clientOutputStream.writeUTF(ejob.jobType.toString());
        this.clientOutputStream.writeUTF(ejob.jobName);
        this.clientOutputStream.writeInt(ejob.serializedJob.length);
        this.clientOutputStream.write(ejob.serializedJob);
        this.clientOutputStream.flush();
    }

    private void writeEditingPreferences() throws IOException {
        byte[] serializedEp;
        EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
        if (ep == this.currentEp) {
            return;
        }
        this.currentEp = ep;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, EDatabase.clientDatabase());
            out.writeObject(ep);
            out.flush();
            serializedEp = byteStream.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        this.clientOutputStream.writeByte(2);
        this.clientOutputStream.writeInt(serializedEp.length);
        this.clientOutputStream.write(serializedEp);
    }

    @Override
    public void runLoop(final Job initialJob) {
        logger.entering(CLASS_NAME, "clientLoop");
        Snapshot oldSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
        Snapshot currentSnapshot = EDatabase.clientDatabase().backup();
        assert (currentSnapshot == oldSnapshot);
        try {
            int protocolVersion;
            if (this.skipOneLine) {
                char ch;
                for (int i = 0; i < 150 && (ch = (char)this.reader.readByte()) != '\n'; ++i) {
                    System.err.print(ch);
                }
                System.err.println();
            }
            if ((protocolVersion = this.reader.readInt()) != 19) {
                System.err.println("Client's protocol version 19 is incompatible with Server's protocol version " + protocolVersion);
                System.exit(1);
            }
            Job.currentUI.connectionId = this.reader.readInt();
            System.out.println("Connected");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                initialJob.startJob();
            }
        });
        try {
            while (true) {
                byte tag;
                if ((tag = this.reader.readByte()) == 1) {
                    currentSnapshot = Snapshot.readSnapshot(this.reader, currentSnapshot);
                    SwingUtilities.invokeLater(new SnapshotDatabaseChangeRun(clientSnapshot, currentSnapshot));
                    clientSnapshot = currentSnapshot;
                    continue;
                }
                Client.ServerEvent serverEvent = Client.read(this.reader, tag, Job.currentUI);
                if (serverEvent instanceof Client.EJobEvent) {
                    Client.EJobEvent ejobEvent = (Client.EJobEvent)serverEvent;
                    EJob ejob = ejobEvent.ejob;
                    assert (ejob.state == ejobEvent.newState);
                    assert (ejob.state == EJob.State.SERVER_DONE);
                    EJob myEjob = this.getServerJob(ejob.jobKey.jobId);
                    assert (myEjob.jobName.equals(ejob.jobName));
                    myEjob.state = ejob.state;
                    myEjob.serializedResult = ejob.serializedResult;
                    myEjob.oldSnapshot = oldSnapshot;
                    myEjob.newSnapshot = currentSnapshot;
                    myEjob.clientJob.finished = true;
                    oldSnapshot = currentSnapshot;
                    this.showJobQueue();
                    Job.currentUI.addEvent(new Client.EJobEvent(myEjob, ejobEvent.newState, ejobEvent.timeStamp));
                    continue;
                }
                if (serverEvent instanceof Client.JobQueueEvent) {
                    this.serverJobQueue = ((Client.JobQueueEvent)serverEvent).jobQueue;
                    this.showJobQueue();
                    continue;
                }
                Job.currentUI.addEvent(serverEvent);
            }
        }
        catch (IOException e) {
            logger.logp(Level.INFO, CLASS_NAME, "clientLoop", "failed", e);
            System.out.println("END OF FILE reading from server");
            if (this.process != null) {
                ClientJobManager.printErrorStream(this.process);
            }
            return;
        }
    }

    private static void printErrorStream(Process process) {
        try {
            int c;
            process.getOutputStream().close();
            BufferedInputStream errStream = new BufferedInputStream(process.getErrorStream());
            System.err.println("StdErr:");
            while (((InputStream)errStream).available() != 0 && (c = ((InputStream)errStream).read()) >= 0) {
                System.err.print((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addJob(final EJob ejob, boolean onMySnapshot) {
        assert (SwingUtilities.isEventDispatchThread());
        if (ejob.jobType == Job.Type.CLIENT_EXAMINE) {
            this.lock();
            try {
                if (onMySnapshot) {
                    this.clientJobs.add(0, ejob);
                } else {
                    this.clientJobs.add(ejob);
                }
            }
            finally {
                this.unlock();
            }
            this.showJobQueue();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ejob.state = EJob.State.RUNNING;
                    ClientJobManager.this.showJobQueue();
                    ejob.changedFields = new ArrayList();
                    try {
                        if (!ejob.clientJob.doIt()) {
                            throw new JobException("Job '" + ejob.jobName + "' failed");
                        }
                        ejob.serializeResult(EDatabase.clientDatabase());
                    }
                    catch (Throwable e) {
                        e.getStackTrace();
                        e.printStackTrace();
                        ejob.serializeExceptionResult(e, EDatabase.clientDatabase());
                    }
                    ClientJobManager.this.lock();
                    try {
                        ClientJobManager.this.clientJobs.remove(ejob);
                    }
                    finally {
                        ClientJobManager.this.unlock();
                    }
                    ClientJobManager.this.showJobQueue();
                    Job.currentUI.addEvent(new Client.EJobEvent(ejob, EJob.State.SERVER_DONE));
                }
            });
        } else {
            this.lock();
            try {
                this.serverJobs.add(ejob);
            }
            finally {
                this.unlock();
            }
            try {
                this.writeEJob(ejob);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJob getServerJob(int jobId) {
        this.lock();
        try {
            for (int i = 0; i < this.serverJobs.size(); ++i) {
                EJob ejob = this.serverJobs.get(i);
                if (ejob.jobKey.jobId != jobId) continue;
                this.serverJobs.remove(i);
                EJob eJob = ejob;
                return eJob;
            }
            EJob eJob = null;
            return eJob;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    void removeJob(Job j) {
        if (j.started) {
            Iterator<EJob> it = this.serverJobs.iterator();
            while (it.hasNext()) {
                EJob ejob = it.next();
                if (ejob.getJob() != j) continue;
                it.remove();
            }
        } else {
            Iterator<EJob> it = this.clientJobs.iterator();
            while (it.hasNext()) {
                EJob ejob = it.next();
                if (ejob.getJob() != j) continue;
                it.remove();
            }
        }
    }

    @Override
    EJob selectEJob(EJob finishedEJob) {
        return null;
    }

    @Override
    void setProgress(EJob ejob, String progress) {
        ejob.progress = progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showJobQueue() {
        Job.Inform[] jobQueue;
        this.lock();
        try {
            jobQueue = new Job.Inform[this.serverJobQueue.length + this.clientJobs.size()];
            System.arraycopy(this.serverJobQueue, 0, jobQueue, 0, this.serverJobQueue.length);
            for (int i = 0; i < this.clientJobs.size(); ++i) {
                jobQueue[this.serverJobQueue.length + i] = this.clientJobs.get(i).getJob().getInform();
            }
        }
        finally {
            this.unlock();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Job.currentUI.showJobQueue(jobQueue);
        } else {
            Job.currentUI.addEvent(new Client.JobQueueEvent(jobQueue));
        }
    }

    private boolean isChangeJobQueuedOrRunning() {
        for (EJob ejob : this.serverJobs) {
            Job job = ejob.getJob();
            if (job != null && job.finished || ejob.jobType != Job.Type.CHANGE) continue;
            return true;
        }
        for (EJob ejob : this.clientJobs) {
            if (ejob.jobType != Job.Type.CHANGE) continue;
            return true;
        }
        return false;
    }

    @Override
    Iterator<Job> getAllJobs() {
        Job job;
        ArrayList<Job> jobsList = new ArrayList<Job>();
        for (EJob ejob : this.serverJobs) {
            job = ejob.getJob();
            if (job == null) continue;
            jobsList.add(job);
        }
        for (EJob ejob : this.clientJobs) {
            job = ejob.getJob();
            if (job == null) continue;
            jobsList.add(job);
        }
        return jobsList.iterator();
    }

    @Override
    List<Job.Inform> getAllJobInforms() {
        return Collections.emptyList();
    }

    static {
        clientSnapshot = EDatabase.clientDatabase().getInitialSnapshot();
    }

    private static class SnapshotDatabaseChangeRun
    implements Runnable {
        private Snapshot oldSnapshot;
        private Snapshot newSnapshot;

        private SnapshotDatabaseChangeRun(Snapshot oldSnapshot, Snapshot newSnapshot) {
            this.oldSnapshot = oldSnapshot;
            this.newSnapshot = newSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EDatabase database = EDatabase.clientDatabase();
            database.lock(true);
            try {
                database.checkFresh(this.oldSnapshot);
                database.lowLevelSetCanUndoing(true);
                database.getNetworkManager().startBatch();
                database.undo(this.newSnapshot);
                database.getNetworkManager().endBatch();
                database.lowLevelSetCanUndoing(false);
            }
            finally {
                database.unlock();
            }
        }
    }
}

