/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CoverageTab
extends PreferencePanel {
    private boolean layerDataChanging = false;
    private Map<Layer, GenMath.MutableDouble> layerAreaMap;
    private DefaultListModel layerListModel;
    private JList layerJList;
    private JPanel boundingSelection;
    private JTextField deltaXField;
    private JLabel deltaXLabel;
    private JTextField deltaYField;
    private JLabel deltaYLabel;
    private JTextField heightField;
    private JLabel heightLabel;
    private JLabel jLabel1;
    private JTextField layerAreaField;
    private JLabel layerAreaLabel;
    private JPanel layerCoverage;
    private JPanel layerPanel;
    private JScrollPane listScrollList;
    private JComboBox technologySelection;
    private JTextField widthField;
    private JLabel widthLabel;

    public CoverageTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.layerAreaField);
        EDialog.makeTextFieldSelectAllOnTab(this.widthField);
        EDialog.makeTextFieldSelectAllOnTab(this.heightField);
        EDialog.makeTextFieldSelectAllOnTab(this.deltaXField);
        EDialog.makeTextFieldSelectAllOnTab(this.deltaYField);
    }

    public JPanel getPanel() {
        return this.layerCoverage;
    }

    public String getName() {
        return "Coverage";
    }

    public void init() {
        this.layerAreaMap = new HashMap<Layer, GenMath.MutableDouble>();
        this.layerListModel = new DefaultListModel();
        this.layerJList = new JList(this.layerListModel);
        this.layerJList.setSelectionMode(0);
        this.listScrollList.setViewportView(this.layerJList);
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                double val = layer.getAreaCoverage();
                this.layerAreaMap.put(layer, new GenMath.MutableDouble(val));
            }
        }
        this.layerDataChanging = false;
        this.layerAreaField.getDocument().addDocumentListener(new CoverageDocumentListener(this));
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CoverageTab.this.newTechSelected();
            }
        });
        this.layerJList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CoverageTab.this.layerValueChanged(false);
            }
        });
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
    }

    private void newTechSelected() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.layerDataChanging = true;
        this.layerListModel.clear();
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            GenMath.MutableDouble val = this.layerAreaMap.get(layer);
            if (val == null) continue;
            this.layerListModel.addElement(CoverageTab.getLineString(layer, val.doubleValue()));
        }
        this.layerJList.setSelectedIndex(0);
        this.widthField.setText(Double.toString(LayerCoverageTool.getWidth(tech)));
        this.heightField.setText(Double.toString(LayerCoverageTool.getHeight(tech)));
        this.deltaXField.setText(Double.toString(LayerCoverageTool.getDeltaX(tech)));
        this.deltaYField.setText(Double.toString(LayerCoverageTool.getDeltaY(tech)));
        this.layerDataChanging = false;
        this.layerValueChanged(false);
    }

    private static String getLineString(Layer layer, double value) {
        return layer.getName() + " (" + value + ")";
    }

    private void layerValueChanged(boolean set) {
        Layer layer;
        GenMath.MutableDouble obj;
        if (this.layerDataChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String primName = (String)this.layerJList.getSelectedValue();
        int spacePos = primName.indexOf(32);
        if (spacePos >= 0) {
            primName = primName.substring(0, spacePos);
        }
        if ((obj = this.layerAreaMap.get(layer = tech.findLayer(primName))) == null) {
            return;
        }
        GenMath.MutableDouble value = obj;
        double origValue = value.doubleValue();
        if (set) {
            double val = 0.0;
            boolean foundError = false;
            String text = this.layerAreaField.getText();
            try {
                if (text.equals("")) {
                    return;
                }
                val = Double.parseDouble(text);
                foundError = val < 0.0 || val > 100.0;
            }
            catch (NumberFormatException e) {
                foundError = true;
            }
            if (foundError) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), text + " is out of range area value xfor layer '" + layer.getName() + "' (valid range 0 -> 100).");
                SwingUtilities.invokeLater(new SetOriginalValue(this.layerAreaField, origValue));
                return;
            }
            value.setValue(val);
            int lineNo = this.layerJList.getSelectedIndex();
            this.layerListModel.setElementAt(CoverageTab.getLineString(layer, val), lineNo);
        } else {
            this.layerAreaField.setText(TextUtils.formatDouble(value.doubleValue()));
        }
    }

    public void term() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech != null) {
            double val = TextUtils.atof(this.widthField.getText());
            if (val != LayerCoverageTool.getWidth(tech)) {
                LayerCoverageTool.setWidth(val, tech);
            }
            if ((val = TextUtils.atof(this.heightField.getText())) != LayerCoverageTool.getHeight(tech)) {
                LayerCoverageTool.setHeight(val, tech);
            }
            if ((val = TextUtils.atof(this.deltaXField.getText())) != LayerCoverageTool.getDeltaX(tech)) {
                LayerCoverageTool.setDeltaX(val, tech);
            }
            if ((val = TextUtils.atof(this.deltaYField.getText())) != LayerCoverageTool.getDeltaY(tech)) {
                LayerCoverageTool.setDeltaY(val, tech);
            }
        }
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            tech = tIt.next();
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                GenMath.MutableDouble obj = this.layerAreaMap.get(layer);
                if (obj == null) continue;
                GenMath.MutableDouble value = obj;
                layer.setAreaCoverageInfo(value.doubleValue());
            }
        }
    }

    public void reset() {
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (layer.getFactoryAreaCoverage() == layer.getAreaCoverage()) continue;
                layer.setAreaCoverageInfo(layer.getFactoryAreaCoverage());
            }
            if (LayerCoverageTool.getFactoryWidth(tech) != LayerCoverageTool.getWidth(tech)) {
                LayerCoverageTool.setWidth(LayerCoverageTool.getFactoryWidth(tech), tech);
            }
            if (LayerCoverageTool.getFactoryHeight(tech) != LayerCoverageTool.getHeight(tech)) {
                LayerCoverageTool.setHeight(LayerCoverageTool.getFactoryHeight(tech), tech);
            }
            if (LayerCoverageTool.getFactoryDeltaX(tech) != LayerCoverageTool.getDeltaX(tech)) {
                LayerCoverageTool.setDeltaX(LayerCoverageTool.getFactoryDeltaX(tech), tech);
            }
            if (LayerCoverageTool.getFactoryDeltaY(tech) == LayerCoverageTool.getDeltaY(tech)) continue;
            LayerCoverageTool.setDeltaY(LayerCoverageTool.getFactoryDeltaY(tech), tech);
        }
    }

    private void initComponents() {
        this.layerCoverage = new JPanel();
        this.layerPanel = new JPanel();
        this.layerAreaLabel = new JLabel();
        this.layerAreaField = new JTextField();
        this.listScrollList = new JScrollPane();
        this.boundingSelection = new JPanel();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.deltaXLabel = new JLabel();
        this.deltaXField = new JTextField();
        this.deltaYLabel = new JLabel();
        this.deltaYField = new JTextField();
        this.jLabel1 = new JLabel();
        this.technologySelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CoverageTab.this.closeDialog(evt);
            }
        });
        this.layerCoverage.setLayout(new GridBagLayout());
        this.layerPanel.setLayout(new GridBagLayout());
        this.layerPanel.setBorder(new TitledBorder("Layers:"));
        this.layerPanel.setDoubleBuffered(false);
        this.layerAreaLabel.setText("Coverage Area (%):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.layerAreaLabel, gridBagConstraints);
        this.layerAreaField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.layerAreaField, gridBagConstraints);
        this.listScrollList.setPreferredSize(new Dimension(200, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.layerPanel.add((Component)this.listScrollList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.layerCoverage.add((Component)this.layerPanel, gridBagConstraints);
        this.boundingSelection.setLayout(new GridBagLayout());
        this.boundingSelection.setBorder(new TitledBorder("Bounding Selection"));
        this.boundingSelection.setDoubleBuffered(false);
        this.widthLabel.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.widthLabel, gridBagConstraints);
        this.widthField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.widthField, gridBagConstraints);
        this.heightLabel.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.heightLabel, gridBagConstraints);
        this.heightField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.heightField, gridBagConstraints);
        this.deltaXLabel.setText("DeltaX:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaXLabel, gridBagConstraints);
        this.deltaXField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaXField, gridBagConstraints);
        this.deltaYLabel.setText("DeltaY:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaYLabel, gridBagConstraints);
        this.deltaYField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.layerCoverage.add((Component)this.boundingSelection, gridBagConstraints);
        this.jLabel1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerCoverage.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerCoverage.add((Component)this.technologySelection, gridBagConstraints);
        this.getContentPane().add((Component)this.layerCoverage, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SetOriginalValue
    implements Runnable {
        JTextField field;
        double origValue;

        public SetOriginalValue(JTextField field, double value) {
            this.field = field;
            this.origValue = value;
        }

        public void run() {
            this.field.setText(TextUtils.formatDouble(this.origValue));
        }
    }

    private static class CoverageDocumentListener
    implements DocumentListener {
        CoverageTab dialog;

        CoverageDocumentListener(CoverageTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }
    }
}

