/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.StratAdjacent;
import com.sun.electric.tool.ncc.strategy.StratCount;
import com.sun.electric.tool.ncc.strategy.StratFrontier;
import com.sun.electric.tool.ncc.strategy.StratHashParts;
import com.sun.electric.tool.ncc.strategy.StratHashWires;
import com.sun.electric.tool.ncc.strategy.StratPortName;
import com.sun.electric.tool.ncc.strategy.StratRandomMatch;
import com.sun.electric.tool.ncc.strategy.StratResult;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.Iterator;

public class HashCodePartitioning {
    NccGlobals globals;

    private void error(boolean pred, String msg) {
        this.globals.error(msg);
    }

    private LeafList hashFrontierParts() {
        if (this.globals.getParts() == null) {
            return new LeafList();
        }
        this.globals.println("----- hash all Parts on frontier");
        LeafList frontier = StratFrontier.doYourJob(this.globals.getParts(), this.globals);
        LeafList offspring = StratHashParts.doYourJob(frontier, this.globals);
        return offspring;
    }

    private LeafList hashFrontierWires() {
        if (this.globals.getParts() == null) {
            return new LeafList();
        }
        this.globals.println("----- hash all Wires on frontier");
        LeafList frontier = StratFrontier.doYourJob(this.globals.getWires(), this.globals);
        LeafList offspring = StratHashWires.doYourJob(frontier, this.globals);
        return offspring;
    }

    private boolean isPartsList(LeafList el) {
        EquivRecord er = el.get(0);
        return er.getNetObjType() == NetObject.Type.PART;
    }

    private void chaseRetired(LeafList newDivided) {
        if (newDivided.size() == 0) {
            return;
        }
        this.globals.println("------ starting chaseRetired");
        int i = 0;
        while (newDivided.size() != 0) {
            LeafList adjacent;
            this.globals.println("------ chaseRetired pass: " + i++);
            LeafList newRetired = newDivided.selectRetired(this.globals);
            if (newRetired.size() == 0 || (adjacent = StratAdjacent.doYourJob(newRetired, this.globals)).size() == 0) break;
            boolean doParts = this.isPartsList(adjacent);
            newDivided = doParts ? StratHashParts.doYourJob(adjacent, this.globals) : StratHashWires.doYourJob(adjacent, this.globals);
        }
        this.globals.println("------ done  chaseRetired after " + i + " passes");
        this.globals.println();
    }

    private void hashFrontier() {
        LeafList wireOffspring;
        LeafList partOffspring;
        this.globals.println("----- hash all NetObjects on frontier");
        do {
            partOffspring = this.hashFrontierParts();
            this.chaseRetired(partOffspring);
            wireOffspring = this.hashFrontierWires();
            this.chaseRetired(wireOffspring);
        } while (partOffspring.size() != 0 || wireOffspring.size() != 0);
    }

    private boolean done() {
        LeafList p = StratFrontier.doYourJob(this.globals.getParts(), this.globals);
        LeafList w = StratFrontier.doYourJob(this.globals.getWires(), this.globals);
        return p.size() == 0 && w.size() == 0;
    }

    private void useExportNames() {
        this.globals.println("----- use Export Names");
        while (true) {
            StratCount.doYourJob(this.globals.getRoot(), this.globals);
            LeafList offspring = StratPortName.doYourJob(this.globals);
            if (offspring.size() == 0) break;
            this.chaseRetired(offspring);
            this.hashFrontier();
        }
    }

    private EquivRecord findSmallestActive(EquivRecord root) {
        LeafList frontier = StratFrontier.doYourJob(root, this.globals);
        int minSz = Integer.MAX_VALUE;
        EquivRecord minRec = null;
        Iterator ri = frontier.iterator();
        while (ri.hasNext()) {
            int sz;
            EquivRecord r = (EquivRecord)ri.next();
            if (r.isMismatched() || (sz = r.maxSize()) >= minSz) continue;
            minSz = sz;
            minRec = r;
        }
        return minRec;
    }

    private EquivRecord findSmallestActive() {
        EquivRecord w = this.findSmallestActive(this.globals.getWires());
        EquivRecord p = this.findSmallestActive(this.globals.getParts());
        if (p == null) {
            return w;
        }
        if (w == null) {
            return p;
        }
        return p.maxSize() < w.maxSize() ? p : w;
    }

    private void randomMatch() {
        this.globals.println("----- random matching");
        EquivRecord smallest;
        while ((smallest = this.findSmallestActive()) != null) {
            LeafList el = new LeafList();
            el.add(smallest);
            LeafList offspring = StratRandomMatch.doYourJob(el, this.globals);
            if (offspring.size() == 0) continue;
            this.chaseRetired(offspring);
        }
        return;
    }

    private HashCodePartitioning(NccGlobals globals) {
        this.globals = globals;
        globals.println("----- starting HashCodePartitioning");
        if (!this.done()) {
            this.hashFrontier();
        }
        if (!this.done()) {
            this.useExportNames();
        }
        NccOptions options = globals.getOptions();
        StratCount.doYourJob(globals.getRoot(), globals);
        if (!this.done()) {
            this.randomMatch();
        }
        globals.println("----- done HashCodePartitioning");
    }

    public static boolean doYourJob(NccGlobals globals) {
        new HashCodePartitioning(globals);
        return StratResult.doYourJob(globals);
    }
}

