/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;

public abstract class FoldedMos {
    private static final double difWidHint = 4.0;
    private static final double minDifContWid = 5.0;
    private static final GateSpace useMinSp = new GateSpace(){

        public double getExtraSpace(double requiredExtraSpace, int foldNdx, int nbFolds, int spaceNdx, int nbGates) {
            return requiredExtraSpace;
        }
    };
    private PortInst[] diffVias;
    private NodeInst[] moss;
    private PortInst[] internalDiffs;
    private double difContWid;
    private double gateWidth;
    private double physWidth;
    private double mosY;
    private static final String nDiffLeft = "n-trans-diff-top";
    private static final String nDiffRight = "n-trans-diff-bottom";
    private static final String nPolyBot = "n-trans-poly-left";
    private static final String nPolyTop = "n-trans-poly-right";
    private static final String pDiffLeft = "p-trans-diff-top";
    private static final String pDiffRight = "p-trans-diff-bottom";
    private static final String pPolyBot = "p-trans-poly-left";
    private static final String pPolyTop = "p-trans-poly-right";

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private boolean isPmos() {
        return this instanceof FoldedPmos;
    }

    double roundToHalfLambda(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    private void newDiffArc(ArcProto diff, double y, PortInst p1, PortInst p2) {
        double x1 = this.roundToHalfLambda(p1.getBounds().getCenterX());
        double x2 = this.roundToHalfLambda(p2.getBounds().getCenterX());
        LayoutLib.newArcInst(diff, Double.POSITIVE_INFINITY, p1, x1, y, p2, x2, y);
    }

    FoldedMos(char type, double x, double y, int nbFolds, int nbSeries, double gateWidth, GateSpace gateSpace, char justifyDiffCont, Cell f) {
        FoldedMos.error(type != 'P' && type != 'N', "FoldedMos: type must be 'P' or 'N': " + type);
        this.gateWidth = gateWidth;
        this.physWidth = Math.max(5.0, gateWidth);
        this.diffVias = new PortInst[nbFolds + 1];
        this.moss = new NodeInst[nbFolds * nbSeries];
        this.internalDiffs = new PortInst[nbFolds * (nbSeries - 1)];
        if (gateSpace == null) {
            gateSpace = useMinSp;
        }
        PrimitiveNode mos = this.isPmos() ? Tech.pmos : Tech.nmos;
        PrimitiveNode diffCont = this.isPmos() ? Tech.pdm1 : Tech.ndm1;
        PrimitiveArc diff = this.isPmos() ? Tech.pdiff : Tech.ndiff;
        PrimitiveNode difNod = this.isPmos() ? Tech.pdNode : Tech.ndNode;
        String diffLeft = this.isPmos() ? pDiffLeft : nDiffLeft;
        String diffRight = this.isPmos() ? pDiffRight : nDiffRight;
        double foldPitch = 8 + (nbSeries - 1) * 5;
        int diffNdx = 0;
        int mosNdx = 0;
        int internalDiffNdx = 0;
        this.difContWid = Math.max(5.0, (double)((int)gateWidth / 5 * 5));
        double difContSlop = Math.max(0.0, (gateWidth - this.difContWid) / 2.0);
        double difContY = y;
        switch (justifyDiffCont) {
            case 'T': {
                difContY += difContSlop;
                break;
            }
            case 'B': {
                difContY -= difContSlop;
                break;
            }
            default: {
                FoldedMos.error(true, "FoldedMos: justifyDiffCont must be 'T', or 'B'");
            }
        }
        this.mosY = y;
        if (gateWidth < 5.0) {
            double mosBotY = y - gateWidth / 2.0;
            double misAlign = Math.IEEEremainder(mosBotY, 0.5);
            this.mosY -= misAlign;
        }
        double extraDiffPolySpace = gateWidth >= 5.0 ? 0.0 : 0.5;
        double viaToMosPitch = 4.0;
        double mosToMosPitch = 5.0;
        PortInst prevPort = null;
        int i = 0;
        while (true) {
            PortInst newPort = LayoutLib.newNodeInst(diffCont, x, difContY, Double.POSITIVE_INFINITY, this.difContWid, 0.0, f).getOnlyPortInst();
            LayoutLib.newArcInst(diff, 4.0, newPort, newPort);
            this.diffVias[diffNdx++] = newPort;
            if (prevPort != null) {
                this.newDiffArc(diff, difContY, prevPort, newPort);
            }
            prevPort = newPort;
            if (i >= nbFolds) break;
            for (int j = 0; j < nbSeries; ++j) {
                double extraSp = gateSpace.getExtraSpace(j == 0 ? extraDiffPolySpace : 0.0, i, nbFolds, j, nbSeries);
                if (j == 0 && extraSp != 0.0) {
                    double w = Math.ceil(extraSp);
                    NodeInst dn = LayoutLib.newNodeInst(difNod, x + w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                    this.newDiffArc(diff, difContY, prevPort, dn.getOnlyPortInst());
                }
                NodeInst m = LayoutLib.newNodeInst(mos, x += (j == 0 ? viaToMosPitch : mosToMosPitch) + extraSp, this.mosY, gateWidth, 2.0, 90.0, f);
                this.moss[mosNdx++] = m;
                this.newDiffArc(diff, difContY, prevPort, m.findPortInst(diffLeft));
                prevPort = m.findPortInst(diffRight);
                if (j == 0) continue;
                this.internalDiffs[internalDiffNdx++] = m.findPortInst(diffLeft);
            }
            double extraSp = gateSpace.getExtraSpace(extraDiffPolySpace, i, nbFolds, nbSeries, nbSeries);
            x += viaToMosPitch + extraSp;
            if (extraSp != 0.0) {
                double w = Math.ceil(extraSp);
                NodeInst dn = LayoutLib.newNodeInst(difNod, x - w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                this.newDiffArc(diff, difContY, prevPort, dn.getOnlyPortInst());
            }
            ++i;
        }
    }

    public double getGateWidth() {
        return this.gateWidth;
    }

    public double getPhysWidth() {
        return this.physWidth;
    }

    public double getMosCenterY() {
        return this.mosY;
    }

    public double getDiffContWidth() {
        return this.difContWid;
    }

    public int nbSrcDrns() {
        return this.diffVias.length;
    }

    public PortInst getSrcDrn(int col) {
        return this.diffVias[col];
    }

    public int nbGates() {
        return this.moss.length;
    }

    public PortInst getGate(int mosNdx, char pos) {
        FoldedMos.error(pos != 'T' && pos != 'B', "pos must be 'T' or 'B': " + pos);
        String polyTop = this.isPmos() ? pPolyTop : nPolyTop;
        String polyBot = this.isPmos() ? pPolyBot : nPolyBot;
        String polyPP = pos == 'T' ? polyTop : polyBot;
        return this.moss[mosNdx].findPortInst(polyPP);
    }

    public int nbInternalSrcDrns() {
        return this.internalDiffs.length;
    }

    public PortInst getInternalSrcDrn(int col) {
        return this.internalDiffs[col];
    }

    public static interface GateSpace {
        public double getExtraSpace(double var1, int var3, int var4, int var5, int var6);
    }
}

