/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public class TextDescriptor {
    private static final int VTPOSITION = 15;
    private static final int VTPOSCENT = 0;
    private static final int VTPOSUP = 1;
    private static final int VTPOSDOWN = 2;
    private static final int VTPOSLEFT = 3;
    private static final int VTPOSRIGHT = 4;
    private static final int VTPOSUPLEFT = 5;
    private static final int VTPOSUPRIGHT = 6;
    private static final int VTPOSDOWNLEFT = 7;
    private static final int VTPOSDOWNRIGHT = 8;
    private static final int VTPOSBOXED = 9;
    private static final int VTDISPLAYPART = 48;
    private static final int VTDISPLAYPARTSH = 4;
    private static final int VTDISPLAYVALUE = 0;
    private static final int VTDISPLAYNAMEVALUE = 2;
    private static final int VTDISPLAYNAMEVALINH = 1;
    private static final int VTDISPLAYNAMEVALINHALL = 3;
    private static final int VTITALIC = 64;
    private static final int VTBOLD = 128;
    private static final int VTUNDERLINE = 256;
    private static final int VTISPARAMETER = 512;
    private static final int VTINTERIOR = 1024;
    private static final int VTINHERIT = 2048;
    private static final int VTXOFF = 0x1FF000;
    private static final int VTXOFFSH = 12;
    private static final int VTXOFFNEG = 0x200000;
    private static final int VTYOFF = 2143289344;
    private static final int VTYOFFSH = 22;
    private static final int VTYOFFNEG = Integer.MIN_VALUE;
    private static final int VTOFFMASKWID = 9;
    private static final int VTSIZE = Short.MAX_VALUE;
    private static final int VTSIZESH = 0;
    private static final int VTFACE = 4161536;
    private static final int VTFACESH = 15;
    private static final int VTROTATION = 0xC00000;
    private static final int VTROTATIONSH = 22;
    private static final int VTMAXFACE = 128;
    private static final int VTOFFSCALE = 0x1F000000;
    private static final int VTOFFSCALESH = 24;
    private static final int VTUNITS = -536870912;
    private static final int VTUNITSHMASK = 7;
    private static final int VTUNITSSH = 29;
    private static final int VTUNITSNONE = 0;
    private static final int VTUNITSRES = 1;
    private static final int VTUNITSCAP = 2;
    private static final int VTUNITSIND = 3;
    private static final int VTUNITSCUR = 4;
    private static final int VTUNITSVOLT = 5;
    private static final int VTUNITSDIST = 6;
    private static final int VTUNITSTIME = 7;
    private static final int TXTMAXPOINTS = 63;
    private static final int TXTQGRIDSH = 6;
    private static final double TXTMAXQGRID = 127.75;
    private int descriptor0;
    private int descriptor1;
    ElectricObject owner;
    private static Preferences prefs = Preferences.userNodeForPackage(TextDescriptor.class);
    private static Pref cacheNodeDescriptor = Pref.makeLongPref("TextDescriptorForNode", prefs, 256L);
    private static Pref cacheNodeFont = Pref.makeStringPref("TextDescriptorFontForNode", prefs, "");
    private static Pref cacheArcDescriptor = Pref.makeLongPref("TextDescriptorForArc", prefs, 256L);
    private static Pref cacheArcFont = Pref.makeStringPref("TextDescriptorFontForArc", prefs, "");
    private static Pref cacheExportDescriptor = Pref.makeLongPref("TextDescriptorForExport", prefs, 512L);
    private static Pref cacheExportFont = Pref.makeStringPref("TextDescriptorFontForExport", prefs, "");
    private static Pref cacheAnnotationDescriptor = Pref.makeLongPref("TextDescriptorForAnnotation", prefs, 256L);
    private static Pref cacheAnnotationFont = Pref.makeStringPref("TextDescriptorFontForAnnotation", prefs, "");
    private static Pref cacheInstanceDescriptor = Pref.makeLongPref("TextDescriptorForInstance", prefs, 1024L);
    private static Pref cacheInstanceFont = Pref.makeStringPref("TextDescriptorFontForInstance", prefs, "");
    private static Pref cacheCellDescriptor = Pref.makeLongPref("TextDescriptorForCell", prefs, 256L);
    private static Pref cacheCellFont = Pref.makeStringPref("TextDescriptorFontForCell", prefs, "");

    public TextDescriptor(ElectricObject owner) {
        this.owner = owner;
        this.descriptor1 = 0;
        this.descriptor0 = 0;
    }

    public TextDescriptor(ElectricObject owner, TextDescriptor descriptor) {
        this.owner = owner;
        this.descriptor0 = descriptor.descriptor0;
        this.descriptor1 = descriptor.descriptor1;
    }

    public TextDescriptor(ElectricObject owner, int descriptor0, int descriptor1) {
        this.owner = owner;
        this.descriptor0 = descriptor0;
        this.descriptor1 = descriptor1;
    }

    public TextDescriptor(ElectricObject owner, long descriptor) {
        this.owner = owner;
        this.descriptor0 = (int)(descriptor >> 32);
        this.descriptor1 = (int)(descriptor & 0xFFFFFFFFFFFFFFFFL);
    }

    public static TextDescriptor getNodeTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheNodeDescriptor.getLong());
        String fontName = TextDescriptor.getNodeTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setNodeTextDescriptor(TextDescriptor td) {
        cacheNodeDescriptor.setLong(td.lowLevelGet());
    }

    public static String getNodeTextDescriptorFont() {
        return cacheNodeFont.getString();
    }

    public static void setNodeTextDescriptorFont(String font) {
        cacheNodeFont.setString(font);
    }

    public static TextDescriptor getArcTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheArcDescriptor.getLong());
        String fontName = TextDescriptor.getArcTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setArcTextDescriptor(TextDescriptor td) {
        cacheArcDescriptor.setLong(td.lowLevelGet());
    }

    public static String getArcTextDescriptorFont() {
        return cacheArcFont.getString();
    }

    public static void setArcTextDescriptorFont(String font) {
        cacheArcFont.setString(font);
    }

    public static TextDescriptor getExportTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheExportDescriptor.getLong());
        String fontName = TextDescriptor.getExportTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setExportTextDescriptor(TextDescriptor td) {
        cacheExportDescriptor.setLong(td.lowLevelGet());
    }

    public static String getExportTextDescriptorFont() {
        return cacheExportFont.getString();
    }

    public static void setExportTextDescriptorFont(String font) {
        cacheExportFont.setString(font);
    }

    public static TextDescriptor getAnnotationTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheAnnotationDescriptor.getLong());
        String fontName = TextDescriptor.getAnnotationTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setAnnotationTextDescriptor(TextDescriptor td) {
        cacheAnnotationDescriptor.setLong(td.lowLevelGet());
    }

    public static String getAnnotationTextDescriptorFont() {
        return cacheAnnotationFont.getString();
    }

    public static void setAnnotationTextDescriptorFont(String font) {
        cacheAnnotationFont.setString(font);
    }

    public static TextDescriptor getInstanceTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheInstanceDescriptor.getLong());
        String fontName = TextDescriptor.getInstanceTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setInstanceTextDescriptor(TextDescriptor td) {
        cacheInstanceDescriptor.setLong(td.lowLevelGet());
    }

    public static String getInstanceTextDescriptorFont() {
        return cacheInstanceFont.getString();
    }

    public static void setInstanceTextDescriptorFont(String font) {
        cacheInstanceFont.setString(font);
    }

    public static TextDescriptor getCellTextDescriptor(ElectricObject owner) {
        TextDescriptor td = new TextDescriptor(owner, cacheCellDescriptor.getLong());
        String fontName = TextDescriptor.getCellTextDescriptorFont();
        if (fontName.length() > 0) {
            td.setFace(ActiveFont.findActiveFont(fontName).getIndex());
        }
        return td;
    }

    public static void setCellTextDescriptor(TextDescriptor td) {
        cacheCellDescriptor.setLong(td.lowLevelGet());
    }

    public static String getCellTextDescriptorFont() {
        return cacheCellFont.getString();
    }

    public static void setCellTextDescriptorFont(String font) {
        cacheCellFont.setString(font);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof TextDescriptor) {
            TextDescriptor td = (TextDescriptor)anObject;
            return this.descriptor0 == td.descriptor0 && this.descriptor1 == td.descriptor1;
        }
        return false;
    }

    private void checkChanging() {
        if (this.owner == null || !this.owner.inDatabase()) {
            return;
        }
        this.owner.checkChanging();
        Undo.modifyTextDescript(this.owner, this, this.descriptor0, this.descriptor1);
    }

    public void setSmartPlacement() {
        if (!(this.owner instanceof Export)) {
            return;
        }
        int smartVertical = User.getSmartVerticalPlacement();
        int smartHorizontal = User.getSmartHorizontalPlacement();
        if (smartVertical == 0 && smartHorizontal == 0) {
            return;
        }
        double dx = 0.0;
        double dy = 0.0;
        Export pp = (Export)this.owner;
        PortInst pi = pp.getOriginalPort();
        NodeInst ni = pi.getNodeInst();
        Rectangle2D nodeBounds = ni.getBounds();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            if (con.getPortInst() != pi) continue;
            ArcInst ai = con.getArc();
            Rectangle2D arcBounds = ai.getBounds();
            dx = arcBounds.getCenterX() - nodeBounds.getCenterX();
            dy = arcBounds.getCenterY() - nodeBounds.getCenterY();
        }
        boolean goleft = false;
        boolean goright = false;
        boolean goup = false;
        boolean godown = false;
        if (smartHorizontal == 1) {
            if (dx > 0.0) {
                goright = true;
            } else if (dx < 0.0) {
                goleft = true;
            }
        } else if (smartHorizontal == 2) {
            if (dx > 0.0) {
                goleft = true;
            } else if (dx < 0.0) {
                goright = true;
            }
        }
        if (smartVertical == 1) {
            if (dy > 0.0) {
                goup = true;
            } else if (dy < 0.0) {
                godown = true;
            }
        } else if (smartVertical == 2) {
            if (dy > 0.0) {
                godown = true;
            } else if (dy < 0.0) {
                goup = true;
            }
        }
        if (goleft) {
            if (this.getPos() == Position.CENT || this.getPos() == Position.RIGHT || this.getPos() == Position.LEFT) {
                this.setPos(Position.LEFT);
            } else if (this.getPos() == Position.UP || this.getPos() == Position.UPRIGHT || this.getPos() == Position.UPLEFT) {
                this.setPos(Position.UPLEFT);
            } else if (this.getPos() == Position.DOWN || this.getPos() == Position.DOWNRIGHT || this.getPos() == Position.DOWNLEFT) {
                this.setPos(Position.DOWNLEFT);
            }
        }
        if (goright) {
            if (this.getPos() == Position.CENT || this.getPos() == Position.RIGHT || this.getPos() == Position.LEFT) {
                this.setPos(Position.RIGHT);
            } else if (this.getPos() == Position.UP || this.getPos() == Position.UPRIGHT || this.getPos() == Position.UPLEFT) {
                this.setPos(Position.UPRIGHT);
            } else if (this.getPos() == Position.DOWN || this.getPos() == Position.DOWNRIGHT || this.getPos() == Position.DOWNLEFT) {
                this.setPos(Position.DOWNRIGHT);
            }
        }
        if (goup) {
            if (this.getPos() == Position.CENT || this.getPos() == Position.UP || this.getPos() == Position.DOWN) {
                this.setPos(Position.UP);
            } else if (this.getPos() == Position.RIGHT || this.getPos() == Position.UPRIGHT || this.getPos() == Position.DOWNRIGHT) {
                this.setPos(Position.UPRIGHT);
            } else if (this.getPos() == Position.LEFT || this.getPos() == Position.UPLEFT || this.getPos() == Position.DOWNLEFT) {
                this.setPos(Position.UPLEFT);
            }
        }
        if (godown) {
            if (this.getPos() == Position.CENT || this.getPos() == Position.UP || this.getPos() == Position.DOWN) {
                this.setPos(Position.DOWN);
            } else if (this.getPos() == Position.RIGHT || this.getPos() == Position.UPRIGHT || this.getPos() == Position.DOWNRIGHT) {
                this.setPos(Position.DOWNRIGHT);
            } else if (this.getPos() == Position.LEFT || this.getPos() == Position.UPLEFT || this.getPos() == Position.DOWNLEFT) {
                this.setPos(Position.DOWNLEFT);
            }
        }
    }

    public void lowLevelSet(int descriptor0, int descriptor1) {
        this.descriptor0 = descriptor0;
        this.descriptor1 = descriptor1;
    }

    public void lowLevelSet(long descriptor) {
        this.descriptor0 = (int)(descriptor >> 32);
        this.descriptor1 = (int)(descriptor & 0xFFFFFFFFFFFFFFFFL);
    }

    public void copy(TextDescriptor descriptor) {
        this.checkChanging();
        this.descriptor0 = descriptor.descriptor0;
        this.descriptor1 = descriptor.descriptor1;
    }

    public boolean compare(TextDescriptor descriptor) {
        return this.descriptor0 == descriptor.descriptor0 && this.descriptor1 == descriptor.descriptor1;
    }

    public int lowLevelGet0() {
        return this.descriptor0;
    }

    public int lowLevelGet1() {
        return this.descriptor1;
    }

    public long lowLevelGet() {
        return (long)this.descriptor0 << 32 | (long)this.descriptor1;
    }

    public Position getPos() {
        int pos = this.descriptor0 & 0xF;
        if (pos >= Position.getNumPositions()) {
            pos = 0;
        }
        return Position.getPositionAt(pos);
    }

    public void setPos(Position p) {
        this.checkChanging();
        this.descriptor0 = this.descriptor0 & 0xFFFFFFF0 | p.getIndex();
    }

    public Size getSize() {
        int textSize = (this.descriptor1 & Short.MAX_VALUE) >> 0;
        if (textSize == 0) {
            return Size.newRelSize(1.0);
        }
        if (textSize <= 63) {
            return Size.newAbsSize(textSize);
        }
        int sizeValue = textSize >> 6;
        double size = (double)sizeValue / 4.0;
        return Size.newRelSize(size);
    }

    public int getTrueSize(EditWindow wnd) {
        Size s = this.getSize();
        if (s == null) {
            return 14;
        }
        if (s.isAbsolute()) {
            return (int)s.getSize();
        }
        double height = s.getSize();
        return wnd.getTextPointSize(height);
    }

    public void setAbsSize(int s) {
        Size size = Size.newAbsSize(s);
        if (size == null) {
            return;
        }
        if (this.owner != null) {
            this.checkChanging();
        }
        this.descriptor1 = this.descriptor1 & Short.MIN_VALUE | size.getBits() << 0;
    }

    public void setRelSize(double s) {
        Size size = Size.newRelSize(s);
        if (size == null) {
            return;
        }
        if (this.owner != null) {
            this.checkChanging();
        }
        this.descriptor1 = this.descriptor1 & Short.MIN_VALUE | size.getBits() << 0;
    }

    public int getFace() {
        return (this.descriptor1 & 0x3F8000) >> 15;
    }

    public void setFace(int f) {
        this.checkChanging();
        this.descriptor1 = this.descriptor1 & 0xFFC07FFF | f << 15;
    }

    public Rotation getRotation() {
        return Rotation.getRotationAt((this.descriptor1 & 0xC00000) >> 22);
    }

    public void setRotation(Rotation r) {
        this.checkChanging();
        this.descriptor1 = this.descriptor1 & 0xFF3FFFFF | r.getIndex() << 22;
    }

    public DispPos getDispPart() {
        return DispPos.getShowStylesAt((this.descriptor0 & 0x30) >> 4);
    }

    public void setDispPart(DispPos d) {
        this.checkChanging();
        this.descriptor0 = this.descriptor0 & 0xFFFFFFCF | d.getIndex() << 4;
    }

    public boolean isItalic() {
        return (this.descriptor0 & 0x40) != 0;
    }

    public void setItalic(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x40) : (this.descriptor0 &= 0xFFFFFFBF);
    }

    public boolean isBold() {
        return (this.descriptor0 & 0x80) != 0;
    }

    public void setBold(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x80) : (this.descriptor0 &= 0xFFFFFF7F);
    }

    public boolean isUnderline() {
        return (this.descriptor0 & 0x100) != 0;
    }

    public void setUnderline(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x100) : (this.descriptor0 &= 0xFFFFFEFF);
    }

    public boolean isInterior() {
        return (this.descriptor0 & 0x400) != 0;
    }

    public void setInterior(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x400) : (this.descriptor0 &= 0xFFFFFBFF);
    }

    public boolean isInherit() {
        return (this.descriptor0 & 0x800) != 0;
    }

    public void setInherit(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x800) : (this.descriptor0 &= 0xFFFFF7FF);
    }

    public boolean isParam() {
        return (this.descriptor0 & 0x200) != 0;
    }

    public void setParam(boolean state) {
        this.checkChanging();
        this.descriptor0 = state ? (this.descriptor0 |= 0x200) : (this.descriptor0 &= 0xFFFFFDFF);
    }

    public double getXOff() {
        int offset = (this.descriptor0 & 0x1FF000) >> 12;
        if ((this.descriptor0 & 0x200000) != 0) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    public double getYOff() {
        int offset = (this.descriptor0 & 0x7FC00000) >> 22;
        if ((this.descriptor0 & Integer.MIN_VALUE) != 0) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    public void setOff(double xd, double yd) {
        this.checkChanging();
        int x = (int)(xd * 4.0);
        int y = (int)(yd * 4.0);
        this.descriptor0 &= 0xFFF;
        if (x < 0) {
            x = -x;
            this.descriptor0 |= 0x200000;
        }
        if (y < 0) {
            y = -y;
            this.descriptor0 |= Integer.MIN_VALUE;
        }
        int scale = Math.max(x, y) >> 9;
        this.descriptor0 |= (x /= scale + 1) << 12 & 0x1FF000;
        this.descriptor0 |= (y /= scale + 1) << 22 & 0x7FC00000;
        this.descriptor1 = this.descriptor1 & 0xE0FFFFFF | scale << 24 & 0x1F000000;
    }

    private int getOffScale() {
        return (this.descriptor1 & 0x1F000000) >> 24;
    }

    public Unit getUnit() {
        return Unit.getUnitAt((this.descriptor1 & 0xE0000000) >> 29 & 7);
    }

    public void setUnit(Unit u) {
        this.checkChanging();
        this.descriptor1 = this.descriptor1 & 0x1FFFFFFF | u.getIndex() << 29;
    }

    public static class ActiveFont {
        private String fontName;
        private int index = ++indexCount;
        private static int indexCount = 0;
        private static HashMap fontMap = new HashMap();
        private static List fontList = new ArrayList();

        private ActiveFont(String fontName) {
            this.fontName = fontName;
            fontMap.put(fontName, this);
            fontList.add(this);
        }

        public static int getMaxIndex() {
            return indexCount;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.fontName;
        }

        public static ActiveFont findActiveFont(String fontName) {
            ActiveFont af = (ActiveFont)fontMap.get(fontName);
            if (af == null) {
                af = new ActiveFont(fontName);
            }
            return af;
        }

        public static ActiveFont findActiveFont(int index) {
            if (index <= 0) {
                return null;
            }
            if (index > fontList.size()) {
                return null;
            }
            ActiveFont af = (ActiveFont)fontList.get(index - 1);
            return af;
        }

        public String toString() {
            return this.fontName;
        }
    }

    public static class Unit {
        private final String name;
        private final int index;
        private static List units = new ArrayList();
        public static final Unit NONE = new Unit("none", 0);
        public static final Unit RESISTANCE = new Unit("resistance", 1);
        public static final Unit CAPACITANCE = new Unit("capacitance", 2);
        public static final Unit INDUCTANCE = new Unit("inductance", 3);
        public static final Unit CURRENT = new Unit("current", 4);
        public static final Unit VOLTAGE = new Unit("voltage", 5);
        public static final Unit DISTANCE = new Unit("distance", 6);
        public static final Unit TIME = new Unit("time", 7);

        private Unit(String name, int index) {
            this.name = name;
            this.index = index;
            units.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.name;
        }

        public static int getNumUnits() {
            return units.size();
        }

        public static Unit getUnitAt(int index) {
            return (Unit)units.get(index);
        }

        public static Iterator getUnits() {
            return units.iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Rotation {
        private final int angle;
        private final int index;
        private final String name;
        private static List rotations = new ArrayList();
        public static final Rotation ROT0 = new Rotation(0, 0, "None");
        public static final Rotation ROT90 = new Rotation(90, 1, "90 degrees counterclockwise");
        public static final Rotation ROT180 = new Rotation(180, 2, "180 degrees");
        public static final Rotation ROT270 = new Rotation(270, 3, "90 degrees clockwise");

        private Rotation(int angle, int index, String name) {
            this.angle = angle;
            this.index = index;
            this.name = name;
            rotations.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.name;
        }

        public int getAngle() {
            return this.angle;
        }

        public static Rotation getRotation(int angle) {
            Iterator it = rotations.iterator();
            while (it.hasNext()) {
                Rotation rot = (Rotation)it.next();
                if (rot.getAngle() != angle) continue;
                return rot;
            }
            return null;
        }

        public static int getNumRotations() {
            return rotations.size();
        }

        public static Rotation getRotationAt(int index) {
            return (Rotation)rotations.get(index);
        }

        public static Iterator getRotations() {
            return rotations.iterator();
        }

        public String toString() {
            return "Text Rotation " + this.angle;
        }
    }

    public static class Size {
        private final boolean absolute;
        private final double size;
        private final int bits;

        private Size(double size, boolean absolute) {
            this.size = size;
            this.absolute = absolute;
            this.bits = absolute ? (int)size : (int)(size * 4.0) << 6;
        }

        private int getBits() {
            return this.bits;
        }

        public static Size newAbsSize(int size) {
            if (size <= 0 || size > 63) {
                return null;
            }
            return new Size(size, true);
        }

        public static Size newRelSize(double size) {
            if (size <= 0.0 || size > 127.75) {
                return null;
            }
            return new Size(size, false);
        }

        public double getSize() {
            return this.size;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public boolean equals(Size other) {
            if (this.absolute != other.absolute) {
                return false;
            }
            return DBMath.doublesEqual(this.size, other.size);
        }

        public String toString() {
            return "Text Size";
        }
    }

    public static class DispPos {
        private final String name;
        private final int index;
        private static List positions = new ArrayList();
        public static final DispPos VALUE = new DispPos("value", 0);
        public static final DispPos NAMEVALINH = new DispPos("name=inherit;def=value", 1);
        public static final DispPos NAMEVALUE = new DispPos("name=value", 2);
        public static final DispPos NAMEVALINHALL = new DispPos("name=inheritAll;def=value", 3);

        private DispPos(String name, int index) {
            this.name = name;
            this.index = index;
            positions.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static int getNumShowStyles() {
            return positions.size();
        }

        public static DispPos getShowStylesAt(int index) {
            return (DispPos)positions.get(index);
        }

        public static Iterator getShowStyles() {
            return positions.iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Position {
        private final String name;
        private final int index;
        private final Poly.Type pt;
        private static List positions = new ArrayList();
        public static final Position CENT = new Position("centered", 0, Poly.Type.TEXTCENT);
        public static final Position UP = new Position("top", 1, Poly.Type.TEXTBOT);
        public static final Position DOWN = new Position("bottom", 2, Poly.Type.TEXTTOP);
        public static final Position LEFT = new Position("left", 3, Poly.Type.TEXTRIGHT);
        public static final Position RIGHT = new Position("right", 4, Poly.Type.TEXTLEFT);
        public static final Position UPLEFT = new Position("upper-left", 5, Poly.Type.TEXTBOTRIGHT);
        public static final Position UPRIGHT = new Position("upper-right", 6, Poly.Type.TEXTBOTLEFT);
        public static final Position DOWNLEFT = new Position("lower-left", 7, Poly.Type.TEXTTOPRIGHT);
        public static final Position DOWNRIGHT = new Position("lower-right", 8, Poly.Type.TEXTTOPLEFT);
        public static final Position BOXED = new Position("boxed", 9, Poly.Type.TEXTBOX);

        private Position(String name, int index, Poly.Type pt) {
            this.name = name;
            this.index = index;
            this.pt = pt;
            positions.add(index, this);
        }

        private int getIndex() {
            return this.index;
        }

        public Poly.Type getPolyType() {
            return this.pt;
        }

        public static int getNumPositions() {
            return positions.size();
        }

        public static Position getPositionAt(int index) {
            return (Position)positions.get(index);
        }

        public static Iterator getPositions() {
            return positions.iterator();
        }

        public String toString() {
            return this.name;
        }
    }
}

