/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.presentation.Button;
import org.xmind.ui.internal.presentation.ControlPanel;
import org.xmind.ui.internal.presentation.Presentation;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.Slider;

public class ControlPanelFactory {
    private static final String PATH = "/icons/panel/";
    private static final List<String> IDS = Arrays.asList("next", "into", "light", "zoom", "slider", "sidebar", "quit");
    private static ControlPanelFactory impl = null;
    private final Dimension prefSize;
    private final ImageDescriptor controlPanelNightImage;
    private final Collection<ButtonDescriptor> buttonRegistry;
    private final Collection<SliderDescriptor> sliderRegistry;

    private ControlPanelFactory() {
        Document doc = ControlPanelFactory.getDocument();
        if (doc != null) {
            Element docEle = doc.getDocumentElement();
            Element panelEle = DOMUtils.getFirstChildElementByTag((Node)docEle, (String)"panel");
            if (panelEle != null) {
                String _width = panelEle.getAttribute("width");
                String _height = panelEle.getAttribute("height");
                if (!ControlPanelFactory.isEmpty(_width) && !ControlPanelFactory.isEmpty(_height)) {
                    int width = ControlPanelFactory.safeParseInt(_width, 0);
                    int height = ControlPanelFactory.safeParseInt(_height, 0);
                    this.prefSize = new Dimension(width, height);
                } else {
                    this.prefSize = null;
                }
                String night_src = panelEle.getAttribute("night-src");
                ImageDescriptor nightImage = ControlPanelFactory.checkValidImage(ControlPanelFactory.getImageDescriptor(night_src));
                if (nightImage == null) {
                    nightImage = ImageDescriptor.getMissingImageDescriptor();
                }
                this.controlPanelNightImage = nightImage;
            } else {
                this.prefSize = null;
                this.controlPanelNightImage = ImageDescriptor.getMissingImageDescriptor();
            }
            Element buttonsEle = DOMUtils.getFirstChildElementByTag((Node)docEle, (String)"buttons");
            if (buttonsEle != null) {
                ArrayList<ButtonDescriptor> list = new ArrayList<ButtonDescriptor>();
                Iterator it = DOMUtils.childElementIterByTag((Node)buttonsEle, (String)"button");
                while (it.hasNext()) {
                    Element buttonEle = (Element)it.next();
                    try {
                        ButtonDescriptor button = new ButtonDescriptor(buttonEle, buttonsEle);
                        list.add(button);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                this.buttonRegistry = list.isEmpty() ? null : list;
            } else {
                this.buttonRegistry = null;
            }
            Element slidersEle = DOMUtils.getFirstChildElementByTag((Node)docEle, (String)"sliders");
            if (slidersEle != null) {
                ArrayList<SliderDescriptor> list = new ArrayList<SliderDescriptor>();
                Iterator it = DOMUtils.childElementIterByTag((Node)slidersEle, (String)"slider");
                while (it.hasNext()) {
                    Element sliderEle = (Element)it.next();
                    try {
                        SliderDescriptor slider = new SliderDescriptor(sliderEle, slidersEle);
                        list.add(slider);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                this.sliderRegistry = list.isEmpty() ? null : list;
            } else {
                this.sliderRegistry = null;
            }
        } else {
            this.prefSize = null;
            this.controlPanelNightImage = ImageDescriptor.getMissingImageDescriptor();
            this.buttonRegistry = null;
            this.sliderRegistry = null;
        }
    }

    public ControlPanel createControlPanel() {
        ControlPanel controlPanel = new ControlPanel(this.prefSize);
        controlPanel.setImage(this.controlPanelNightImage.createImage());
        if (this.buttonRegistry != null) {
            for (ButtonDescriptor buttonDescriptor : this.buttonRegistry) {
                controlPanel.addButton(buttonDescriptor.createButton());
            }
        }
        if (this.sliderRegistry != null) {
            for (SliderDescriptor slider : this.sliderRegistry) {
                controlPanel.addSlider(slider.createSlider());
            }
        }
        return controlPanel;
    }

    public static ControlPanelFactory getInstance() {
        if (impl == null) {
            impl = new ControlPanelFactory();
        }
        return impl;
    }

    private static Image image(String id, ImageDescriptor imageDescriptor) {
        if (id == null || imageDescriptor == null) {
            return null;
        }
        ImageRegistry imgReg = Presentation.getDefault().getImageRegistry();
        ImageDescriptor descriptor = imgReg.getDescriptor(id);
        if (descriptor != null) {
            return imgReg.get(id);
        }
        imgReg.put(id, imageDescriptor);
        return imgReg.get(id);
    }

    private static Document getDocument() {
        URL xmlResource = FileLocator.find((Bundle)Presentation.getDefault().getBundle(), (IPath)new Path("/icons/panel/presentationButtons.xml"), null);
        if (xmlResource != null) {
            try {
                return DOMUtils.loadDocument((InputStream)xmlResource.openStream());
            }
            catch (Throwable e) {
                Presentation.log(e, "Failed to load presentationButtons.xml");
            }
        }
        return null;
    }

    private static ImageDescriptor getImageDescriptor(String fileName) {
        if (!ControlPanelFactory.isEmpty(fileName)) {
            return Presentation.imageFrom(PATH + fileName);
        }
        return null;
    }

    private static ImageDescriptor checkValidImage(ImageDescriptor imageDesc) {
        if (imageDesc != null) {
            Image image = null;
            try {
                image = imageDesc.createImage();
            }
            catch (Throwable throwable) {
                imageDesc = null;
            }
            if (image != null) {
                try {
                    image.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
        return imageDesc;
    }

    private static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private static int safeParseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected static final class ButtonDescriptor {
        private static final List<String> BUTTON_TEXT = Arrays.asList(PresentationMessages.GoNext_toolTip, PresentationMessages.GoInto_toolTip, PresentationMessages.Light_toolTip, PresentationMessages.Zoom_toolTip, PresentationMessages.Slider_barTip, PresentationMessages.ShowSidebar_toolTip, PresentationMessages.Quit_toolTip);
        private Dimension DEFAULT_BUTTON_SIZE = new Dimension(32, 32);
        private int id;
        private ImageDescriptor nightImage;
        private Rectangle prefBounds;
        private String tooltip;

        private ButtonDescriptor(Element buttonEle, Element buttonsEle) {
            this(-1, buttonEle, buttonsEle);
        }

        private ButtonDescriptor(int id, Element buttonEle, Element buttonsEle) {
            if (id < 0) {
                String _id = buttonEle.getAttribute("id");
                int n = id = ControlPanelFactory.isEmpty(_id) ? -1 : IDS.indexOf(_id);
                if (id < 0) {
                    throw new IllegalArgumentException("Invalid button id: " + _id);
                }
            }
            this.id = id;
            String night_src = buttonEle.getAttribute("night-src");
            ImageDescriptor nightImage = ControlPanelFactory.checkValidImage(ControlPanelFactory.getImageDescriptor(night_src));
            if (nightImage == null) {
                nightImage = ImageDescriptor.getMissingImageDescriptor();
            }
            this.nightImage = nightImage;
            String _x = buttonEle.getAttribute("x");
            String _y = buttonEle.getAttribute("y");
            String _width = buttonEle.getAttribute("width");
            String _height = buttonEle.getAttribute("height");
            if (ControlPanelFactory.isEmpty(_width) && buttonsEle != null) {
                _width = buttonsEle.getAttribute("defaultWidth");
            }
            if (ControlPanelFactory.isEmpty(_height) && buttonsEle != null) {
                _height = buttonsEle.getAttribute("defaultHeight");
            }
            int x = ControlPanelFactory.safeParseInt(_x, 0);
            int y = ControlPanelFactory.safeParseInt(_y, 0);
            int width = !ControlPanelFactory.isEmpty(_width) ? ControlPanelFactory.safeParseInt(_width, 0) : this.DEFAULT_BUTTON_SIZE.width;
            int height = !ControlPanelFactory.isEmpty(_height) ? ControlPanelFactory.safeParseInt(_height, 0) : this.DEFAULT_BUTTON_SIZE.height;
            this.prefBounds = new Rectangle(x, y, width, height);
            this.tooltip = BUTTON_TEXT.get(this.id);
        }

        private ButtonDescriptor(int id) {
            ImageDescriptor imageDesc;
            this.id = id;
            this.nightImage = imageDesc = ImageDescriptor.getMissingImageDescriptor();
            this.prefBounds = null;
            this.tooltip = BUTTON_TEXT.get(this.id);
        }

        private Button createButton() {
            return new Button(this.id, ControlPanelFactory.image(String.valueOf(this.id) + "_normal", this.nightImage), this.prefBounds, this.tooltip);
        }
    }

    private static final class SliderDescriptor {
        private final int id;
        private final ButtonDescriptor button;
        private final ButtonDescriptor slideway;

        public SliderDescriptor(Element sliderEle, Element slidersEle) {
            int slidewayId;
            int id;
            String _id = sliderEle.getAttribute("id");
            int n = id = ControlPanelFactory.isEmpty(_id) ? -1 : IDS.indexOf(_id);
            if (id < 0) {
                throw new IllegalArgumentException("Invalid slider id: " + _id);
            }
            this.id = id;
            Element sliderButtonEle = DOMUtils.getFirstChildElementByTag((Node)sliderEle, (String)"sliderButton");
            ButtonDescriptor button = sliderButtonEle == null ? new ButtonDescriptor(this.id) : new ButtonDescriptor(this.id, sliderButtonEle, null);
            this.button = button;
            Element slidewayEle = DOMUtils.getFirstChildElementByTag((Node)sliderEle, (String)"sliderArea");
            String slideid = slidewayEle.getAttribute("id");
            int n2 = slidewayId = ControlPanelFactory.isEmpty(slideid) ? -1 : IDS.indexOf(slideid);
            if (slidewayId < 0) {
                throw new IllegalArgumentException("Invalid slot id: " + slidewayId);
            }
            this.slideway = new ButtonDescriptor(slidewayId, slidewayEle, null);
        }

        public Slider createSlider() {
            return new Slider(this.id, this.button.createButton(), this.slideway.createButton());
        }
    }
}

