/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.freemind;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IImage;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.io.ResourceMappingManager;
import org.xmind.core.io.freemind.FreeMindConstants;
import org.xmind.core.io.freemind.FreeMindResourceMappingManager;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImporterUtils;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.wizards.MindMapImporter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMindImporter
extends MindMapImporter
implements FreeMindConstants,
ErrorHandler {
    private static ResourceMappingManager mappings = null;
    private List<Element> linkEles = null;
    private Map<String, String> idMap = new HashMap<String, String>();
    private Map<IStyled, IStyle> styleMap = new HashMap<IStyled, IStyle>();
    private Map<ITopic, String> topicHyperMap = null;
    private IStyleSheet styleSheet = null;
    private StringBuilder topicText = null;

    public FreeMindImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public FreeMindImporter(String sourcePath) {
        super(sourcePath);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromFreeMindCount");
        try {
            try {
                Document doc;
                DocumentBuilder builder = this.getDocumentBuilder();
                builder.setErrorHandler(this);
                FileInputStream in = new FileInputStream(this.getSourcePath());
                try {
                    in = new MonitoredInputStream((InputStream)in, this.getMonitor());
                    doc = builder.parse(in);
                }
                catch (Throwable throwable) {
                    builder.setErrorHandler(null);
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                builder.setErrorHandler(null);
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                this.checkInterrupted();
                Element rootElement = doc.getDocumentElement();
                this.loadSheet(rootElement);
                this.checkInterrupted();
                this.arrangeStyles();
                this.checkInterrupted();
                this.dealTopicHyperlinks();
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.idMap = null;
            this.styleMap = null;
        }
        this.postBuilded();
    }

    private void dealTopicHyperlinks() {
        if (this.topicHyperMap == null || this.topicHyperMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ITopic, String> entry : this.topicHyperMap.entrySet()) {
            ITopic topic = entry.getKey();
            String nodeId = entry.getValue();
            if (this.idMap == null || this.idMap.isEmpty()) break;
            String topicId = this.idMap.get(nodeId);
            if (topicId == null) continue;
            topic.setHyperlink("xmind:#" + topicId);
        }
    }

    private void arrangeStyles() throws InterruptedException {
        IStyleSheet targetStyleSheet = this.getTargetWorkbook().getStyleSheet();
        for (Map.Entry<IStyled, IStyle> entry : this.styleMap.entrySet()) {
            this.checkInterrupted();
            IStyled styleOwned = entry.getKey();
            IStyle style = entry.getValue();
            IStyle importStyle = targetStyleSheet.importStyle(style);
            if (importStyle == null) continue;
            styleOwned.setStyleId(importStyle.getId());
        }
    }

    private void loadSheet(Element rootEle) throws InterruptedException {
        this.checkInterrupted();
        ISheet sheet = this.getTargetWorkbook().createSheet();
        sheet.setTitleText(this.getSuggestedSheetTitle());
        Element nodeEle = FreeMindImporter.child(rootEle, "node");
        if (nodeEle != null) {
            this.loadTopic(sheet.getRootTopic(), nodeEle);
        } else {
            sheet.getRootTopic().setTitleText(ImportMessages.Importer_CentralTopic);
        }
        if (this.linkEles != null && !this.linkEles.isEmpty()) {
            this.loadRelationship();
        }
        this.addTargetSheet(sheet);
    }

    private void loadRelationship() {
        for (Element linkEle : this.linkEles) {
            if (linkEle == null) continue;
            LinkPoint link = new LinkPoint(linkEle);
            ITopic end1 = link.end1;
            ITopic end2 = link.end2;
            if (end1 == null || end2 == null) continue;
            IRelationship relationship = this.getTargetWorkbook().createRelationship((IRelationshipEnd)end1, (IRelationshipEnd)end2);
            relationship.setEnd1Id(end1.getId());
            relationship.setEnd2Id(end2.getId());
            Element arrowEle = FreeMindImporter.child(linkEle, "arrowlink");
            this.loadLinkShape(relationship, arrowEle);
            this.loadLinkColor(relationship, arrowEle);
        }
    }

    private void loadLinkColor(IRelationship relationship, Element arrowEle) {
        String color = FreeMindImporter.att(arrowEle, "COLOR");
        if (color == null) {
            return;
        }
        this.registerStyle((IStyled)relationship, "line-color", color);
    }

    private void loadLinkShape(IRelationship relationship, Element arrowEle) {
        String startArrow = FreeMindImporter.att(arrowEle, "STARTARROW");
        String startShape = this.parseArrowShape(startArrow);
        this.registerStyle((IStyled)relationship, "arrow-begin-class", startShape);
        String endArrow = FreeMindImporter.att(arrowEle, "ENDARROW");
        String endShape = this.parseArrowShape(endArrow);
        this.registerStyle((IStyled)relationship, "arrow-end-class", endShape);
    }

    private String parseArrowShape(String shape) {
        if ("Default".equals(shape)) {
            return "org.xmind.arrowShape.normal";
        }
        return "org.xmind.arrowShape.none";
    }

    private void loadTopic(ITopic topic, Element nodeEle) throws InterruptedException {
        Element notesEle;
        String name;
        Element ele;
        this.checkInterrupted();
        String id = FreeMindImporter.att(nodeEle, "ID");
        if (id != null) {
            this.idMap.put(id, topic.getId());
        }
        this.checkInterrupted();
        String text = FreeMindImporter.att(nodeEle, "TEXT");
        if (text == null) {
            text = ImporterUtils.getDefaultTopicTitle(topic);
        } else if (text.contains("../../../../")) {
            int index = text.indexOf("../../../../");
            String path = text.substring(index + "../../../../".length(), text.length() - 2);
            this.loadImage(topic, path);
            text = ImporterUtils.getDefaultTopicTitle(topic);
        }
        topic.setTitleText(text);
        this.checkInterrupted();
        String folded = FreeMindImporter.att(nodeEle, "FOLDED");
        if (folded != null && "true".equals(folded)) {
            topic.setFolded(true);
        }
        this.checkInterrupted();
        if (!topic.isRoot() && (ele = FreeMindImporter.child(nodeEle, "cloud")) != null) {
            IBoundary boundary = this.getTargetWorkbook().createBoundary();
            int index = topic.getIndex();
            boundary.setStartIndex(index);
            boundary.setEndIndex(index);
            topic.getParent().addBoundary(boundary);
        }
        this.checkInterrupted();
        String link = FreeMindImporter.att(nodeEle, "LINK");
        if (link != null) {
            if (link.startsWith("../../../../")) {
                String hyperlink = link.substring("../../../../".length());
                topic.setHyperlink("file:" + hyperlink);
            } else if (link.startsWith("#")) {
                String nodeId = link.substring(1);
                if (this.topicHyperMap == null) {
                    this.topicHyperMap = new HashMap<ITopic, String>();
                }
                this.topicHyperMap.put(topic, nodeId);
            } else {
                topic.setHyperlink(link);
            }
        }
        this.checkInterrupted();
        String backgroundColor = FreeMindImporter.att(nodeEle, "BACKGROUND_COLOR");
        this.registerStyle((IStyled)topic, "svg:fill", backgroundColor);
        this.checkInterrupted();
        String foregroundColor = FreeMindImporter.att(nodeEle, "COLOR");
        this.registerStyle((IStyled)topic, "fo:color", foregroundColor);
        this.checkInterrupted();
        Element fontEle = FreeMindImporter.child(nodeEle, "font");
        this.loadFont(fontEle, topic);
        this.checkInterrupted();
        Element linkNode = FreeMindImporter.child(nodeEle, "arrowlink");
        if (linkNode != null) {
            if (this.linkEles == null) {
                this.linkEles = new ArrayList<Element>();
            }
            this.linkEles.add(nodeEle);
        }
        Iterator<Element> iconIter = FreeMindImporter.children(nodeEle, "icon");
        while (iconIter.hasNext()) {
            this.checkInterrupted();
            Element iconEle = iconIter.next();
            String builtIn = FreeMindImporter.att(iconEle, "BUILTIN");
            if (builtIn == null) continue;
            String markerId = this.getTransferred("marker", builtIn, null);
            if (markerId == null) {
                markerId = "other-question";
            }
            topic.addMarker(markerId);
        }
        this.checkInterrupted();
        Element hookEle = FreeMindImporter.child(nodeEle, "hook");
        if (hookEle != null && "accessories/plugins/NodeNote.properties".equals(name = FreeMindImporter.att(hookEle, "NAME")) && (notesEle = FreeMindImporter.child(hookEle, "text")) != null) {
            this.loadNotesContent(topic, notesEle);
        }
        Iterator<Element> notesIter = FreeMindImporter.children(nodeEle, "richcontent");
        while (notesIter.hasNext()) {
            Element htmlEle;
            this.checkInterrupted();
            Element richEle = notesIter.next();
            String type = FreeMindImporter.att(richEle, "TYPE");
            if (type != null && "NOTE".equals(type)) {
                htmlEle = FreeMindImporter.child(richEle, "html");
                if (htmlEle == null) continue;
                IHtmlNotesContent notesContent = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
                NotesImporter notesImport = new NotesImporter(notesContent);
                notesImport.importFrom(htmlEle);
                topic.getNotes().setContent("html", (INotesContent)notesContent);
                continue;
            }
            if (!"NODE".equals(type)) continue;
            this.topicText = null;
            htmlEle = FreeMindImporter.child(richEle, "html");
            if (htmlEle != null) {
                this.loadNode(topic, htmlEle);
            }
            text = this.topicText != null ? this.topicText.toString().trim() : ImporterUtils.getDefaultTopicTitle(topic);
            topic.setTitleText(text);
        }
        Iterator<Element> nodeIter = FreeMindImporter.children(nodeEle, "node");
        while (nodeIter.hasNext()) {
            this.checkInterrupted();
            Element subNodeEle = nodeIter.next();
            ITopic subTopic = this.getTargetWorkbook().createTopic();
            topic.add(subTopic);
            this.loadTopic(subTopic, subNodeEle);
        }
    }

    private void loadNotesContent(ITopic topic, Element ele) {
        String text = ele.getTextContent().trim();
        if (text == null) {
            return;
        }
        IHtmlNotesContent notesContent = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
        ITextSpan span = notesContent.createTextSpan(text);
        IParagraph paragraph = notesContent.createParagraph();
        paragraph.addSpan((ISpan)span);
        notesContent.addParagraph(paragraph);
        topic.getNotes().setContent("html", (INotesContent)notesContent);
    }

    private void loadNode(ITopic topic, Element element) throws InterruptedException {
        Element[] children;
        this.checkInterrupted();
        String tagName = DOMUtils.getLocalName((String)element.getTagName());
        if ("img".equalsIgnoreCase(tagName)) {
            String path;
            String src = FreeMindImporter.att(element, "src");
            if (src.startsWith("../../../../")) {
                path = src.substring("../../../../".length());
                this.loadImage(topic, path);
            } else {
                path = String.valueOf(this.getSourcePath().substring(0, this.getSourcePath().lastIndexOf("\\") + 1)) + src;
                this.loadImage(topic, path);
            }
        } else if ("p".equalsIgnoreCase(tagName) || "li".equalsIgnoreCase(tagName)) {
            String align;
            String text = element.getTextContent().trim();
            if (text != null) {
                if (this.topicText == null) {
                    this.topicText = new StringBuilder();
                }
                this.topicText.append(text);
                this.topicText.append('\n');
            }
            if ((align = FreeMindImporter.att(element, "style")) != null) {
                String value = this.parseAlign(align);
                this.registerStyle((IStyled)topic, "fo:text-align", value);
            }
        } else if ("b".equalsIgnoreCase(tagName)) {
            this.registerStyle((IStyled)topic, "fo:font-weight", "bold");
        } else if ("i".equalsIgnoreCase(tagName)) {
            this.registerStyle((IStyled)topic, "fo:font-style", "italic");
        } else if ("font".equalsIgnoreCase(tagName)) {
            String size;
            String color;
            String fontFamily = FreeMindImporter.att(element, "face");
            if (fontFamily != null) {
                this.registerStyle((IStyled)topic, "fo:font-weight", fontFamily);
            }
            if ((color = FreeMindImporter.att(element, "color")) != null) {
                this.registerStyle((IStyled)topic, "fo:color", color);
            }
            if ((size = FreeMindImporter.att(element, "size")) != null) {
                this.registerStyle((IStyled)topic, "fo:font-size", this.parseSize(size));
            }
        }
        Element[] elementArray = children = DOMUtils.getChildElements((Node)element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element ele = elementArray[n2];
            this.loadNode(topic, ele);
            ++n2;
        }
    }

    private void loadImage(ITopic topic, String path) throws InterruptedException {
        this.checkInterrupted();
        IFileEntry imgEntry = this.loadAttachment(path);
        if (imgEntry != null) {
            IImage image = topic.getImage();
            image.setSource(HyperlinkUtils.toAttachmentURL((String)imgEntry.getPath()));
        }
    }

    private IFileEntry loadAttachment(String path) throws InterruptedException {
        this.checkInterrupted();
        try {
            IFileEntry entry = this.getTargetWorkbook().getManifest().createAttachmentFromFilePath(path);
            return entry;
        }
        catch (IOException e) {
            this.log(e, "failed to create attachment from: " + path);
            return null;
        }
    }

    private void loadFont(Element fontEle, ITopic topic) {
        String bold;
        String italic;
        String size;
        if (fontEle == null) {
            return;
        }
        String fontName = FreeMindImporter.att(fontEle, "NAME");
        String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
        String string = fontName = availableFontName != null ? availableFontName : fontName;
        if (fontName != null) {
            this.registerStyle((IStyled)topic, "fo:font-family", fontName);
        }
        if ((size = FreeMindImporter.att(fontEle, "SIZE")) != null) {
            this.registerStyle((IStyled)topic, "fo:font-size", size);
        }
        if ("true".equalsIgnoreCase(italic = FreeMindImporter.att(fontEle, "ITALIC"))) {
            this.registerStyle((IStyled)topic, "fo:font-style", "italic");
        }
        if ("true".equalsIgnoreCase(bold = FreeMindImporter.att(fontEle, "BOLD"))) {
            this.registerStyle((IStyled)topic, "fo:font-weight", "bold");
        }
    }

    private void registerStyle(IStyled styleOwned, String key, String value) {
        if (value == null) {
            return;
        }
        IStyle style = this.styleMap.get(styleOwned);
        if (style == null) {
            style = this.getStyleSheet().createStyle(styleOwned.getStyleType());
            this.getStyleSheet().addStyle(style, "normal-styles");
            this.styleMap.put(styleOwned, style);
        }
        style.setProperty(key, value);
    }

    private String parseSize(String size) {
        if ("2".equals(size)) {
            return "10";
        }
        if ("3".equals(size)) {
            return "12";
        }
        if ("4".equals(size)) {
            return "14";
        }
        if ("5".equals(size)) {
            return "18";
        }
        if ("6".equals(size)) {
            return "24";
        }
        return "8";
    }

    private String parseAlign(String align) {
        if (align.endsWith("center")) {
            return "center";
        }
        if (align.endsWith("right")) {
            return "right";
        }
        return "left";
    }

    private IStyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            this.styleSheet = Core.getStyleSheetBuilder().createStyleSheet();
            ((StyleSheetImpl)this.styleSheet).setManifest(this.getTargetWorkbook().getManifest());
        }
        return this.styleSheet;
    }

    private String getTransferred(String type, String sourceId, String defaultId) {
        String destination;
        ResourceMappingManager mappings;
        if (sourceId != null && (mappings = this.getMappings()) != null && (destination = mappings.getDestination(type, sourceId)) != null) {
            return destination;
        }
        return defaultId;
    }

    private ResourceMappingManager getMappings() {
        if (mappings == null) {
            mappings = this.createMappings();
        }
        return mappings;
    }

    private ResourceMappingManager createMappings() {
        return FreeMindResourceMappingManager.getInstance();
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DOMUtils.getDefaultDocumentBuilder();
    }

    private static Element child(Element parentEle, String childTag) {
        return FreeMindImporter.children(parentEle, childTag).next();
    }

    private static Iterator<Element> children(Element parentEle, String childTag) {
        return new Iterator<Element>(childTag, parentEle){
            String tag;
            Iterator<Element> it;
            Element next;
            {
                this.tag = DOMUtils.getLocalName((String)string);
                this.it = DOMUtils.childElementIter((Node)element);
                this.next = this.findNext();
            }

            @Override
            public void remove() {
            }

            private Element findNext() {
                while (this.it.hasNext()) {
                    Element ele = this.it.next();
                    if (!DOMUtils.getLocalName((String)ele.getTagName()).equalsIgnoreCase(this.tag)) continue;
                    return ele;
                }
                return null;
            }

            @Override
            public Element next() {
                Element result = this.next;
                this.next = this.findNext();
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    private static String att(Element ele, String attName) {
        if (ele.hasAttribute(attName)) {
            return ele.getAttribute(attName);
        }
        attName = DOMUtils.getLocalName((String)attName);
        NamedNodeMap atts = ele.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            if (attName.equalsIgnoreCase(DOMUtils.getLocalName((String)att.getNodeName()))) {
                return att.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.log(exception, null);
    }

    private class LinkPoint {
        ITopic end1;
        ITopic end2;

        public LinkPoint(Element ele) {
            String id1 = FreeMindImporter.att(ele, "ID");
            this.end1 = this.findLinkTopic(id1);
            Element linkNode = FreeMindImporter.child(ele, "arrowlink");
            String id2 = FreeMindImporter.att(linkNode, "DESTINATION");
            this.end2 = this.findLinkTopic(id2);
        }

        private ITopic findLinkTopic(String id) {
            if (FreeMindImporter.this.idMap == null || FreeMindImporter.this.idMap.isEmpty()) {
                return null;
            }
            String topicId = (String)FreeMindImporter.this.idMap.get(id);
            return FreeMindImporter.this.getTargetWorkbook().findTopic(topicId);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && !(obj instanceof LinkPoint)) {
                return false;
            }
            LinkPoint that = (LinkPoint)obj;
            return this.end1 == that.end1 && this.end2 == that.end2;
        }
    }

    private class NotesImporter {
        IHtmlNotesContent content;
        IParagraph currentParagraph = null;
        Stack<IStyle> styleStack = new Stack();

        public NotesImporter(IHtmlNotesContent content) {
            this.content = content;
        }

        public void importFrom(Element htmlEle) throws InterruptedException {
            FreeMindImporter.this.checkInterrupted();
            String tagName = DOMUtils.getLocalName((String)htmlEle.getTagName());
            boolean isParagraph = "p".equalsIgnoreCase(tagName) || "li".equalsIgnoreCase(tagName);
            IStyle style = this.pushStyle(htmlEle, isParagraph ? "paragraph" : "text");
            if (isParagraph) {
                this.addParagraph();
            }
            NodeList nl = htmlEle.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 3) {
                    this.addText(node.getTextContent());
                } else if (nodeType == 1) {
                    this.importFrom((Element)node);
                }
                ++i;
            }
            this.popStyle(style);
        }

        private void addText(String text) {
            if (text == null) {
                return;
            }
            if ("".equals(text = text.trim())) {
                return;
            }
            ITextSpan textSpan = this.content.createTextSpan(text);
            this.addSpan((ISpan)textSpan);
        }

        private void addSpan(ISpan span) {
            if (this.currentParagraph == null) {
                this.addParagraph();
            }
            this.currentParagraph.addSpan(span);
            this.registerStyle((IStyled)span, "fo:font-family", "fo:font-size", "fo:color", "fo:font-weight", "fo:text-decoration", "fo:font-style");
        }

        private void addParagraph() {
            this.currentParagraph = this.content.createParagraph();
            this.content.addParagraph(this.currentParagraph);
            this.registerStyle((IStyled)this.currentParagraph, "fo:text-align");
        }

        private void registerStyle(IStyled host, String ... keys) {
            for (IStyle style : this.styleStack) {
                this.registerStyle(host, style, keys);
            }
        }

        private void registerStyle(IStyled host, IStyle style, String ... keys) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = style.getProperty(key);
                if (value != null) {
                    FreeMindImporter.this.registerStyle(host, key, value);
                }
                ++n2;
            }
        }

        private IStyle pushStyle(Element ele, String type) {
            IStyle style = FreeMindImporter.this.getStyleSheet().createStyle(type);
            this.receiveStyle(ele, style);
            if (style.isEmpty()) {
                style = null;
            } else {
                this.styleStack.push(style);
            }
            return style;
        }

        private void receiveStyle(Element ele, IStyle style) {
            String name;
            String alignStyle = FreeMindImporter.att(ele, "style");
            if (alignStyle != null) {
                String align = FreeMindImporter.this.parseAlign(alignStyle);
                style.setProperty("fo:text-align", align);
            }
            if ("b".equalsIgnoreCase(name = ele.getTagName())) {
                style.setProperty("fo:font-weight", "bold");
            } else if ("i".equalsIgnoreCase(name)) {
                style.setProperty("fo:font-style", "italic");
            } else if ("u".equalsIgnoreCase(name)) {
                style.setProperty("fo:text-decoration", "underline");
            } else if ("font".equalsIgnoreCase(name)) {
                String size;
                String color;
                String fontFamily = FreeMindImporter.att(ele, "face");
                if (fontFamily != null) {
                    style.setProperty("fo:font-weight", fontFamily);
                }
                if ((color = FreeMindImporter.att(ele, "color")) != null) {
                    style.setProperty("fo:color", color);
                }
                if ((size = FreeMindImporter.att(ele, "size")) != null) {
                    String fontSize = FreeMindImporter.this.parseSize(size);
                    style.setProperty("fo:font-size", String.valueOf(fontSize) + "pt");
                }
            }
        }

        private void popStyle(IStyle style) {
            if (style == null) {
                return;
            }
            if (!FreeMindImporter.this.styleSheet.isEmpty() && this.styleStack.peek() == style) {
                this.styleStack.pop();
            }
        }
    }
}

