/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.xmind.ui.viewers.SWTUtils;

public class PopupFilteredList
extends PopupDialog {
    private Text filterText;
    private TreeViewer treeViewer;
    private List<IOpenListener> openListeners = null;
    private PatternFilter patternFilter = null;
    private Object input = null;
    private IContentProvider contentProvider = null;
    private IBaseLabelProvider labelProvider = null;
    private ViewerFilter[] filters = null;
    private ViewerSorter sorter = null;
    private ViewerComparator comparator = null;
    private IElementComparer comparer = null;
    private Object defaultSelection = null;
    private Rectangle boundsReference = null;
    private boolean permitsUnprovidedElement = false;
    private IElementCreator elementCreator = null;

    public PopupFilteredList(Shell parent) {
        this(parent, 16400);
    }

    public PopupFilteredList(Shell parent, String titleText, String infoText) {
        super(parent, 16400, true, false, false, false, false, titleText, infoText);
    }

    public PopupFilteredList(Shell parent, int shellStyle) {
        super(parent, shellStyle, true, false, false, false, false, null, null);
    }

    protected Control createDialogArea(Composite parent) {
        Display display = parent.getDisplay();
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setBackground(display.getSystemColor(29));
        GridLayout layout2 = (GridLayout)composite.getLayout();
        layout2.verticalSpacing = 3;
        layout2.marginWidth = 3;
        layout2.marginTop = 4;
        this.filterText = this.createFilterText(composite);
        this.filterText.setLayoutData((Object)new GridData(768));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.treeViewer = this.createTreeViewer(composite);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.configureFilterText(this.filterText);
        this.configureTreeViewer(this.treeViewer);
        return composite;
    }

    protected Text createFilterText(Composite parent) {
        return new Text(parent, 4);
    }

    protected void configureFilterText(Text filterText) {
        filterText.setText("");
        filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = PopupFilteredList.this.getFilterText().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PopupFilteredList.this.getFilterText().isDisposed()) {
                            PopupFilteredList.this.getFilterText().selectAll();
                        }
                    }
                });
            }
        });
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = PopupFilteredList.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    PopupFilteredList.this.treeViewer.getTree().setFocus();
                }
            }
        });
        filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    PopupFilteredList.this.fireOpen();
                }
            }
        });
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PopupFilteredList.this.filterChanged();
            }
        });
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 66308);
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        final Tree tree = treeViewer.getTree();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (!SWTUtils.matchKey(event.stateMask, event.keyCode, 0, 27)) break;
                        PopupFilteredList.this.close();
                        break;
                    }
                    case 14: {
                        PopupFilteredList.this.fireOpen();
                        break;
                    }
                    case 4: {
                        this.handleMouseUp(event);
                    }
                }
            }

            protected void handleMouseUp(Event e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button == 1 && tree.equals(e.widget)) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        PopupFilteredList.this.fireOpen(selection.getData());
                    }
                }
            }
        };
        tree.addListener(1, listener);
        tree.addListener(14, listener);
        tree.addListener(4, listener);
        tree.addMouseMoveListener(new MouseMoveListener(){
            final int ignoreEventCount = "gtk".equals(SWT.getPlatform()) ? 4 : 1;
            TreeItem fLastItem = null;
            int lastY = 0;
            int itemHeightdiv4;
            int tableHeight;
            Point tableLoc;
            int divCount;
            {
                this.itemHeightdiv4 = tree2.getItemHeight() / 4;
                this.tableHeight = tree2.getBounds().height;
                this.tableLoc = tree2.toDisplay(0, 0);
                this.divCount = 0;
            }

            public void mouseMove(MouseEvent e) {
                TreeItem item;
                if (this.divCount == this.ignoreEventCount) {
                    this.divCount = 0;
                }
                if (tree.equals(e.getSource()) & ++this.divCount == this.ignoreEventCount && (item = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem && this.lastY != e.y) {
                    this.lastY = e.y;
                    if (!item.equals(this.fLastItem)) {
                        this.fLastItem = item;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < this.itemHeightdiv4) {
                        item = PopupFilteredList.this.getViewer().scrollUp(e.x + this.tableLoc.x, e.y + this.tableLoc.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > this.tableHeight - this.itemHeightdiv4 && (item = PopupFilteredList.this.getViewer().scrollDown(e.x + this.tableLoc.x, e.y + this.tableLoc.y)) instanceof TreeItem) {
                        this.fLastItem = item;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    }
                }
            }
        });
        treeViewer.setContentProvider((IContentProvider)new DelegatingTreeContentProvider(this.getContentProvider()));
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider(this.getLabelProvider()));
        if (this.getFilters() != null) {
            treeViewer.setFilters(this.getFilters());
        }
        this.getPatternFilter().setPatternText(null);
        treeViewer.addFilter((ViewerFilter)this.getPatternFilter());
        treeViewer.setSorter(this.getSorter());
        treeViewer.setComparator(this.getComparator());
        treeViewer.setComparer(this.getComparer());
        treeViewer.setInput(this.getInput());
        treeViewer.setAutoExpandLevel(-1);
        if (this.defaultSelection != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection(this.defaultSelection));
        } else if (tree.getItemCount() > 0) {
            tree.setSelection(tree.getItem(0));
        }
    }

    protected void filterChanged() {
        Control control = this.getViewer().getControl();
        control.setRedraw(false);
        this.getPatternFilter().setPatternText(this.getFilterText().getText());
        this.getViewer().refresh();
        control.setRedraw(true);
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpen() {
        ISelection selection = this.getViewer().getSelection();
        if (selection.isEmpty() && this.permitsUnprovidedElement()) {
            selection = new StructuredSelection(this.createElement(this.getFilterText().getText()));
        }
        this.fireOpenEvent(new OpenEvent((Viewer)this.getViewer(), selection));
    }

    private Object createElement(String text) {
        if (this.elementCreator != null) {
            return this.elementCreator.createElement(text);
        }
        return text;
    }

    protected void fireOpen(Object element) {
        this.fireOpenEvent(new OpenEvent((Viewer)this.getViewer(), (ISelection)new StructuredSelection(element)));
    }

    protected void fireOpenEvent(final OpenEvent e) {
        this.close();
        if (this.openListeners == null || this.openListeners.isEmpty()) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(e);
                }
            });
            ++n2;
        }
    }

    protected PatternFilter getPatternFilter() {
        if (this.patternFilter == null) {
            this.patternFilter = new PatternFilter();
        }
        return this.patternFilter;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ViewerSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(ViewerSorter sorter) {
        this.sorter = sorter;
    }

    public ViewerComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ViewerComparator comparator) {
        this.comparator = comparator;
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    public void setComparer(IElementComparer comparer) {
        this.comparer = comparer;
    }

    public void setFilters(ViewerFilter[] filters) {
        this.filters = filters;
    }

    public ViewerFilter[] getFilters() {
        return this.filters;
    }

    public Object getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(Object defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    public void setBoundsReference(Rectangle reference) {
        this.boundsReference = reference;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle r = this.boundsReference;
        if (r != null) {
            return new Point(r.x, r.y + r.height);
        }
        return super.getInitialLocation(initialSize);
    }

    public void setPatternFilter(PatternFilter patternFilter) {
        if (patternFilter == this.patternFilter) {
            return;
        }
        this.patternFilter = patternFilter;
        if (this.getViewer() != null && !this.getViewer().getControl().isDisposed()) {
            this.filterChanged();
        }
    }

    public boolean permitsUnprovidedElement() {
        return this.permitsUnprovidedElement;
    }

    public void setPermitsUnprovidedElement(boolean permitsUnprovidedElement) {
        this.permitsUnprovidedElement = permitsUnprovidedElement;
    }

    public void setElementCreator(IElementCreator elementCreator) {
        this.elementCreator = elementCreator;
    }

    public IElementCreator getElementCreator() {
        return this.elementCreator;
    }

    private class DelegatingLabelProvider
    extends LabelProvider
    implements IFontProvider,
    ILabelProviderListener {
        private IBaseLabelProvider delegate;

        public DelegatingLabelProvider(IBaseLabelProvider delegate) {
            this.delegate = delegate;
            if (delegate != null) {
                delegate.addListener((ILabelProviderListener)this);
            }
        }

        public String getText(Object element) {
            if (this.delegate instanceof ILabelProvider) {
                return ((ILabelProvider)this.delegate).getText(element);
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (this.delegate instanceof ILabelProvider) {
                return ((ILabelProvider)this.delegate).getImage(element);
            }
            return super.getImage(element);
        }

        public Font getFont(Object element) {
            if (element == PopupFilteredList.this.defaultSelection || element != null && element.equals(PopupFilteredList.this.defaultSelection)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            return null;
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements());
            this.fireLabelProviderChanged(e);
        }
    }

    private static class DelegatingTreeContentProvider
    implements ITreeContentProvider {
        private IContentProvider delegate;

        public DelegatingTreeContentProvider(IContentProvider delegate) {
            this.delegate = delegate;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.delegate instanceof ITreeContentProvider) {
                return ((ITreeContentProvider)this.delegate).getChildren(parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (this.delegate instanceof ITreeContentProvider) {
                return ((ITreeContentProvider)this.delegate).getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.delegate instanceof ITreeContentProvider) {
                return ((ITreeContentProvider)this.delegate).hasChildren(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (this.delegate instanceof IStructuredContentProvider) {
                return ((IStructuredContentProvider)this.delegate).getElements(inputElement);
            }
            if (this.delegate instanceof ITreeContentProvider) {
                return ((ITreeContentProvider)this.delegate).getElements(inputElement);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static interface IElementCreator {
        public Object createElement(String var1);
    }

    public static class PatternFilter
    extends ViewerFilter {
        private String patternText = null;
        private StringMatcher matcher = null;
        private boolean ignoreCase;
        private boolean useWildCards;
        private boolean useWhiteSpacesAsWildCards;
        private boolean useWildCardOnStart;

        public PatternFilter() {
            this(true, true, true, true);
        }

        public PatternFilter(boolean ignoreCase, boolean useWildCards, boolean useWhiteSpacesAsWildCards, boolean useWildCardOnStart) {
            this.ignoreCase = ignoreCase;
            this.useWildCards = useWildCards;
            this.useWhiteSpacesAsWildCards = useWhiteSpacesAsWildCards;
            this.useWildCardOnStart = useWildCardOnStart;
        }

        public String getPatternText() {
            return this.patternText;
        }

        private void setPatternText(String pattern) {
            this.patternText = pattern;
            this.updateMatcher();
        }

        protected void updateMatcher() {
            if (this.patternText == null || this.patternText.length() == 0) {
                this.matcher = null;
            } else {
                String pattern = this.patternText;
                if (this.usesWhiteSpacesAsWildCards()) {
                    pattern = pattern.replaceAll(" ", "*");
                }
                if (this.usesWildCardOnStart() && !pattern.startsWith("*")) {
                    pattern = "*" + pattern;
                }
                if (!pattern.endsWith("*")) {
                    pattern = String.valueOf(pattern) + "*";
                }
                this.matcher = new StringMatcher(pattern, this.ignoresCase(), !this.usesWildCards());
            }
        }

        public boolean ignoresCase() {
            return this.ignoreCase;
        }

        public boolean usesWildCardOnStart() {
            return this.useWildCardOnStart;
        }

        public boolean usesWhiteSpacesAsWildCards() {
            return this.useWhiteSpacesAsWildCards;
        }

        public boolean usesWildCards() {
            return this.useWildCards;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            this.updateMatcher();
        }

        public void setUseWildCardOnStart(boolean useWildCardOnStart) {
            this.useWildCardOnStart = useWildCardOnStart;
            this.updateMatcher();
        }

        public void setUseWhiteSpacesAsWildCards(boolean usesWhiteSpacesAsWildCards) {
            this.useWhiteSpacesAsWildCards = usesWhiteSpacesAsWildCards;
            this.updateMatcher();
        }

        public void setUseWildCards(boolean usesWildCards) {
            this.useWildCards = usesWildCards;
            this.updateMatcher();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher == null) {
                return true;
            }
            if (this.isMatch(viewer, element)) {
                return true;
            }
            return this.isLeafMatch(viewer, element);
        }

        private boolean isMatch(Viewer viewer, Object element) {
            String elementName = ((ILabelProvider)((ContentViewer)viewer).getLabelProvider()).getText(element);
            if (elementName == null) {
                return false;
            }
            return this.matcher.match(elementName);
        }

        private boolean isLeafMatch(Viewer viewer, Object element) {
            if (this.isMatch(viewer, element)) {
                return true;
            }
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ele = objectArray[n2];
                    if (this.isLeafMatch(viewer, ele)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

