/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IComment;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentTextViewer;
import org.xmind.ui.internal.comments.CommentsUtils;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.TextFormatter;

public class TopicCommentsViewer
implements ICoreEventListener {
    private ITopic input;
    private ICommentsActionBarContributor contributor;
    private ISelectionProvider selectionProvider;
    private ICommentTextViewerContainer container;
    private boolean showTopicLabel;
    private IGraphicalEditor targetEditor;
    private Label titleLabel;
    private ICoreEventRegister eventRegister;
    private List<CommentTextViewer> controls = new ArrayList<CommentTextViewer>();
    private List<CommentTextViewer> implementations = new ArrayList<CommentTextViewer>();
    private Control addCommentControl;
    private Composite commentsComposite;
    private Control newCommentControl;

    public TopicCommentsViewer(ITopic input, ICommentsActionBarContributor contributor, ISelectionProvider selectionProvider, ICommentTextViewerContainer container, boolean showTopicLabel, IGraphicalEditor targetEditor) {
        this.input = input;
        this.contributor = contributor;
        this.selectionProvider = selectionProvider;
        this.container = container;
        this.showTopicLabel = showTopicLabel;
        this.targetEditor = targetEditor;
    }

    public void create(Composite parent) {
        this.init();
        this.createControl(this.input, parent);
    }

    private void init() {
        if (this.controls != null) {
            this.controls.clear();
        }
        if (this.implementations != null) {
            this.implementations.clear();
        }
    }

    private Control createControl(ITopic topic, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        if (this.showTopicLabel) {
            this.createTopicLabel(composite, topic);
        }
        if (!this.showTopicLabel) {
            this.addCommentControl = this.createAddCommentControl(composite);
        }
        this.commentsComposite = this.createComments(topic, composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TopicCommentsViewer.this.handleControlDisposed(e);
            }
        });
        return composite;
    }

    private void createTopicLabel(Composite parent, final ITopic topic) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginBottom = 6;
        composite.setLayout((Layout)layout);
        this.titleLabel = new Label(composite, 16640);
        this.titleLabel.setBackground(parent.getBackground());
        this.titleLabel.setForeground(ColorUtils.getColor((String)"#353535"));
        GridData data = new GridData(0x1000000, 0x1000000, true, false);
        data.horizontalIndent = 2;
        this.titleLabel.setLayoutData((Object)data);
        this.titleLabel.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1)));
        this.titleLabel.setText(String.valueOf(MindMapMessages.Comment_TOPIC_text) + TextFormatter.removeNewLineCharacter((String)topic.getTitleText()));
        this.hookTopicTitle();
        this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CommentsUtils.reveal(TopicCommentsViewer.this.targetEditor, topic);
            }
        });
    }

    private Control createAddCommentControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        composite.setLayout((Layout)layout);
        Composite marginComposite = new Composite(composite, 0);
        marginComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout3 = new GridLayout(1, false);
        layout3.marginHeight = 1;
        layout3.marginWidth = 1;
        marginComposite.setLayout((Layout)layout3);
        marginComposite.setBackground(ColorUtils.getColor((String)"#a0a0a0"));
        Composite roundRectangleComposite = new Composite(marginComposite, 0);
        roundRectangleComposite.setForeground(ColorUtils.getColor((String)"#ffffff"));
        roundRectangleComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 40;
        roundRectangleComposite.setLayoutData((Object)layoutData);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 2;
        layout2.marginHeight = 2;
        roundRectangleComposite.setLayout((Layout)layout2);
        Text text = new Text(roundRectangleComposite, 16396);
        text.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        text.setBackground(text.getParent().getForeground());
        text.setForeground(ColorUtils.getColor((String)"#aaaaaa"));
        text.setFont(FontUtils.getItalic((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1)));
        text.setText(MindMapMessages.Comment_Add_text);
        text.setEnabled(false);
        roundRectangleComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TopicCommentsViewer.this.createNewComment();
            }
        });
        return composite;
    }

    public Control createNewComment() {
        if (this.newCommentControl != null && !this.newCommentControl.isDisposed()) {
            return this.newCommentControl;
        }
        if (this.addCommentControl != null && !this.addCommentControl.isDisposed()) {
            this.addCommentControl.setVisible(false);
            ((GridData)this.addCommentControl.getLayoutData()).exclude = true;
        }
        CommentTextViewer implementation = new CommentTextViewer(null, this.input.getId(), this.input.getOwnedWorkbook(), this.contributor, this.selectionProvider, this.container, this.targetEditor);
        this.newCommentControl = implementation.createControl(this.commentsComposite);
        this.newCommentControl.moveAbove(this.commentsComposite.getChildren()[0]);
        this.container.getContentComposite().pack();
        implementation.getTextViewer().getTextWidget().forceFocus();
        return this.newCommentControl;
    }

    public void cancelCreateNewComment() {
        if (this.newCommentControl != null && !this.newCommentControl.isDisposed()) {
            this.newCommentControl.dispose();
            this.newCommentControl = null;
        }
        if (this.addCommentControl != null && !this.addCommentControl.isDisposed()) {
            this.addCommentControl.setVisible(true);
            ((GridData)this.addCommentControl.getLayoutData()).exclude = false;
        }
        this.container.getContentComposite().pack();
    }

    private Composite createComments(ITopic topic, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        TreeSet comments = new TreeSet(topic.getOwnedWorkbook().getCommentManager().getComments(topic.getId()));
        for (IComment comment : comments) {
            this.createCommentControl(composite, comment);
        }
        return composite;
    }

    private void createCommentControl(Composite parent, IComment comment) {
        CommentTextViewer implementation = new CommentTextViewer(comment, this.input.getId(), this.input.getOwnedWorkbook(), this.contributor, this.selectionProvider, this.container, this.targetEditor);
        implementation.createControl(parent);
        this.registerControl(implementation);
        this.registerImplementation(implementation);
    }

    private void registerControl(CommentTextViewer control) {
        this.controls.add(control);
    }

    private void registerImplementation(CommentTextViewer implementation) {
        this.implementations.add(implementation);
    }

    private void hookTopicTitle() {
        if (this.eventRegister == null) {
            this.eventRegister = new CoreEventRegister((Object)this.input, (ICoreEventListener)this);
        }
        this.eventRegister.register("titleText");
    }

    private void unhookTopicTitle() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if ("titleText".equals(event.getType()) && TopicCommentsViewer.this.titleLabel != null && !TopicCommentsViewer.this.titleLabel.isDisposed()) {
                    TopicCommentsViewer.this.titleLabel.setText(String.valueOf(MindMapMessages.Comment_TOPIC_text) + TextFormatter.removeNewLineCharacter((String)TopicCommentsViewer.this.input.getTitleText()));
                    TopicCommentsViewer.this.titleLabel.getParent().layout(true, true);
                }
            }
        });
    }

    private void handleControlDisposed(DisposeEvent e) {
        this.unhookTopicTitle();
        if (this.controls != null) {
            this.controls.clear();
            this.controls = null;
        }
        if (this.implementations != null) {
            this.implementations.clear();
            this.implementations = null;
        }
    }

    public void setTargetEditor(IGraphicalEditor targetEditor) {
        if (this.targetEditor != targetEditor) {
            this.targetEditor = targetEditor;
            if (this.implementations != null) {
                for (CommentTextViewer implementation : this.implementations) {
                    implementation.setTargetEditor(targetEditor);
                }
            }
        }
    }

    public List<CommentTextViewer> getControls() {
        return this.controls;
    }

    public List<CommentTextViewer> getImplementations() {
        return this.implementations;
    }

    public void save() {
        Composite contentComposite = this.container.getContentComposite();
        if (contentComposite != null && !contentComposite.isDisposed()) {
            contentComposite.forceFocus();
        }
    }
}

