/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.ClonedWorkbookRef;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.IWorkbookRef;

public class ClonedTemplate
implements ITemplate {
    private URI sourceWorkbookURI;
    private String name;

    public ClonedTemplate(URI sourceWorkbookURI, String name) {
        Assert.isNotNull((Object)sourceWorkbookURI);
        this.sourceWorkbookURI = sourceWorkbookURI;
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        IWorkbookRef sourceWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(this.sourceWorkbookURI, null);
        if (sourceWorkbookRef != null) {
            return sourceWorkbookRef.getName();
        }
        return "";
    }

    @Override
    public IWorkbookRef createWorkbookRef() {
        return ClonedWorkbookRef.createFromSourceWorkbookURI(this.sourceWorkbookURI, this.name);
    }

    @Override
    public URI getSourceWorkbookURI() {
        return this.sourceWorkbookURI;
    }

    public int hashCode() {
        int h = 0x25 ^ this.sourceWorkbookURI.hashCode();
        if (this.name != null) {
            h ^= this.name.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ClonedTemplate)) {
            return false;
        }
        ClonedTemplate that = (ClonedTemplate)obj;
        return this.sourceWorkbookURI.equals(that.sourceWorkbookURI) && (this.name == that.name || this.name != null && this.name.equals(that.name));
    }
}

