/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;

public class PostponedInfoItemContributor
extends AbstractInfoItemContributor {
    private static IAction showTaskInfoViewAction = null;

    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        if (!this.isTaskInvalid(topic)) {
            return null;
        }
        if (showTaskInfoViewAction == null) {
            showTaskInfoViewAction = new ShowTaskInfoViewAction();
        }
        return showTaskInfoViewAction;
    }

    private boolean isTaskInvalid(ITopic topic) {
        String endDateString;
        DateInfo endDate;
        ITopicExtensionElement content;
        List elements;
        ITopicExtension ext = topic.getExtension("org.xmind.ui.taskInfo");
        if (ext != null && !(elements = (content = ext.getContent()).getChildren("end-date")).isEmpty() && (endDate = TaskInfoUtils.toDateInfo(endDateString = ((ITopicExtensionElement)elements.get(0)).getTextContent())) != null && endDate.date.before(DateInfo.today())) {
            IMarker progressMarker = TaskInfoUtils.findMarker(topic, "taskMakers");
            return progressMarker != null && !"task-done".equals(progressMarker.getId());
        }
        return false;
    }

    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.taskinfo/icons/postponed.svg";
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("taskInfoChange");
        register.register("markerRefAdd");
        register.register("markerRefRemove");
    }

    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        String type = event.getType();
        if ("taskInfoChange".equals(type)) {
            topicPart.refresh();
        } else if ("markerRefAdd".equals(type) || "markerRefRemove".equals(type)) {
            IMarkerGroup group;
            String markerId = (String)event.getTarget();
            IMarker marker = MindMapUI.getResourceManager().getSystemMarkerSheet().findMarker(markerId);
            if (marker != null && (group = marker.getParent()) != null && "taskMakers".equals(group.getId())) {
                topicPart.refresh();
            }
        }
    }

    private static class ShowTaskInfoViewAction
    extends Action {
        private ShowTaskInfoViewAction() {
        }

        public void run() {
            final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)window, (String)"org.xmind.ui.modelPart.taskinfo", null, (String)"org.xmind.ui.stack.right");
                    }
                });
            }
        }
    }
}

