/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.datepicker.DatePicker;
import org.xmind.ui.datepicker.DayFigure;
import org.xmind.ui.datepicker.IAnimationAdvisor;

public abstract class CalendarAnimation {
    protected final IAnimationAdvisor advisor;
    private Runnable callback;
    protected IFigure newPanel;
    protected Dimension oldSize;
    protected List<DayFigure> oldDays = new ArrayList<DayFigure>(31);
    protected List<DayFigure> newDays = new ArrayList<DayFigure>(31);
    protected boolean hasNewPanel;
    protected Rectangle oldInitConstraint;
    protected Rectangle oldFinalConstraint;
    protected Rectangle newInitConstraint;
    protected Rectangle newFinalConstraint;
    private Rectangle oldConstraint;
    private Rectangle newConstraint;
    private long start;

    public CalendarAnimation(IAnimationAdvisor advisor) {
        this.advisor = advisor;
    }

    public CalendarAnimation callback(Runnable callback) {
        this.callback = callback;
        return this;
    }

    public IFigure getNewPanel() {
        return this.newPanel;
    }

    public void start() {
        this.init();
        this.start = System.currentTimeMillis();
        Runnable step = new Runnable(){

            @Override
            public void run() {
                int pass = (int)(System.currentTimeMillis() - CalendarAnimation.this.start);
                if (pass > CalendarAnimation.this.advisor.getDuration()) {
                    CalendarAnimation.this.end();
                } else {
                    CalendarAnimation.this.playback(pass);
                    Display.getCurrent().asyncExec((Runnable)this);
                }
            }
        };
        Display.getCurrent().asyncExec(step);
    }

    private void init() {
        this.oldSize = this.advisor.getPanel().getSize();
        this.initOldDays();
        this.newPanel = this.createNewPanel();
        boolean bl = this.hasNewPanel = this.newPanel != this.advisor.getPanel();
        if (this.hasNewPanel) {
            this.advisor.getLayer().add(this.newPanel);
        }
        this.createNewDays();
        this.initConstraint();
    }

    private void initOldDays() {
        List dayFigures = this.advisor.getPanel().getChildren();
        int i = 0;
        while (i < dayFigures.size()) {
            DayFigure dayFigure = (DayFigure)((Object)dayFigures.get(i));
            this.advisor.initOldDay(dayFigure);
            Calendar date = dayFigure.getDate();
            int month = date.get(2);
            if (month == this.advisor.getOldMonth()) {
                this.oldDays.add(dayFigure);
            } else if (month == this.advisor.getNewMonth()) {
                this.oldDayInNewMonth(dayFigure, date, month, i);
            }
            ++i;
        }
    }

    protected IFigure createNewPanel() {
        return this.advisor.getPanel();
    }

    protected abstract void createNewDays();

    protected void oldDayInNewMonth(DayFigure dayFigure, Calendar date, int month, int index) {
    }

    protected abstract Rectangle createOldInitConstraint();

    protected abstract Rectangle createOldFinalConstraint();

    protected Rectangle createNewInitConstraint() {
        return null;
    }

    protected Rectangle createNewFinalConstraint() {
        return null;
    }

    private void initConstraint() {
        this.hasNewPanel = this.newPanel != this.advisor.getPanel();
        this.oldInitConstraint = this.createOldInitConstraint();
        this.oldFinalConstraint = this.createOldFinalConstraint();
        this.newInitConstraint = this.hasNewPanel ? this.createNewInitConstraint() : null;
        this.newFinalConstraint = this.hasNewPanel ? this.createNewFinalConstraint() : null;
        this.oldConstraint = this.oldInitConstraint.getCopy();
        this.newConstraint = this.hasNewPanel ? this.newInitConstraint.getCopy() : null;
        this.advisor.getLayer().setConstraint(this.advisor.getPanel(), (Object)this.oldConstraint);
        if (this.hasNewPanel) {
            this.advisor.getLayer().setConstraint(this.newPanel, (Object)this.newConstraint);
        }
    }

    private void playback(int elapsed) {
        int duration = this.advisor.getDuration();
        IFigure layer = this.advisor.getLayer();
        this.oldConstraint.x = DatePicker.calc(this.oldInitConstraint.x, this.oldFinalConstraint.x, elapsed, duration);
        this.oldConstraint.y = DatePicker.calc(this.oldInitConstraint.y, this.oldFinalConstraint.y, elapsed, duration);
        layer.setConstraint(this.advisor.getPanel(), (Object)this.oldConstraint);
        if (this.hasNewPanel) {
            this.newConstraint.x = DatePicker.calc(this.newInitConstraint.x, this.newFinalConstraint.x, elapsed, duration);
            this.newConstraint.y = DatePicker.calc(this.newInitConstraint.y, this.newFinalConstraint.y, elapsed, duration);
            layer.setConstraint(this.newPanel, (Object)this.newConstraint);
        }
        for (DayFigure oldDay : this.oldDays) {
            oldDay.setTextAlpha(DatePicker.calc(255, 32, elapsed, duration));
        }
        for (DayFigure newDay : this.newDays) {
            newDay.setTextAlpha(DatePicker.calc(32, 255, elapsed, duration));
        }
    }

    protected void end() {
        this.removeOldDays();
        this.updateNewPanel();
        this.updateJobs();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    protected void removeOldDays() {
    }

    private void updateNewPanel() {
        List dayFigures = this.newPanel.getChildren();
        int i = 0;
        while (i < dayFigures.size()) {
            DayFigure dayFigure = (DayFigure)((Object)dayFigures.get(i));
            this.advisor.updateNewDay(dayFigure);
            ++i;
        }
        this.newPanel.invalidate();
        this.advisor.getLayer().setConstraint(this.newPanel, null);
    }

    protected abstract void updateJobs();
}

