/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IParameter;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.Property;
import org.xmind.gef.EditDomain;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.styleeditor.AdvancedThemesViewer;
import org.xmind.ui.internal.styleeditor.StyleEditModel;
import org.xmind.ui.internal.styleeditor.StyleEditorDialog;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.tools.MindMapSelectTool;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeEditorDialog
extends StyleEditorDialog {
    private static final String FAMILY_THEME = "all";
    private IStyle previewTheme;
    private IStyle inputTheme;
    private Viewer themesViewer;
    private String styleFamily;
    private Combo familyViewer;
    private static Map<String, StyleEditModel> allStyleModels = new HashMap<String, StyleEditModel>();
    private Object trigger;

    public ThemeEditorDialog(IWorkbenchWindow window, IStyle theme) {
        super(window, theme);
    }

    public ThemeEditorDialog(IWorkbenchWindow window, IStyle theme, Object trigger) {
        super(window, theme);
        this.trigger = trigger;
    }

    @Override
    protected StyleEditModel initModel(IStyle theme) {
        IStyle previewStyle = this.getPreselectedStyleFromTheme(theme);
        String resourceURI = StyleEditModel.generateAnonymousURI(previewStyle);
        StyleEditModel model = StyleEditModel.loadAnonymousStyle(previewStyle, resourceURI, previewStyle.getName());
        return model;
    }

    @Override
    protected int demandSaveDialog(Object selectedTheme) {
        if (selectedTheme instanceof IStyle && "theme".equals(((IStyle)selectedTheme).getType())) {
            if (this.inputTheme.equals(selectedTheme)) {
                return -2;
            }
            HashSet<StyleEditModel> dirtyModels = new HashSet<StyleEditModel>();
            for (StyleEditModel dirtyModel : allStyleModels.values()) {
                if (!dirtyModel.isDirty()) continue;
                dirtyModels.add(dirtyModel);
            }
            if (!dirtyModels.isEmpty()) {
                String message = StyleEditorMessages.ThemeEditorDialog_QuestionDialog_ForDirty_description;
                int decision = new StyleEditorDialog.QuestionDialog(this.getShell(), StyleEditorMessages.ThemeEditorDialog_QuestionDialog_ForDirty_title, message).open();
                if (decision == 2 || decision == -1) {
                    if (this.themesViewer != null) {
                        this.themesViewer.setSelection((ISelection)new StructuredSelection((Object)this.inputTheme));
                    }
                } else if (decision == 1) {
                    for (StyleEditModel dirty : dirtyModels) {
                        dirty.clean();
                    }
                } else if (decision == 0) {
                    this.save();
                }
                return decision;
            }
        }
        return 3;
    }

    @Override
    protected IStyle updateForCreateNew(Object obj) {
        if (AdvancedThemesViewer.ADD_THEME.equals(obj)) {
            IStyleSheet userThemeSheet = MindMapUI.getResourceManager().getUserThemeSheet();
            IStyle themeCreated = userThemeSheet.createStyle("theme");
            themeCreated.setName(StyleEditorMessages.ThemeEditorDialog_NewTheme_UntitledName);
            userThemeSheet.addStyle(themeCreated, "master-styles");
            MindMapUI.getResourceManager().saveUserThemeSheet();
            return themeCreated;
        }
        return null;
    }

    @Override
    protected IStyle transformIntoPreselectedStyle(IStyle theme) {
        IStyle preselectedStyle = this.getPreselectedStyleFromTheme(theme);
        this.familyViewer.select(this.getStyleFamilyNames().indexOf(this.styleFamily));
        this.changeStyleFamily(this.styleFamily);
        return preselectedStyle;
    }

    private IStyle getPreselectedStyleFromTheme(IStyle theme) {
        IStyle preselectedStyle = theme;
        if (theme.getType().equals("theme")) {
            this.inputTheme = theme;
            this.previewTheme = this.initTheme(theme);
            this.styleFamily = "centralTopic";
            for (String sf : this.getStyleFamilyNames()) {
                IStyle style = this.previewTheme.getDefaultStyle(sf);
                if (style == null) {
                    IStyleSheet previewStyleSheet = this.getPreviewWorbook().getStyleSheet();
                    String styleType = this.transformStyleFamilyToStyleType(sf);
                    style = previewStyleSheet.createStyle(styleType);
                    if ("theme".equals(styleType)) {
                        for (String csf : this.getStyleFamilyNames()) {
                            style.setProperty(csf, this.previewTheme.getDefaultStyleId(csf));
                        }
                    }
                    this.previewTheme.setDefaultStyleId(sf, style.getId());
                    previewStyleSheet.addStyle(style, "automatic-styles");
                }
                String resourceURI = StyleEditModel.generateAnonymousURI(style);
                StyleEditModel model = StyleEditModel.loadAnonymousStyle(style, resourceURI, style.getName());
                model.addListener(this.modelListener);
                if (this.styleFamily.equals(sf)) {
                    preselectedStyle = style;
                }
                allStyleModels.put(sf, model);
            }
        }
        return preselectedStyle;
    }

    @Override
    protected Viewer createStyleViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label title = new Label(composite, 16384);
        title.setText(StyleEditorMessages.ThemeEditorDialog_ThemesViewerSection_title);
        title.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        this.themesViewer = new AdvancedThemesViewer(composite);
        this.themesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.themesViewer.setInput(this.getStyleViewerInput());
        this.themesViewer.setSelection(this.getFirstSelectedElement(), true);
        return this.themesViewer;
    }

    @Override
    protected ISelection getFirstSelectedElement() {
        if (this.inputTheme != null) {
            return new StructuredSelection((Object)this.inputTheme);
        }
        return StructuredSelection.EMPTY;
    }

    @Override
    protected Object getStyleViewerInput() {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet systemThemeSheets = resourceManager.getSystemThemeSheet();
        Set systemThemes = systemThemeSheets.getStyles("master-styles");
        IStyleSheet userThemeSheets = resourceManager.getUserThemeSheet();
        Set userThemes = userThemeSheets.getStyles("master-styles");
        ArrayList<Object> list = new ArrayList<Object>(systemThemes.size() + userThemes.size() + 2);
        list.add(AdvancedThemesViewer.ADD_THEME);
        list.addAll(this.getReversed(userThemes));
        list.addAll(systemThemes);
        list.add(resourceManager.getBlankTheme());
        return list;
    }

    private List<Object> getReversed(Collection<?> sourceList) {
        LinkedList<Object> targetList = new LinkedList<Object>();
        for (Object item : sourceList) {
            targetList.add(0, item);
        }
        return targetList;
    }

    @Override
    protected void addExtraCapacityForPreview(MindMapViewer previewer) {
        super.addExtraCapacityForPreview(previewer);
        EditDomain editDomain = new EditDomain();
        previewer.setEditDomain(editDomain);
        editDomain.installTool("select tool", (ITool)new MindMapSelectTool());
        previewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    String styleFamily = null;
                    Object element = ((StructuredSelection)selection).getFirstElement();
                    if (element instanceof ITopic) {
                        ITopic topic = (ITopic)element;
                        ITopic centralToic = ThemeEditorDialog.this.getPreviewWorbook().getPrimarySheet().getRootTopic();
                        if (topic.equals(centralToic)) {
                            styleFamily = "centralTopic";
                        } else if (topic.isAttached()) {
                            styleFamily = "summary".equals(topic.getType()) ? "summaryTopic" : (centralToic.equals(topic.getParent()) ? "mainTopic" : "subTopic");
                        } else if ("detached".equals(topic.getType())) {
                            styleFamily = "floatingTopic";
                        } else if ("summary".equals(topic.getType())) {
                            styleFamily = "summaryTopic";
                        } else if ("callout".equals(topic.getType())) {
                            styleFamily = "calloutTopic";
                        }
                    } else if (element instanceof ISheet) {
                        styleFamily = "map";
                    } else if (element instanceof IBoundary) {
                        styleFamily = "boundary";
                    } else if (element instanceof IRelationship) {
                        styleFamily = "relationship";
                    }
                    ThemeEditorDialog.this.familyViewer.select(ThemeEditorDialog.this.getStyleFamilyNames().indexOf(styleFamily));
                    ThemeEditorDialog.this.changeStyleFamily(styleFamily);
                }
            }
        });
    }

    @Override
    protected Composite createEditorTopSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 6;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label title = new Label(composite, 16384);
        title.setText(StyleEditorMessages.ThemeEditorDialog_EditorTopSection_text);
        title.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        this.familyViewer = new Combo(composite, 12);
        this.familyViewer.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        this.familyViewer.setLayoutData((Object)new GridData(4, 4, true, false));
        for (String item : this.getStyleFamilyNames()) {
            this.familyViewer.add(this.transformStyleFamilyToDisplayName(item));
        }
        this.styleFamily = "centralTopic";
        this.familyViewer.select(this.getStyleFamilyNames().indexOf(this.styleFamily));
        this.familyViewer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source instanceof Combo) {
                    Combo widget = (Combo)source;
                    int index = widget.getSelectionIndex();
                    ThemeEditorDialog.this.changeStyleFamily((String)ThemeEditorDialog.this.getStyleFamilyNames().get(index));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void changeStyleFamily(String newStyleFamily) {
        this.styleFamily = newStyleFamily;
        IStyle style = this.previewTheme.getDefaultStyle(this.styleFamily);
        if (style == null) {
            IStyleSheet styleSheet = this.previewTheme.getOwnedStyleSheet();
            style = styleSheet.createStyle(this.transformStyleFamilyToStyleType(this.styleFamily));
            styleSheet.addStyle(style, "automatic-styles");
            this.previewTheme.setDefaultStyleId(this.styleFamily, style.getId());
        }
        this.updatePropertiesEditorFilter(this.styleFamily);
        this.updateForChangeModel(style);
    }

    private void updatePropertiesEditorFilter(String styleFamily) {
        String elementType = this.transformStyleFamilyToStyleType(styleFamily);
        ArrayList<String> filtedDescriptorIds = new ArrayList<String>();
        if ("topic".equals(elementType)) {
            if ("calloutTopic".equals(styleFamily)) {
                filtedDescriptorIds.add("shape-class");
                this.getPropertiesEditor().setFilter(filtedDescriptorIds);
            } else {
                filtedDescriptorIds.add("callout-shape-class");
            }
        }
        this.getPropertiesEditor().setFilter(filtedDescriptorIds);
    }

    private List<String> getStyleFamilyNames() {
        ArrayList<String> styleFamilyNames = new ArrayList<String>();
        styleFamilyNames.add("centralTopic");
        styleFamilyNames.add("mainTopic");
        styleFamilyNames.add("subTopic");
        styleFamilyNames.add("calloutTopic");
        styleFamilyNames.add("floatingTopic");
        styleFamilyNames.add("map");
        styleFamilyNames.add("boundary");
        styleFamilyNames.add("relationship");
        styleFamilyNames.add("summary");
        styleFamilyNames.add("summaryTopic");
        styleFamilyNames.add(FAMILY_THEME);
        return styleFamilyNames;
    }

    private String transformStyleFamilyToDisplayName(String family) {
        if (FAMILY_THEME.equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_theme;
        }
        if ("map".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_map;
        }
        if ("centralTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_centralTopic;
        }
        if ("mainTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_mainTopic;
        }
        if ("subTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_subtopic;
        }
        if ("floatingTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_floatingTopic;
        }
        if ("boundary".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_bundary;
        }
        if ("relationship".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_relationship;
        }
        if ("summary".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_summary;
        }
        if ("summaryTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_summaryTopic;
        }
        if ("calloutTopic".equals(family)) {
            return StyleEditorMessages.ThemeEditorDialog_StyleFamily_DisplayName_calloutTopic;
        }
        return null;
    }

    private String transformStyleFamilyToStyleType(String family) {
        if ("centralTopic".equals(family) || "mainTopic".equals(family) || "subTopic".equals(family) || "summaryTopic".equals(family) || "floatingTopic".equals(family) || "calloutTopic".equals(family)) {
            return "topic";
        }
        if ("relationship".equals(family)) {
            return "relationship";
        }
        if ("boundary".equals(family)) {
            return "boundary";
        }
        if ("map".equals(family)) {
            return "map";
        }
        if ("summary".equals(family)) {
            return "summary";
        }
        if (FAMILY_THEME.equals(family)) {
            return "theme";
        }
        return null;
    }

    @Override
    protected void updatePreview(StyleEditModel model) {
        String styleId = StyleEditModel.getAnonymousStyleId(model.getURI());
        model.writeStyle(this.previewTheme.getDefaultStyleById(styleId));
        IStyle newPreviewTheme = this.previewTheme;
        if (model.isModifyByAll()) {
            return;
        }
        ISheet sheet = this.getPreviewWorbook().getPrimarySheet();
        sheet.setThemeId(null);
        sheet.setStyleId(null);
        sheet.setThemeId(newPreviewTheme.getId());
        sheet.setStyleId(newPreviewTheme.getDefaultStyleId("map"));
    }

    private IStyle initTheme(IStyle theme) {
        IStyleSheet previewStyleSheet = this.getPreviewWorbook().getStyleSheet();
        IStyle tempTheme = previewStyleSheet.importStyle(theme);
        if (tempTheme == null) {
            tempTheme = previewStyleSheet.createStyle("theme");
        }
        IStyle previewTheme = previewStyleSheet.createStyle(tempTheme.getType());
        previewTheme.setName(theme.getName());
        Iterator defaultStyles = tempTheme.defaultStyles();
        while (defaultStyles.hasNext()) {
            Property p = (Property)defaultStyles.next();
            IStyle defaultStyle = tempTheme.getDefaultStyle(p.key);
            if (defaultStyle == null) continue;
            IStyle styleCreated = previewStyleSheet.createStyle(defaultStyle.getType());
            Iterator ps = defaultStyle.properties();
            while (ps.hasNext()) {
                Property next = (Property)ps.next();
                styleCreated.setProperty(next.key, next.value);
            }
            styleCreated.setName(defaultStyle.getName());
            previewTheme.setDefaultStyleId(p.key, styleCreated.getId());
            previewStyleSheet.addStyle(styleCreated, "automatic-styles");
        }
        previewStyleSheet.addStyle(previewTheme, "master-styles");
        return previewTheme;
    }

    @Override
    protected void updateDirtyState() {
        final Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean dirty = ThemeEditorDialog.this.trigger instanceof IParameter || ThemeEditorDialog.this.isDirtyTheme();
                    okButton.setEnabled(dirty);
                    okButton.setText(!ThemeEditorDialog.this.isModifiableTheme() ? StyleEditorMessages.ThemeEditorDialog_SaveAs_text : StyleEditorMessages.ThemeEditorDialog_Save_text);
                    ThemeEditorDialog.this.getShell().setModified(dirty);
                }
            });
        }
    }

    private boolean isDirtyTheme() {
        boolean themeDirty = false;
        for (StyleEditModel dirtyModel : allStyleModels.values()) {
            if (dirtyModel.getType().equals("theme") || !dirtyModel.isDirty()) continue;
            themeDirty = true;
        }
        return themeDirty;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StyleEditorMessages.ThemeEditorDialog_title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.createButton(parent, 0, StyleEditorMessages.ThemeEditorDialog_SaveAs_text, false);
        this.createButton(parent, 12, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected void okPressed() {
        this.save();
    }

    protected IStyle save() {
        IStyle style = null;
        style = this.isModifiableTheme() && this.inputTheme.defaultStyles().hasNext() ? this.saveTheme() : this.saveAsNewTheme();
        for (String family : this.getStyleFamilyNames()) {
            StyleEditModel modifiedStyle = allStyleModels.get(family);
            if (modifiedStyle == null) continue;
            modifiedStyle.clean();
        }
        MindMapUI.getResourceManager().saveUserThemeSheet();
        if (this.themesViewer != null) {
            this.themesViewer.setSelection((ISelection)new StructuredSelection((Object)style));
        }
        this.revealThemesView(style);
        return style;
    }

    private boolean isModifiableTheme() {
        IStyleSheet styleSheet = this.inputTheme.getOwnedStyleSheet();
        return styleSheet == MindMapUI.getResourceManager().getUserThemeSheet();
    }

    private IStyle saveTheme() {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet userThemeSheet = resourceManager.getUserThemeSheet();
        IStyle importedStyle = this.inputTheme;
        userThemeSheet.removeStyle(this.inputTheme);
        this.filterCommonProperty(this.previewTheme);
        importedStyle = userThemeSheet.importStyle(this.previewTheme);
        importedStyle.setName(this.previewTheme.getName());
        return importedStyle;
    }

    private IStyle saveAsNewTheme() {
        this.filterCommonProperty(this.previewTheme);
        IStyle themeCreated = MindMapUI.getResourceManager().getUserThemeSheet().importStyle(this.previewTheme);
        themeCreated.setName(StyleEditorMessages.ThemeEditorDialog_NewTheme_UntitledName);
        return themeCreated;
    }

    private void filterCommonProperty(IStyle previewTheme) {
        IStyle style = previewTheme.getDefaultStyle(FAMILY_THEME);
        Iterator iter = style.properties();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            style.setProperty(property.key, null);
        }
        previewTheme.setDefaultStyleId(FAMILY_THEME, null);
    }

    private void revealThemesView(IStyle newTheme) {
        if (newTheme == null) {
            return;
        }
        IWorkbenchPage activePage = this.parentWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return;
        }
        IWorkbenchPartSite site = activePart.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        selectionProvider.setSelection((ISelection)new StructuredSelection((Object)newTheme));
    }

    @Override
    protected void closePressed() {
        boolean themeDirty = this.isDirtyTheme();
        if (themeDirty) {
            String message = StyleEditorMessages.ThemeEditorDialog_QuestionDialog_ForDirty_description;
            int decision = new StyleEditorDialog.QuestionDialog(this.getShell(), StyleEditorMessages.ThemeEditorDialog_QuestionDialog_ForDirty_title, message).open();
            if (decision == 0) {
                this.save();
            } else {
                if (decision == -1 || decision == 2) {
                    return;
                }
                if (decision == 1) {
                    for (StyleEditModel dirtyModel : allStyleModels.values()) {
                        if (!dirtyModel.isDirty()) continue;
                        dirtyModel.clean();
                    }
                }
            }
        }
        IEclipseContext context = ((WorkbenchWindow)this.parentWindow).getModel().getContext();
        context.remove("selection");
        IEvaluationService es = (IEvaluationService)this.parentWindow.getWorkbench().getService(IEvaluationService.class);
        es.getCurrentState().addVariable("selection", (Object)new StructuredSelection((Object)this.inputTheme));
        this.setReturnCode(0);
        this.close();
    }

    public boolean close() {
        allStyleModels.clear();
        return super.close();
    }
}

