/* mgcLibrary.c was originally generated by the autoSql program, which also 
 * generated mgcLibrary.h and mgcLibrary.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gbSql.h"
#include "mgcLibrary.h"
#include "gbFileOps.h"


void mgcLibraryStaticLoad(char **row, struct mgcLibrary *ret)
/* Load a row from mgcLibrary table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->id_lib = sqlSigned(row[0]);
ret->flc_id = row[1];
ret->id_rna = row[2];
ret->id_vendor = gbSqlSignedNull(row[3]);
ret->id_method = gbSqlSignedNull(row[4]);
ret->normal = gbSqlSignedNull(row[5]);
ret->commnt = row[6];
ret->rate_success = atof(row[7]);
ret->human_repeats = atof(row[8]);
ret->mito_rna = atof(row[9]);
ret->ecoli = atof(row[10]);
ret->yeast = atof(row[11]);
ret->mouse = atof(row[12]);
ret->diversity = atof(row[13]);
ret->uniqueness = atof(row[14]);
ret->genes = gbSqlSignedNull(row[15]);
ret->discover = gbSqlSignedNull(row[16]);
ret->flc_disc = gbSqlSignedNull(row[17]);
ret->novel = gbSqlSignedNull(row[18]);
ret->future = atof(row[19]);
ret->internal_primed = atof(row[20]);
ret->full_length = atof(row[21]);
ret->priority = atof(row[22]);
ret->id_unigene = gbSqlSignedNull(row[23]);
ret->organism = row[24];
ret->vector = row[25];
ret->host = row[26];
ret->vec_contam = atof(row[27]);
ret->mean_insize = atof(row[28]);
ret->linker = row[29];
}

struct mgcLibrary *mgcLibraryLoad(char **row)
/* Load a mgcLibrary from row fetched with select * from mgcLibrary
 * from database.  Dispose of this with mgcLibraryFree(). */
{
struct mgcLibrary *ret;

AllocVar(ret);
ret->id_lib = sqlSigned(row[0]);
ret->flc_id = cloneString(row[1]);
ret->id_rna = cloneString(row[2]);
ret->id_vendor = gbSqlSignedNull(row[3]);
ret->id_method = gbSqlSignedNull(row[4]);
ret->normal = gbSqlSignedNull(row[5]);
ret->commnt = cloneString(row[6]);
ret->rate_success = atof(row[7]);
ret->human_repeats = atof(row[8]);
ret->mito_rna = atof(row[9]);
ret->ecoli = atof(row[10]);
ret->yeast = atof(row[11]);
ret->mouse = atof(row[12]);
ret->diversity = atof(row[13]);
ret->uniqueness = atof(row[14]);
ret->genes = gbSqlSignedNull(row[15]);
ret->discover = gbSqlSignedNull(row[16]);
ret->flc_disc = gbSqlSignedNull(row[17]);
ret->novel = gbSqlSignedNull(row[18]);
ret->future = atof(row[19]);
ret->internal_primed = atof(row[20]);
ret->full_length = atof(row[21]);
ret->priority = atof(row[22]);
ret->id_unigene = gbSqlSignedNull(row[23]);
ret->organism = cloneString(row[24]);
ret->vector = cloneString(row[25]);
ret->host = cloneString(row[26]);
ret->vec_contam = atof(row[27]);
ret->mean_insize = atof(row[28]);
ret->linker = cloneString(row[29]);
return ret;
}

struct mgcLibrary *mgcLibraryLoadAll(char *fileName) 
/* Load all mgcLibrary from a whitespace-separated file.
 * Dispose of this with mgcLibraryFreeList(). */
{
struct mgcLibrary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[30];

while (lineFileRow(lf, row))
    {
    el = mgcLibraryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mgcLibrary *mgcLibraryCommaIn(char **pS, struct mgcLibrary *ret)
/* Create a mgcLibrary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mgcLibrary */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id_lib = sqlSignedComma(&s);
ret->flc_id = sqlStringComma(&s);
ret->id_rna = sqlStringComma(&s);
ret->id_vendor = sqlSignedComma(&s);
ret->id_method = sqlSignedComma(&s);
ret->normal = sqlSignedComma(&s);
ret->commnt = sqlStringComma(&s);
ret->rate_success = sqlFloatComma(&s);
ret->human_repeats = sqlFloatComma(&s);
ret->mito_rna = sqlFloatComma(&s);
ret->ecoli = sqlFloatComma(&s);
ret->yeast = sqlFloatComma(&s);
ret->mouse = sqlFloatComma(&s);
ret->diversity = sqlFloatComma(&s);
ret->uniqueness = sqlFloatComma(&s);
ret->genes = sqlSignedComma(&s);
ret->discover = sqlSignedComma(&s);
ret->flc_disc = sqlSignedComma(&s);
ret->novel = sqlSignedComma(&s);
ret->future = sqlFloatComma(&s);
ret->internal_primed = sqlFloatComma(&s);
ret->full_length = sqlFloatComma(&s);
ret->priority = sqlFloatComma(&s);
ret->id_unigene = sqlSignedComma(&s);
ret->organism = sqlStringComma(&s);
ret->vector = sqlStringComma(&s);
ret->host = sqlStringComma(&s);
ret->vec_contam = sqlFloatComma(&s);
ret->mean_insize = sqlFloatComma(&s);
ret->linker = sqlStringComma(&s);
*pS = s;
return ret;
}

void mgcLibraryFree(struct mgcLibrary **pEl)
/* Free a single dynamically allocated mgcLibrary such as created
 * with mgcLibraryLoad(). */
{
struct mgcLibrary *el;

if ((el = *pEl) == NULL) return;
freeMem(el->flc_id);
freeMem(el->id_rna);
freeMem(el->commnt);
freeMem(el->organism);
freeMem(el->vector);
freeMem(el->host);
freeMem(el->linker);
freez(pEl);
}

void mgcLibraryFreeList(struct mgcLibrary **pList)
/* Free a list of dynamically allocated mgcLibrary's */
{
struct mgcLibrary *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mgcLibraryFree(&el);
    }
*pList = NULL;
}

void mgcLibraryOutput(struct mgcLibrary *el, FILE *f, char sep, char lastSep) 
/* Print out mgcLibrary.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id_lib);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->flc_id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id_rna);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->id_vendor);
fputc(sep,f);
fprintf(f, "%d", el->id_method);
fputc(sep,f);
fprintf(f, "%d", el->normal);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commnt);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->rate_success);
fputc(sep,f);
fprintf(f, "%f", el->human_repeats);
fputc(sep,f);
fprintf(f, "%f", el->mito_rna);
fputc(sep,f);
fprintf(f, "%f", el->ecoli);
fputc(sep,f);
fprintf(f, "%f", el->yeast);
fputc(sep,f);
fprintf(f, "%f", el->mouse);
fputc(sep,f);
fprintf(f, "%f", el->diversity);
fputc(sep,f);
fprintf(f, "%f", el->uniqueness);
fputc(sep,f);
fprintf(f, "%d", el->genes);
fputc(sep,f);
fprintf(f, "%d", el->discover);
fputc(sep,f);
fprintf(f, "%d", el->flc_disc);
fputc(sep,f);
fprintf(f, "%d", el->novel);
fputc(sep,f);
fprintf(f, "%f", el->future);
fputc(sep,f);
fprintf(f, "%f", el->internal_primed);
fputc(sep,f);
fprintf(f, "%f", el->full_length);
fputc(sep,f);
fprintf(f, "%f", el->priority);
fputc(sep,f);
fprintf(f, "%d", el->id_unigene);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->organism);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->vector);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->host);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->vec_contam);
fputc(sep,f);
fprintf(f, "%f", el->mean_insize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->linker);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct mgcLibraryTbl *mgcLibraryTblLoad(char *fileName)
/* load a file of mgcLibrary objects, building a hash by library id */
{
struct mgcLibraryTbl *mlt;
char *row[MGCLIBRARY_NUM_COLS];
char key[64];
struct lineFile *lf;
AllocVar(mlt);
mlt->idHash = hashNew(12); /* 4096 */

lf = gzLineFileOpen(fileName);
while (lineFileNextRowTab(lf, row, MGCLIBRARY_NUM_COLS))
    {
    struct mgcLibrary *mgcLibrary = mgcLibraryLoad(row);
    safef(key, sizeof(key), "%d", mgcLibrary->id_lib);
    hashAdd(mlt->idHash, key, mgcLibrary);
    }

gzLineFileClose(&lf);
return mlt;
}

void mgcLibraryTblFree(struct mgcLibraryTbl **mltPtr)
/* free a mgcLibraryTbl object */
{
struct mgcLibraryTbl *mlt = *mltPtr;
if (mlt != NULL)
    {
    struct hashCookie cookie = hashFirst(mlt->idHash);
    struct hashEl *hel;
    while ((hel = hashNext(&cookie)) != NULL)
        mgcLibraryFree((struct mgcLibrary**)&hel->val);
    hashFree(&mlt->idHash);
    free(mlt);
    *mltPtr = NULL;
    }
}

struct mgcLibrary *mgcLibraryTblFind(struct mgcLibraryTbl *mlt,
                                     int libraryId)
/* Find a mgcLibrary object by libraryId, or NULL if not found */
{
char key[64];
struct hashEl *hel;
safef(key, sizeof(key), "%d", libraryId);
hel = hashLookup(mlt->idHash, key);
if (hel == NULL)
    return NULL;
else
    return hel->val;
}

