/* jaxOrtholog.c was originally generated by the autoSql program, which also 
 * generated jaxOrtholog.h and jaxOrtholog.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "jaxOrtholog.h"


void jaxOrthologStaticLoad(char **row, struct jaxOrtholog *ret)
/* Load a row from jaxOrtholog table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->humanSymbol = row[0];
ret->humanBand = row[1];
ret->mgiId = row[2];
ret->mouseSymbol = row[3];
ret->mouseChr = row[4];
ret->mouseCm = row[5];
ret->mouseBand = row[6];
}

struct jaxOrtholog *jaxOrthologLoad(char **row)
/* Load a jaxOrtholog from row fetched with select * from jaxOrtholog
 * from database.  Dispose of this with jaxOrthologFree(). */
{
struct jaxOrtholog *ret;

AllocVar(ret);
ret->humanSymbol = cloneString(row[0]);
ret->humanBand = cloneString(row[1]);
ret->mgiId = cloneString(row[2]);
ret->mouseSymbol = cloneString(row[3]);
ret->mouseChr = cloneString(row[4]);
ret->mouseCm = cloneString(row[5]);
ret->mouseBand = cloneString(row[6]);
return ret;
}

struct jaxOrtholog *jaxOrthologLoadAll(char *fileName) 
/* Load all jaxOrtholog from a tab-separated file.
 * Dispose of this with jaxOrthologFreeList(). */
{
struct jaxOrtholog *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = jaxOrthologLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jaxOrtholog *jaxOrthologLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all jaxOrtholog from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with jaxOrthologFreeList(). */
{
struct jaxOrtholog *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = jaxOrthologLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct jaxOrtholog *jaxOrthologCommaIn(char **pS, struct jaxOrtholog *ret)
/* Create a jaxOrtholog out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jaxOrtholog */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->humanSymbol = sqlStringComma(&s);
ret->humanBand = sqlStringComma(&s);
ret->mgiId = sqlStringComma(&s);
ret->mouseSymbol = sqlStringComma(&s);
ret->mouseChr = sqlStringComma(&s);
ret->mouseCm = sqlStringComma(&s);
ret->mouseBand = sqlStringComma(&s);
*pS = s;
return ret;
}

void jaxOrthologFree(struct jaxOrtholog **pEl)
/* Free a single dynamically allocated jaxOrtholog such as created
 * with jaxOrthologLoad(). */
{
struct jaxOrtholog *el;

if ((el = *pEl) == NULL) return;
freeMem(el->humanSymbol);
freeMem(el->humanBand);
freeMem(el->mgiId);
freeMem(el->mouseSymbol);
freeMem(el->mouseChr);
freeMem(el->mouseCm);
freeMem(el->mouseBand);
freez(pEl);
}

void jaxOrthologFreeList(struct jaxOrtholog **pList)
/* Free a list of dynamically allocated jaxOrtholog's */
{
struct jaxOrtholog *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jaxOrthologFree(&el);
    }
*pList = NULL;
}

void jaxOrthologOutput(struct jaxOrtholog *el, FILE *f, char sep, char lastSep) 
/* Print out jaxOrtholog.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->humanSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->humanBand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mouseSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mouseChr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mouseCm);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mouseBand);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

