/* gbMiscDiff.c was originally generated by the autoSql program, which also 
 * generated gbMiscDiff.h and gbMiscDiff.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gbMiscDiff.h"


void gbMiscDiffStaticLoad(char **row, struct gbMiscDiff *ret)
/* Load a row from gbMiscDiff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

strcpy(ret->acc, row[0]);
ret->mrnaStart = sqlSigned(row[1]);
ret->mrnaEnd = sqlSigned(row[2]);
ret->notes = row[3];
ret->gene = row[4];
ret->replacement = row[5];
}

struct gbMiscDiff *gbMiscDiffLoad(char **row)
/* Load a gbMiscDiff from row fetched with select * from gbMiscDiff
 * from database.  Dispose of this with gbMiscDiffFree(). */
{
struct gbMiscDiff *ret;

AllocVar(ret);
strcpy(ret->acc, row[0]);
ret->mrnaStart = sqlSigned(row[1]);
ret->mrnaEnd = sqlSigned(row[2]);
ret->notes = cloneString(row[3]);
ret->gene = cloneString(row[4]);
ret->replacement = cloneString(row[5]);
return ret;
}

struct gbMiscDiff *gbMiscDiffLoadAll(char *fileName) 
/* Load all gbMiscDiff from a whitespace-separated file.
 * Dispose of this with gbMiscDiffFreeList(). */
{
struct gbMiscDiff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = gbMiscDiffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbMiscDiff *gbMiscDiffLoadAllByChar(char *fileName, char chopper) 
/* Load all gbMiscDiff from a chopper separated file.
 * Dispose of this with gbMiscDiffFreeList(). */
{
struct gbMiscDiff *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gbMiscDiffLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbMiscDiff *gbMiscDiffCommaIn(char **pS, struct gbMiscDiff *ret)
/* Create a gbMiscDiff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbMiscDiff */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->acc, sizeof(ret->acc));
ret->mrnaStart = sqlSignedComma(&s);
ret->mrnaEnd = sqlSignedComma(&s);
ret->notes = sqlStringComma(&s);
ret->gene = sqlStringComma(&s);
ret->replacement = sqlStringComma(&s);
*pS = s;
return ret;
}

void gbMiscDiffFree(struct gbMiscDiff **pEl)
/* Free a single dynamically allocated gbMiscDiff such as created
 * with gbMiscDiffLoad(). */
{
struct gbMiscDiff *el;

if ((el = *pEl) == NULL) return;
freeMem(el->notes);
freeMem(el->gene);
freeMem(el->replacement);
freez(pEl);
}

void gbMiscDiffFreeList(struct gbMiscDiff **pList)
/* Free a list of dynamically allocated gbMiscDiff's */
{
struct gbMiscDiff *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gbMiscDiffFree(&el);
    }
*pList = NULL;
}

void gbMiscDiffOutput(struct gbMiscDiff *el, FILE *f, char sep, char lastSep) 
/* Print out gbMiscDiff.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->mrnaStart);
fputc(sep,f);
fprintf(f, "%d", el->mrnaEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notes);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gene);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->replacement);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

