/* taxonDivision.h was originally generated by the autoSql program, which also 
 * generated taxonDivision.c and taxonDivision.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef TAXONDIVISION_H
#define TAXONDIVISION_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define TAXONDIVISION_NUM_COLS 4

struct taxonDivision
/* ncbi taxonomy high level divisions */
    {
    struct taxonDivision *next;  /* Next in singly linked list. */
    unsigned id;	/* division id in GenBank taxonomy database */
    char code[4];	/* division code 3 characters  */
    char *name;	/* division name e.g. BCT, PLN, VRT, MAM, PRI... */
    char *comments;	/* free-text comments  */
    };

void taxonDivisionStaticLoad(char **row, struct taxonDivision *ret);
/* Load a row from taxonDivision table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct taxonDivision *taxonDivisionLoad(char **row);
/* Load a taxonDivision from row fetched with select * from taxonDivision
 * from database.  Dispose of this with taxonDivisionFree(). */

struct taxonDivision *taxonDivisionLoadAll(char *fileName);
/* Load all taxonDivision from whitespace-separated file.
 * Dispose of this with taxonDivisionFreeList(). */

struct taxonDivision *taxonDivisionLoadAllByChar(char *fileName, char chopper);
/* Load all taxonDivision from chopper separated file.
 * Dispose of this with taxonDivisionFreeList(). */

#define taxonDivisionLoadAllByTab(a) taxonDivisionLoadAllByChar(a, '\t');
/* Load all taxonDivision from tab separated file.
 * Dispose of this with taxonDivisionFreeList(). */

struct taxonDivision *taxonDivisionLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all taxonDivision from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with taxonDivisionFreeList(). */

void taxonDivisionSaveToDb(struct sqlConnection *conn, struct taxonDivision *el, char *tableName, int updateSize);
/* Save taxonDivision as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use taxonDivisionSaveToDbEscaped() */

void taxonDivisionSaveToDbEscaped(struct sqlConnection *conn, struct taxonDivision *el, char *tableName, int updateSize);
/* Save taxonDivision as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than taxonDivisionSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct taxonDivision *taxonDivisionCommaIn(char **pS, struct taxonDivision *ret);
/* Create a taxonDivision out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new taxonDivision */

void taxonDivisionFree(struct taxonDivision **pEl);
/* Free a single dynamically allocated taxonDivision such as created
 * with taxonDivisionLoad(). */

void taxonDivisionFreeList(struct taxonDivision **pList);
/* Free a list of dynamically allocated taxonDivision's */

void taxonDivisionOutput(struct taxonDivision *el, FILE *f, char sep, char lastSep);
/* Print out taxonDivision.  Separate fields with sep. Follow last field with lastSep. */

#define taxonDivisionTabOut(el,f) taxonDivisionOutput(el,f,'\t','\n');
/* Print out taxonDivision as a line in a tab-separated file. */

#define taxonDivisionCommaOut(el,f) taxonDivisionOutput(el,f,',',',');
/* Print out taxonDivision as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TAXONDIVISION_H */

