/* genMapDb.h was originally generated by the autoSql program, which also 
 * generated genMapDb.c and genMapDb.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GENMAPDB_H
#define GENMAPDB_H

struct genMapDb
/* Clones positioned on the assembly by U Penn (V. Cheung) */
    {
    struct genMapDb *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of Clone */
    unsigned score;	/* Score - always 1000 */
    char strand[2];	/* + or - */
    char *accT7;	/* Accession number for T7 BAC end sequence */
    unsigned startT7;	/* Start position in chrom for T7 end sequence */
    unsigned endT7;	/* End position in chrom for T7 end sequence */
    char strandT7[2];	/* + or - */
    char *accSP6;	/* Accession number for SP6 BAC end sequence */
    unsigned startSP6;	/* Start position in chrom for SP6 end sequence */
    unsigned endSP6;	/* End position in chrom for SP6 end sequence */
    char strandSP6[2];	/* + or - */
    char *stsMarker;	/* Name of STS marker found in clone */
    unsigned stsStart;	/* Start position in chrom for STS marker */
    unsigned stsEnd;	/* End position in chrom for STS marker */
    };

void genMapDbStaticLoad(char **row, struct genMapDb *ret);
/* Load a row from genMapDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct genMapDb *genMapDbLoad(char **row);
/* Load a genMapDb from row fetched with select * from genMapDb
 * from database.  Dispose of this with genMapDbFree(). */

struct genMapDb *genMapDbLoadAll(char *fileName);
/* Load all genMapDb from a tab-separated file.
 * Dispose of this with genMapDbFreeList(). */

struct genMapDb *genMapDbLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all genMapDb from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with genMapDbFreeList(). */

struct genMapDb *genMapDbCommaIn(char **pS, struct genMapDb *ret);
/* Create a genMapDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genMapDb */

void genMapDbFree(struct genMapDb **pEl);
/* Free a single dynamically allocated genMapDb such as created
 * with genMapDbLoad(). */

void genMapDbFreeList(struct genMapDb **pList);
/* Free a list of dynamically allocated genMapDb's */

void genMapDbOutput(struct genMapDb *el, FILE *f, char sep, char lastSep);
/* Print out genMapDb.  Separate fields with sep. Follow last field with lastSep. */

#define genMapDbTabOut(el,f) genMapDbOutput(el,f,'\t','\n');
/* Print out genMapDb as a line in a tab-separated file. */

#define genMapDbCommaOut(el,f) genMapDbOutput(el,f,',',',');
/* Print out genMapDb as a comma separated list including final comma. */

#endif /* GENMAPDB_H */

