# spliceGraph.sql was originally generated by the autoSql program, which also 
# generated spliceGraph.c and spliceGraph.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A Single splice site node in a splicing graph
CREATE TABLE spliceNode (
    tName varchar(255) not null,	# name of target sequence, often a chrom.
    tStart int not null,	# start in tName.
    tEnd int not null,	# end in tName.
    strand char(2) not null,	# + or - strand.
    id int unsigned not null,	# Unique ID.
    type int unsigned not null,	# Type of splice site, see enum ggVertexType.
    class int unsigned not null,	# Number of node in graph, different than ID.
    color int unsigned not null,	# Used for algorithm classification.
    edgeCount int unsigned not null,	# Number of edges leaving from this graph.
    edges longblob not null,	# Ids of spliceNodes that this edge connects to.
              #Indices
    PRIMARY KEY(tName)
);

#Path of one EST/mRNA through splieNodes
CREATE TABLE splicePath (
    tName varchar(255) not null,	# name of target sequence, often a chrom.
    tStart int not null,	# start in tName.
    tEnd int not null,	# end in tName.
    qName varchar(255) not null,	# Accession of mRNA or EST.
    strand char(2) not null,	# + or - strand.
    path varchar(255) not null,	# String representation of path.
    nodeCount int unsigned not null,	# Number of nodes in graph.
    nodes longblob not null,	# Array of dynamically allocated spliceNodes whose id corresponds to their index in array.
              #Indices
    PRIMARY KEY(tName)
);

#A collection of spliceNodes forming a graph
CREATE TABLE spliceGraph (
    tName varchar(255) not null,	# name of target sequence, often a chrom.
    tStart int not null,	# start in tName.
    tEnd int not null,	# end in tName.
    strand char(2) not null,	# + or - strand.
    classCount int unsigned not null,	# Number of different classes of nodes, two nodes are of same class if at same position.
    classStarts longblob not null,	# start in tName.
    classEnds longblob not null,	# end in tName.
    classTypes longblob not null,	# Type of splice site, see enum ggVertexType.
    nodeCount int unsigned not null,	# Total number of nodes in graph.
    nodeCapacity int unsigned not null,	# Maximum nodes allowed without expanding memory.
    pathCount int unsigned not null,	# Number of different paths generating graph.
    paths longblob not null,	# Array of dynamically allocated splicePaths which make up the graph.
              #Indices
    PRIMARY KEY(tName)
);
