/* altProbe.h was originally generated by the autoSql program, which also 
 * generated altProbe.c and altProbe.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ALTPROBE_H
#define ALTPROBE_H

#define ALTPROBE_NUM_COLS 15

struct altProbe
/* Little info about the probe sets for altGraphX. */
    {
    struct altProbe *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome. */
    int chromStart;	/* Chromosome Start. */
    int chromEnd;	/* Chromosome End. */
    int type;	/* Type of splicing event 2==cassette. */
    char strand[3];	/* Genomic Strand. */
    char *name;	/* Name from altSplice clustering. */
    int maxCounts;	/* Maximum possible counts, used for  memory management. */
    int contProbeCount;	/* Number of constitutive probe sets. */
    char **contProbeSets;	/* Names of constitutive probe sets. */
    int alt1ProbeCount;	/* Number of alternate1 probe sets. */
    char **alt1ProbeSets;	/* Names of alternate1 probe sets. */
    int alt2ProbeCount;	/* Number of alternate2 probe sets. */
    char **alt2ProbeSets;	/* Names of alternate2 probe sets. */
    int transcriptCount;	/* Number of altMerge transcripts involved. */
    char **transcriptNames;	/* Names of altMerge transcripts. */
    };

struct altProbe *altProbeLoad(char **row);
/* Load a altProbe from row fetched with select * from altProbe
 * from database.  Dispose of this with altProbeFree(). */

struct altProbe *altProbeLoadAll(char *fileName);
/* Load all altProbe from whitespace-separated file.
 * Dispose of this with altProbeFreeList(). */

struct altProbe *altProbeLoadAllByChar(char *fileName, char chopper);
/* Load all altProbe from chopper separated file.
 * Dispose of this with altProbeFreeList(). */

#define altProbeLoadAllByTab(a) altProbeLoadAllByChar(a, '\t');
/* Load all altProbe from tab separated file.
 * Dispose of this with altProbeFreeList(). */

struct altProbe *altProbeCommaIn(char **pS, struct altProbe *ret);
/* Create a altProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new altProbe */

void altProbeFree(struct altProbe **pEl);
/* Free a single dynamically allocated altProbe such as created
 * with altProbeLoad(). */

void altProbeFreeList(struct altProbe **pList);
/* Free a list of dynamically allocated altProbe's */

void altProbeOutput(struct altProbe *el, FILE *f, char sep, char lastSep);
/* Print out altProbe.  Separate fields with sep. Follow last field with lastSep. */

#define altProbeTabOut(el,f) altProbeOutput(el,f,'\t','\n');
/* Print out altProbe as a line in a tab-separated file. */

#define altProbeCommaOut(el,f) altProbeOutput(el,f,',',',');
/* Print out altProbe as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ALTPROBE_H */

