/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;

public class HashSSORealm
implements SSORealm {
    public static final String SSO_COOKIE_NAME = "SSO_ID";
    private HashMap _ssoId2Principal = new HashMap();
    private HashMap _ssoUsername2Id = new HashMap();
    private HashMap _ssoPrincipal2Credential = new HashMap();
    private transient Random _random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential getSingleSignOn(Request request, Response response) {
        String ssoID = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(SSO_COOKIE_NAME)) continue;
            ssoID = cookies[i].getValue();
            break;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("get ssoID=" + ssoID);
        }
        Principal principal = null;
        Credential credential = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            principal = (Principal)this._ssoId2Principal.get(ssoID);
            credential = (Credential)this._ssoPrincipal2Credential.get(principal);
        }
        if (Log.isDebugEnabled()) {
            Log.debug("SSO principal=" + principal);
        }
        if (principal != null && credential != null) {
            UserRealm realm = ((WebAppContext)request.getContext().getContextHandler()).getSecurityHandler().getUserRealm();
            if (realm.reauthenticate(principal)) {
                request.setUserPrincipal(principal);
                return credential;
            }
            HashMap hashMap2 = this._ssoId2Principal;
            synchronized (hashMap2) {
                this._ssoId2Principal.remove(ssoID);
                this._ssoPrincipal2Credential.remove(principal);
                this._ssoUsername2Id.remove(principal.getName());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSingleSignOn(Request request, Response response, Principal principal, Credential credential) {
        String ssoID = null;
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            while (this._ssoId2Principal.containsKey(ssoID = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            if (Log.isDebugEnabled()) {
                Log.debug("set ssoID=" + ssoID);
            }
            this._ssoId2Principal.put(ssoID, principal);
            this._ssoPrincipal2Credential.put(principal, credential);
            this._ssoUsername2Id.put(principal.getName(), ssoID);
        }
        Cookie cookie = new Cookie(SSO_COOKIE_NAME, ssoID);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSingleSignOn(String username) {
        HashMap hashMap = this._ssoId2Principal;
        synchronized (hashMap) {
            Object ssoID = this._ssoUsername2Id.remove(username);
            Object principal = this._ssoId2Principal.remove(ssoID);
            this._ssoPrincipal2Credential.remove(principal);
        }
    }
}

