/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.common.collect.Lists;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.browser.BrowserSessionManager;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionRunner
implements Callable<Collection<ResponseStream>> {
    private static final Logger logger = LoggerFactory.getLogger(BrowserActionRunner.class);
    private final String id;
    private final JsTestDriverClient client;
    private final List<BrowserAction> actions;
    private final StopWatch stopWatch;
    private final JstdTestCase testCase;
    private final BrowserSessionManager sessionManager;

    public BrowserActionRunner(String id, JsTestDriverClient client, List<BrowserAction> actions, StopWatch stopWatch, JstdTestCase testCase, BrowserSessionManager sessionManager) {
        this.id = id;
        this.client = client;
        this.actions = actions;
        this.stopWatch = stopWatch;
        this.testCase = testCase;
        this.sessionManager = sessionManager;
    }

    @Override
    public Collection<ResponseStream> call() {
        ArrayList<ResponseStream> responses = Lists.newArrayList();
        String sessionId = this.sessionManager.startSession(this.id);
        logger.debug("start session on {} with id {}", (Object)this.id, (Object)sessionId);
        for (BrowserAction action : this.actions) {
            this.stopWatch.start("run %s", action);
            logger.debug("Running BrowserAction {}", action);
            responses.add(action.run(this.id, this.client, null, this.testCase));
            this.stopWatch.stop("run %s", action);
        }
        logger.debug("stopping session on {} with id {}", (Object)this.id, (Object)sessionId);
        this.sessionManager.stopSession(sessionId, this.id);
        return responses;
    }
}

