/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.JsException;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureParser {
    private static final Logger logger = LoggerFactory.getLogger(FailureParser.class);
    private final Gson gson = new Gson();
    private final HandlerPathPrefix pathPrefix;

    @Inject
    public FailureParser(@Named(value="serverHandlerPrefix") HandlerPathPrefix pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public List<Failure> parse(String failure) {
        ArrayList<Failure> failures;
        String message = "";
        String stackStripPrefix = this.pathPrefix.prefixPath("/static/");
        try {
            Collection exceptions = (Collection)this.gson.fromJson(failure, new TypeToken<Collection<JsException>>(){}.getType());
            failures = Lists.newArrayListWithExpectedSize(exceptions.size());
            for (JsException exception : exceptions) {
                message = exception.getName() != null && !exception.getName().isEmpty() ? String.format("%s: %s", exception.getName(), exception.getMessage()) : exception.getMessage();
                String errorStack = exception.getStack();
                String[] lines = errorStack.split("\n");
                LinkedList<String> stack = Lists.newLinkedList();
                for (String l : lines) {
                    if (l.contains(stackStripPrefix)) continue;
                    stack.add(l);
                }
                failures.add(new Failure(message, stack));
            }
        }
        catch (Exception e) {
            logger.error("Error converting JsExceptions.", e);
            failures = Lists.newArrayList(new Failure(failure, Lists.<String>newArrayList()));
        }
        return failures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Failure {
        private final List<String> stack;
        private final String message;

        public Failure(String message, List<String> stack) {
            this.message = message;
            this.stack = stack;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getStack() {
            return this.stack;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.stack == null ? 0 : ((Object)this.stack).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Failure other = (Failure)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            return !(this.stack == null ? other.stack != null : !((Object)this.stack).equals(other.stack));
        }

        public String toString() {
            return "Failure [stack=" + this.stack + ", message=" + this.message + "]";
        }
    }
}

