/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import java.util.List;

public final class AsyncException
extends RuntimeException {
    private static final long serialVersionUID = 1573135643731810717L;
    private final List<Throwable> concurrentExceptions;

    public AsyncException(String message, List<Throwable> concurrentExceptions) {
        super(message);
        this.concurrentExceptions = concurrentExceptions;
    }

    public List<Throwable> getConcurrentExceptions() {
        return this.concurrentExceptions;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ' ' + this.buildMessage();
    }

    @Override
    public String toString() {
        return this.buildMessage();
    }

    private String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsyncException");
        sb.append("{concurrentExceptions=").append("[\n");
        for (Throwable concurrentException : this.concurrentExceptions) {
            sb.append(concurrentException.toString()).append('\n');
        }
        sb.append("]}");
        return sb.toString();
    }
}

