/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class ReleaseFilesCopy
extends Task {
    private File cluster;

    public void setCluster(File cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        for (Map.Entry entry : this.getProject().getProperties().entrySet()) {
            String k = (String)entry.getKey();
            if (!k.startsWith("release.") || k.matches("release\\.(files|files\\.extra|dir)")) continue;
            File to = FileUtils.getFileUtils().resolveFile(this.cluster, (String)entry.getValue());
            String fromString = k.substring(8);
            int bangSlash = fromString.indexOf("!/");
            if (bangSlash == -1) {
                File from = this.getProject().resolveFile(fromString);
                if (from.isFile()) {
                    this.log("Copying " + from + " to " + to);
                    to.getParentFile().mkdirs();
                    try {
                        FileUtils.getFileUtils().copyFile(from, to);
                        continue;
                    }
                    catch (IOException x) {
                        throw new BuildException("Could not copy " + from + ": " + x, (Throwable)x, this.getLocation());
                    }
                }
                throw new BuildException("Could not find file " + from + " to copy", this.getLocation());
            }
            File zip = this.getProject().resolveFile(fromString.substring(0, bangSlash));
            if (zip.isFile()) {
                try {
                    ZipFile zf = new ZipFile(zip);
                    Throwable throwable = null;
                    try {
                        String path = fromString.substring(bangSlash + 2);
                        this.log("Copying " + path + " in " + zip + " to " + to);
                        ZipEntry ze = zf.getEntry(path);
                        if (ze == null) {
                            throw new BuildException("No such entry " + path + " in " + zip, this.getLocation());
                        }
                        InputStream is = zf.getInputStream(ze);
                        to.getParentFile().mkdirs();
                        FileOutputStream os = new FileOutputStream(to);
                        try {
                            int read;
                            byte[] buf = new byte[4096];
                            while ((read = is.read(buf)) != -1) {
                                ((OutputStream)os).write(buf, 0, read);
                            }
                            continue;
                        }
                        finally {
                            ((OutputStream)os).close();
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zf == null) continue;
                        if (throwable != null) {
                            try {
                                zf.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zf.close();
                        continue;
                    }
                }
                catch (IOException x) {
                    throw new BuildException("Could not extract " + zip + ": " + x, (Throwable)x, this.getLocation());
                }
            }
            throw new BuildException("Could not find file " + zip + " to extract", this.getLocation());
        }
    }
}

