/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JRadioButton;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;

public class PluginsOperator
extends NbDialogOperator {
    private static final String TITLE = Bundle.getString("org.netbeans.modules.autoupdate.ui.actions.Bundle", "PluginManager_Panel_Name");
    private static final String TOOLS_ITEM = Bundle.getStringTrimmed("org.netbeans.core.ui.resources.Bundle", "Menu/Tools");
    private static final String PLUGINS_ITEM = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.actions.Bundle", "PluginManagerAction_Name");
    private static final String INSTALLED_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Installed_Title");
    private static final String AVAILABLE_PLUGINS_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Available_Title");
    private JTabbedPaneOperator _tabbedPane;

    public PluginsOperator() {
        super(TITLE);
        this.tabbedPane();
        this.waitTabEnabled(INSTALLED_LABEL);
        if (!this.tabbedPane().isEnabledAt(this.tabbedPane().waitPage(AVAILABLE_PLUGINS_LABEL))) {
            this.selectInstalled();
            this.reloadCatalog();
            this.selectAvailablePlugins();
        }
    }

    public static PluginsOperator invoke() {
        new ActionNoBlock(TOOLS_ITEM + "|" + PLUGINS_ITEM, null).perform();
        long l = JemmyProperties.getCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout");
        JemmyProperties.setCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout", (long)120000L);
        try {
            PluginsOperator pluginsOperator = new PluginsOperator();
            return pluginsOperator;
        }
        finally {
            JemmyProperties.setCurrentTimeout((String)"DialogWaiter.WaitDialogTimeout", (long)l);
        }
    }

    public JTabbedPaneOperator tabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JTabbedPaneOperator((ContainerOperator)this);
            this._tabbedPane.getTimeouts().setTimeout("ComponentOperator.WaitComponentEnabledTimeout", 120000L);
            this._tabbedPane.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 120000L);
        }
        this._tabbedPane.wtComponentEnabled();
        return this._tabbedPane;
    }

    public JTableOperator table() {
        return new JTableOperator((ContainerOperator)this);
    }

    public JButtonOperator btUpdate() {
        this.selectUpdates();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_UPDATE"));
    }

    public JButtonOperator btInstall() {
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_AVAILABLE"));
    }

    public JButtonOperator btReloadCatalog() {
        return new JButtonOperator((ContainerOperator)this, "Check for");
    }

    public JButtonOperator btAddPlugins() {
        this.selectDownloaded();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bAddLocallyDownloads_Name"));
    }

    public JButtonOperator btDeactivate() {
        this.selectInstalled();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_DeactivateAction"));
    }

    public JButtonOperator btUninstall() {
        this.selectInstalled();
        return new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab_bTabAction_Name_INSTALLED"));
    }

    public JCheckBoxOperator cbShowDetails() {
        return new JCheckBoxOperator((ContainerOperator)this.selectInstalled(), Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "UnitTab.detailView.text"));
    }

    public JTextFieldOperator txtSearch() {
        return new JTextFieldOperator((ContainerOperator)this);
    }

    public WizardOperator installer() {
        String string = Bundle.getString("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "UninstallUnitWizard_Title");
        return new WizardOperator(string);
    }

    public JTabbedPaneOperator selectUpdates() {
        String string = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Update_Title");
        return this.selectTab(string);
    }

    public JTabbedPaneOperator selectAvailablePlugins() {
        return this.selectTab(AVAILABLE_PLUGINS_LABEL);
    }

    public JTabbedPaneOperator selectDownloaded() {
        String string = Bundle.getString("org.netbeans.modules.autoupdate.ui.Bundle", "PluginManagerUI_UnitTab_Local_Title");
        return this.selectTab(string);
    }

    public JTabbedPaneOperator selectInstalled() {
        return this.selectTab(INSTALLED_LABEL);
    }

    public JTabbedPaneOperator selectSettings() {
        String string = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.Bundle", "SettingsTab_displayName");
        return this.selectTab(string);
    }

    public JTabbedPaneOperator selectTab(String string) {
        this.waitTabEnabled(string);
        this.tabbedPane().selectPage(string);
        return this.tabbedPane();
    }

    public void waitTabEnabled(final String string) {
        final int n = this.tabbedPane().waitPage(string);
        this.tabbedPane().waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return PluginsOperator.this.tabbedPane().isEnabledAt(n);
            }

            public String getDescription() {
                return "page " + string + " enabled";
            }
        });
    }

    public void update() {
        this.btUpdate().pushNoBlock();
    }

    public void install() {
        this.btInstall().pushNoBlock();
    }

    public void uninstall() {
        this.btUninstall().pushNoBlock();
    }

    public void deactivate() {
        this.btDeactivate().pushNoBlock();
    }

    public void search(String string) {
        final int n = this.table().getRowCount();
        this.txtSearch().setText(string);
        this.table().waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return PluginsOperator.this.table().getRowCount() != n;
            }

            public String getDescription() {
                return "table changed row count";
            }
        });
    }

    public void reloadCatalog() {
        this.btReloadCatalog().push();
        this.tabbedPane();
    }

    public void addPlugins() {
        this.btAddPlugins().pushNoBlock();
    }

    public void selectPlugin(String string) {
        this.selectPlugins(new String[]{string});
    }

    public void selectPlugins(String[] stringArray) {
        JTableOperator jTableOperator = this.table();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = jTableOperator.findCellRow(string, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true), 1, 0);
            if (n == -1) {
                throw new JemmyException("Plugin " + string + " not found.");
            }
            jTableOperator.selectCell(n, 1);
            jTableOperator.clickOnCell(n, 0);
        }
    }

    public void addPlugin(String string) {
        this.addPlugins();
        JFileChooserOperator jFileChooserOperator = new JFileChooserOperator();
        jFileChooserOperator.setSelectedFile(new File(string));
        jFileChooserOperator.approve();
        this.tabbedPane();
    }

    public void install(String string) {
        this.install(new String[]{string});
    }

    public void install(String[] stringArray) {
        this.selectAvailablePlugins();
        this.selectPlugins(stringArray);
        this.install();
        this.finishInstall();
    }

    public void finishInstall() {
        WizardOperator wizardOperator = this.installer();
        wizardOperator.next();
        String string = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "LicenseApprovalPanel.cbAccept.text");
        JCheckBoxOperator jCheckBoxOperator = new JCheckBoxOperator((ContainerOperator)wizardOperator, string);
        if (!jCheckBoxOperator.isEnabled()) {
            jCheckBoxOperator.waitComponentShowing(false);
            jCheckBoxOperator = new JCheckBoxOperator((ContainerOperator)wizardOperator, string);
        }
        jCheckBoxOperator.push();
        String string2 = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallUnitWizardModel_Buttons_Install");
        new JButtonOperator((ContainerOperator)wizardOperator, string2).push();
        String string3 = Bundle.getString("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallStep_InstallDone_Text");
        JemmyProperties.setCurrentTimeout((String)"ComponentOperator.WaitComponentTimeout", (long)120000L);
        new JTextAreaOperator((ContainerOperator)wizardOperator, string3);
        String string4 = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.ui.wizards.Bundle", "InstallUnitWizardModel_Buttons_RestartNow");
        JRadioButton jRadioButton = JRadioButtonOperator.findJRadioButton((Container)((Container)wizardOperator.getSource()), (String)string4, (boolean)true, (boolean)true);
        if (jRadioButton == null) {
            String string5 = Bundle.getString("org.netbeans.core.startup.Bundle", "MSG_finish_enable_modules");
            MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000L);
            MainWindowOperator.getDefault().waitStatusText(string5);
        }
        wizardOperator.finish();
    }
}

