/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.cache.DefaultResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHCacheModule;

public class EHResourceBundleDataCache
implements ResourceBundleDataCache {
    private Cache dataCache;

    public EHResourceBundleDataCache(Cache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceBundleDataCacheEntry get(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            Element element = this.dataCache.get((Object)key);
            if (element != null) {
                if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                    EHCacheModule.CACHE_MONITOR.debug((Object)("Bund Cache Hit  " + key));
                }
                return (ResourceBundleDataCacheEntry)element.getObjectValue();
            }
            if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                EHCacheModule.CACHE_MONITOR.debug((Object)("Bund Cache Miss " + key));
            }
            return null;
        }
        catch (CacheException e) {
            return null;
        }
    }

    public ResourceBundleData put(ResourceManager caller, ResourceBundleData data) throws ResourceLoadingException {
        if (caller == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        ResourceBundleData cdata = CachingResourceBundleData.createCached(data);
        ResourceKey keyObject = data.getBundleKey();
        DefaultResourceBundleDataCacheEntry valueObject = new DefaultResourceBundleDataCacheEntry(cdata, caller);
        Element element = new Element((Object)keyObject, (Object)valueObject);
        if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
            EHCacheModule.CACHE_MONITOR.debug((Object)("Storing Bundle " + keyObject));
        }
        this.dataCache.put(element);
        return cdata;
    }

    public void remove(ResourceBundleData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.dataCache.remove((Object)data.getBundleKey());
    }

    public void clear() {
        try {
            this.dataCache.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        try {
            this.dataCache.getCacheManager().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

