/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.List;
import java.util.Optional;
import org.gradle.api.JavaVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.artifacts.dsl.dependencies.AbstractJVMVersionTooNewFailureDescriber;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;

public abstract class TargetJVMVersionOnPluginTooNewFailureDescriber
extends AbstractJVMVersionTooNewFailureDescriber {
    private static final String JVM_VERSION_TOO_HIGH_TEMPLATE = "Dependency requires at least JVM runtime version %s. This build uses a Java %s JVM.";
    private final JavaVersion currentJVMVersion = JavaVersion.current();

    @Override
    protected JavaVersion getJVMVersion(NoCompatibleVariantsFailure failure) {
        return this.currentJVMVersion;
    }

    @Override
    public boolean canDescribeFailure(NoCompatibleVariantsFailure failure) {
        boolean isPluginRequest = failure.getRequestedAttributes().contains(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE);
        return isPluginRequest && this.isDueToJVMVersionTooNew(failure);
    }

    @Override
    public AbstractResolutionFailureException describeFailure(NoCompatibleVariantsFailure failure, Optional<AttributesSchemaInternal> schema) {
        JavaVersion minJVMVersionSupported = this.findMinJVMSupported((List<ResolutionCandidateAssessor.AssessedCandidate>)failure.getCandidates()).orElseThrow(IllegalStateException::new);
        String message = this.buildNeedsNewerJDKFailureMsg(minJVMVersionSupported);
        List<String> resolutions = this.buildResolutions(this.suggestUpdateJVM(minJVMVersionSupported));
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    private String buildNeedsNewerJDKFailureMsg(JavaVersion minRequiredJVMVersion) {
        return String.format(JVM_VERSION_TOO_HIGH_TEMPLATE, minRequiredJVMVersion.getMajorVersion(), this.currentJVMVersion.getMajorVersion());
    }

    private String suggestUpdateJVM(JavaVersion minRequiredJVMVersion) {
        return "Run this build using a Java " + minRequiredJVMVersion.getMajorVersion() + " or newer JVM.";
    }
}

