/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;

public class SummarizingChangeContainer
implements ChangeContainer {
    private final List<ChangeContainer> sources;

    public SummarizingChangeContainer(ChangeContainer ... sources) {
        this.sources = ImmutableList.copyOf((Object[])sources);
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        ChangeDetectingVisitor changeDetectingVisitor = new ChangeDetectingVisitor(visitor);
        for (ChangeContainer source : this.sources) {
            if (!source.accept(changeDetectingVisitor)) {
                return false;
            }
            if (!changeDetectingVisitor.isChangesDetected()) continue;
            return true;
        }
        return true;
    }

    private static class ChangeDetectingVisitor
    implements ChangeVisitor {
        private final ChangeVisitor delegate;
        private boolean changesDetected;

        public ChangeDetectingVisitor(ChangeVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean visitChange(Change change) {
            this.changesDetected = true;
            return this.delegate.visitChange(change);
        }

        public boolean isChangesDetected() {
            return this.changesDetected;
        }
    }
}

