/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionalTypeParameterSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnsupportedDefaultValueInFunctionType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedDefaultValueInFunctionTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirFunctionalTypeParameterSyntaxChecker;", "()V", "checkPsiOrLightTree", "", "element", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "report", "defaultValueSource", "checkers"})
public final class FirUnsupportedDefaultValueInFunctionTypeParameterChecker
extends FirFunctionalTypeParameterSyntaxChecker {
    @NotNull
    public static final FirUnsupportedDefaultValueInFunctionTypeParameterChecker INSTANCE = new FirUnsupportedDefaultValueInFunctionTypeParameterChecker();

    private FirUnsupportedDefaultValueInFunctionTypeParameterChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFunctionTypeParameter element, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = FirHelpersKt.getDefaultValueForParameter(source);
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement defaultValue = ktSourceElement;
        this.report(defaultValue, reporter, context2);
    }

    private final void report(KtSourceElement defaultValueSource, DiagnosticReporter reporter, CheckerContext context2) {
        ConeUnsupportedDefaultValueInFunctionType diagnostic = new ConeUnsupportedDefaultValueInFunctionType(defaultValueSource);
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)diagnostic.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)diagnostic.getReason(), (DiagnosticContext)context2, null, 16, null);
    }
}

