/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import javax.inject.Inject;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.BuildTreeLocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentCache;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Describables;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.util.Path;

public class DefaultBuildTreeLocalComponentProvider
implements BuildTreeLocalComponentProvider,
HoldsProjectState {
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentCache localComponentCache;
    private final LocalComponentProvider localComponentProvider;
    private final InMemoryLoadingCache<ProjectComponentIdentifier, LocalComponentGraphResolveState> originalComponents;
    private final InMemoryLoadingCache<ProjectComponentIdentifier, LocalComponentGraphResolveState> foreignIdentifiedComponents;

    @Inject
    public DefaultBuildTreeLocalComponentProvider(ProjectStateRegistry projectStateRegistry, InMemoryCacheFactory cacheFactory, LocalComponentCache localComponentCache, LocalComponentProvider localComponentProvider) {
        this.projectStateRegistry = projectStateRegistry;
        this.localComponentCache = localComponentCache;
        this.localComponentProvider = localComponentProvider;
        this.originalComponents = cacheFactory.createCalculatedValueCache(Describables.of((Object)"local metadata"), this::createLocalComponent);
        this.foreignIdentifiedComponents = cacheFactory.createCalculatedValueCache(Describables.of((Object)"foreign metadata"), this::copyComponentWithForeignId);
    }

    public LocalComponentGraphResolveState getComponent(ProjectComponentIdentifier projectIdentifier, Path currentBuildPath) {
        boolean isLocalProject = projectIdentifier.getBuild().getBuildPath().equals(currentBuildPath.getPath());
        if (isLocalProject) {
            return (LocalComponentGraphResolveState)this.originalComponents.get((Object)projectIdentifier);
        }
        return (LocalComponentGraphResolveState)this.foreignIdentifiedComponents.get((Object)projectIdentifier);
    }

    private LocalComponentGraphResolveState createLocalComponent(ProjectComponentIdentifier projectIdentifier) {
        return this.localComponentCache.computeIfAbsent(((DefaultProjectComponentIdentifier)projectIdentifier).getIdentityPath(), path -> this.localComponentProvider.getComponent(this.projectStateRegistry.stateFor(path)));
    }

    private LocalComponentGraphResolveState copyComponentWithForeignId(ProjectComponentIdentifier projectIdentifier) {
        ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
        CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)projectState.getOwner();
        if (buildState instanceof IncludedBuildState) {
            buildState.ensureProjectsConfigured();
        }
        LocalComponentGraphResolveState originalComponent = (LocalComponentGraphResolveState)this.originalComponents.get((Object)projectIdentifier);
        ProjectComponentIdentifier foreignIdentifier = buildState.idToReferenceProjectFromAnotherBuild(projectIdentifier);
        return originalComponent.copyWithComponentId((ComponentIdentifier)foreignIdentifier);
    }

    public void discardAll() {
        this.originalComponents.invalidate();
        this.foreignIdentifiedComponents.invalidate();
    }
}

