/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.ShieldProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.ShieldProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ShieldProfToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<ShieldProf> {
    private static final Class<ShieldProf> SHIELDPROF_CLASS = ShieldProf.class;
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "SHIELDPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String shieldProf;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            shieldProf = value;
            StringTokenizer tok = new StringTokenizer(shieldProf, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString((String)token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint((String)errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                shieldProf = value.substring(0, preStart);
                isPre = true;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites has been removed. Please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', shieldProf);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(shieldProf, "|");
        ArrayList<Object> shieldProfs = new ArrayList<Object>();
        ArrayList<CDOMGroupRef> equipTypes = new ArrayList<CDOMGroupRef>();
        while (tok.hasMoreTokens()) {
            String aProf = tok.nextToken();
            if ("%LIST".equals(aProf)) {
                ShieldProfToken cra;
                foundOther = true;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor cca = new ConditionalSelectionActor((ChooseSelectionActor)this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)cra);
                continue;
            }
            if ("ALL".equalsIgnoreCase(aProf)) {
                foundAny = true;
                shieldProfs.add(context.getReferenceContext().getCDOMAllReference(SHIELDPROF_CLASS));
                continue;
            }
            if (aProf.startsWith("SHIELDTYPE.") || aProf.startsWith("SHIELDTYPE=")) {
                foundOther = true;
                CDOMGroupRef ref = TokenUtilities.getTypeReference((LoadContext)context, EQUIPMENT_CLASS, (String)("SHIELD." + aProf.substring(11)));
                if (ref == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                equipTypes.add(ref);
                continue;
            }
            foundOther = true;
            shieldProfs.add(context.getReferenceContext().getCDOMReference(SHIELDPROF_CLASS, aProf));
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!shieldProfs.isEmpty() || !equipTypes.isEmpty()) {
            ShieldProfProvider pp = new ShieldProfProvider(shieldProfs, equipTypes);
            if (prereq != null) {
                pp.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(obj, ListKey.AUTO_SHIELDPROF, (Object)pp);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.AUTO_SHIELDPROF);
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Collection added = changes.getAdded();
        TreeSet<String> set = new TreeSet<String>();
        Collection listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (listAdded != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    set.add(cra.getLstFormat());
                    foundOther = true;
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (added != null) {
            for (ShieldProfProvider spp : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(spp.getLstFormat());
                if (spp.hasPrerequisites()) {
                    sb.append('|');
                    sb.append(this.getPrerequisiteString(context, spp.getPrerequisiteList()));
                }
                String ab = sb.toString();
                boolean isUnconditionalAll = "ALL".equals(ab);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                set.add(ab);
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + set);
            return null;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, ShieldProf sp, PlayerCharacter pc) {
        pc.addShieldProf((Object)obj, sp);
    }

    public void removeChoice(ChooseDriver obj, ShieldProf sp, PlayerCharacter pc) {
        pc.removeShieldProf((Object)obj, sp);
    }

    public Class<ShieldProf> getChoiceClass() {
        return SHIELDPROF_CLASS;
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

