/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ChargesToken
extends AbstractNonEmptyToken<EquipmentModifier>
implements CDOMPrimaryToken<EquipmentModifier> {
    public String getTokenName() {
        return "CHARGES";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, EquipmentModifier mod, String value) {
        int maxCharges;
        int minCharges;
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " has no | : must be of format <min charges>|<max charges>: " + value, context);
        }
        if (value.lastIndexOf("|") != pipeLoc) {
            return new ParseResult.Fail(this.getTokenName() + " has two | : must be of format <min charges>|<max charges>: " + value, context);
        }
        String minChargeString = value.substring(0, pipeLoc);
        try {
            minCharges = Integer.parseInt(minChargeString);
            if (minCharges < 0) {
                return new ParseResult.Fail(this.getTokenName() + " min charges must be >= zero: " + value, context);
            }
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " min charges is not an integer: " + value, context);
        }
        String maxChargeString = value.substring(pipeLoc + 1);
        try {
            maxCharges = Integer.parseInt(maxChargeString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " max charges is not an integer: " + value, context);
        }
        if (minCharges > maxCharges) {
            return new ParseResult.Fail(this.getTokenName() + " max charges must be >= min charges: " + value, context);
        }
        context.getObjectContext().put((CDOMObject)mod, IntegerKey.MIN_CHARGES, Integer.valueOf(minCharges));
        context.getObjectContext().put((CDOMObject)mod, IntegerKey.MAX_CHARGES, Integer.valueOf(maxCharges));
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, EquipmentModifier mod) {
        Integer max = context.getObjectContext().getInteger((CDOMObject)mod, IntegerKey.MAX_CHARGES);
        Integer min = context.getObjectContext().getInteger((CDOMObject)mod, IntegerKey.MIN_CHARGES);
        if (max == null && min == null) {
            return null;
        }
        if (max == null || min == null) {
            context.addWriteMessage("EquipmentModifier requires both MAX_CHARGES and MIN_CHARGES for " + this.getTokenName() + " if one of the two is present");
            return null;
        }
        int minInt = min;
        if (minInt < 0) {
            context.addWriteMessage("EquipmentModifier requires MIN_CHARGES be > 0");
            return null;
        }
        if (max < minInt) {
            context.addWriteMessage("EquipmentModifier requires MAX_CHARGES be greater than MIN_CHARGES for " + this.getTokenName());
            return null;
        }
        return new String[]{min + "|" + max};
    }

    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

