/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<AbilityCategory>
implements CDOMPrimaryToken<AbilityCategory> {
    public String getTokenName() {
        return "VISIBLE";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, AbilityCategory ac, String value) {
        Visibility vis;
        if (value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else if (value.equals("QUALIFY")) {
            vis = Visibility.QUALIFY;
        } else if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else {
            return new ParseResult.Fail("Unable to understand " + this.getTokenName() + " tag: " + value, context);
        }
        ac.setVisible(vis);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, AbilityCategory ac) {
        String visString;
        Visibility vis = ac.getVisibility();
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.QUALIFY)) {
            visString = "QUALIFY";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + vis + " is not a valid Visibility for " + ac.getClass().getSimpleName() + " " + ac.getKeyName());
            return null;
        }
        return new String[]{visString};
    }

    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }
}

