/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.ArmorProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.ArmorProf;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ArmorProfToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<ArmorProf> {
    private static final Class<ArmorProf> ARMORPROF_CLASS = ArmorProf.class;
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "ARMORPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String armorProf;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            armorProf = value;
            StringTokenizer tok = new StringTokenizer(armorProf, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString((String)token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint((String)errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                armorProf = value.substring(0, preStart);
                isPre = true;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites has been removed. Please use | based standard", context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty('|', armorProf);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(armorProf, "|");
        ArrayList<Object> armorProfs = new ArrayList<Object>();
        ArrayList<CDOMGroupRef> equipTypes = new ArrayList<CDOMGroupRef>();
        while (tok.hasMoreTokens()) {
            String aProf = tok.nextToken();
            if ("%LIST".equals(aProf)) {
                ArmorProfToken cra;
                foundOther = true;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor cca = new ConditionalSelectionActor((ChooseSelectionActor)this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)cra);
                continue;
            }
            if ("ALL".equalsIgnoreCase(aProf)) {
                foundAny = true;
                armorProfs.add(context.getReferenceContext().getCDOMAllReference(ARMORPROF_CLASS));
                continue;
            }
            if (aProf.startsWith("ARMORTYPE.") || aProf.startsWith("ARMORTYPE=")) {
                foundOther = true;
                CDOMGroupRef ref = TokenUtilities.getTypeReference((LoadContext)context, EQUIPMENT_CLASS, (String)("ARMOR." + aProf.substring(10)));
                if (ref == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                equipTypes.add(ref);
                continue;
            }
            foundOther = true;
            armorProfs.add(context.getReferenceContext().getCDOMReference(ARMORPROF_CLASS, aProf));
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!armorProfs.isEmpty() || !equipTypes.isEmpty()) {
            ArmorProfProvider pp = new ArmorProfProvider(armorProfs, equipTypes);
            if (prereq != null) {
                pp.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(obj, ListKey.AUTO_ARMORPROF, (Object)pp);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.AUTO_ARMORPROF);
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Collection added = changes.getAdded();
        TreeSet<String> set = new TreeSet<String>();
        Collection listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (listAdded != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    set.add(cra.getLstFormat());
                    foundOther = true;
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (added != null) {
            for (ArmorProfProvider spp : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(spp.getLstFormat());
                if (spp.hasPrerequisites()) {
                    sb.append('|');
                    sb.append(this.getPrerequisiteString(context, spp.getPrerequisiteList()));
                }
                String ab = sb.toString();
                boolean isUnconditionalAll = "ALL".equals(ab);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                set.add(ab);
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + set);
            return null;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, ArmorProf ap, PlayerCharacter pc) {
        pc.addArmorProf((Object)obj, ap);
    }

    public void removeChoice(ChooseDriver obj, ArmorProf ap, PlayerCharacter pc) {
        pc.removeArmorProf((Object)obj, ap);
    }

    public Class<ArmorProf> getChoiceClass() {
        return ARMORPROF_CLASS;
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

