/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.pobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Converter;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.util.Logging;

public class AbilityToken<T>
implements PrimitiveToken<T> {
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;
    private CDOMSingleRef<Ability> ref;
    private Category<Ability> category;
    private Class<T> refClass;

    @Override
    public boolean initialize(LoadContext context, Class<T> cl, String value, String args) {
        Category cat;
        if (args == null) {
            Logging.errorPrint("Syntax for ABILITY primitive is ABILITY=category[key]");
            return false;
        }
        this.category = cat = (Category)context.getReferenceContext().silentlyGetConstructedCDOMObject(ABILITY_CATEGORY_CLASS, value);
        this.ref = context.getReferenceContext().getCDOMReference(Ability.class, cat, args);
        this.refClass = cl;
        return true;
    }

    @Override
    public String getTokenName() {
        return "ABILITY";
    }

    @Override
    public Class<? super T> getReferenceClass() {
        if (this.refClass == null) {
            return Object.class;
        }
        return this.refClass;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return "ABILITY=" + this.category.getLSTformat() + "[" + this.ref.getLSTformat(useAny) + "]";
    }

    private <R> List<R> getList(PlayerCharacter pc, Ability a) {
        ArrayList availableList = new ArrayList();
        List<CNAbility> theFeats = pc.getMatchingCNAbilities(a);
        for (CNAbility ability : theFeats) {
            List<?> list = pc.getDetailedAssociations(ability);
            if (list == null) continue;
            availableList.addAll(list);
        }
        return availableList;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbilityToken) {
            AbilityToken other = (AbilityToken)obj;
            if (this.ref == null) {
                return other.ref == null && this.refClass == null && other.refClass == null;
            }
            return this.refClass.equals(other.refClass) && this.ref.equals(other.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref == null ? -57 : this.ref.hashCode();
    }

    @Override
    public <R> Collection<R> getCollection(PlayerCharacter pc, Converter<T, R> c) {
        List<R> currentItems = this.getList(pc, this.ref.resolvesTo());
        if (currentItems == null) {
            return Collections.emptySet();
        }
        return new HashSet<R>(currentItems);
    }
}

