/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.EqModNameOpt;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class NameoptToken
extends AbstractNonEmptyToken<EquipmentModifier>
implements CDOMPrimaryToken<EquipmentModifier> {
    @Override
    public String getTokenName() {
        return "NAMEOPT";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, EquipmentModifier mod, String value) {
        String optString = value;
        if (optString.startsWith("TEXT")) {
            if (optString.length() < 6 || optString.charAt(4) != '=') {
                return new ParseResult.Fail(this.getTokenName() + " has invalid TEXT argument: " + value, context);
            }
            optString = "TEXT";
            context.getObjectContext().put((CDOMObject)mod, StringKey.NAME_TEXT, value.substring(5));
        }
        try {
            context.getObjectContext().put((CDOMObject)mod, ObjectKey.NAME_OPT, EqModNameOpt.valueOfIgnoreCase(optString));
            return ParseResult.SUCCESS;
        }
        catch (IllegalArgumentException iae) {
            return new ParseResult.Fail("Invalid Naming Option provided in " + this.getTokenName() + ": " + value, context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, EquipmentModifier mod) {
        String retString;
        EqModNameOpt opt = context.getObjectContext().getObject(mod, ObjectKey.NAME_OPT);
        String text = context.getObjectContext().getString(mod, StringKey.NAME_TEXT);
        if (opt == null) {
            if (text == null) {
                return null;
            }
            context.addWriteMessage("Cannot have both NAME_TEXT without NAME_OPT in EquipmentModifier");
            return null;
        }
        if (opt.equals((Object)EqModNameOpt.TEXT)) {
            if (text == null) {
                context.addWriteMessage("Must have NAME_TEXT with NAME_OPT TEXT in EquipmentModifier");
                return null;
            }
            retString = "TEXT=" + text;
        } else {
            retString = opt.toString();
        }
        return new String[]{retString};
    }

    @Override
    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

