/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.EquipmentModifier;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BonusToken
implements CDOMPrimaryToken<EquipmentModifier> {
    @Override
    public String getTokenName() {
        return "BONUS";
    }

    @Override
    public ParseResult parseToken(LoadContext context, EquipmentModifier mod, String value) {
        BonusObj bon = Bonus.newBonus(context, value);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList(mod, ListKey.BONUS, bon);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, EquipmentModifier mod) {
        Changes<BonusObj> changes = context.getObjectContext().getListChanges(mod, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<BonusObj> added = changes.getAdded();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            String bonusString = bonus.getLSTformat();
            bonusSet.add(bonusString);
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    @Override
    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

