/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.BasicChooseInformation;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.choiceset.SimpleChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class StringToken
implements CDOMSecondaryToken<CDOMObject>,
Chooser<String> {
    @Override
    public String getTokenName() {
        return "STRING";
    }

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (value == null || value.length() == 0) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " must have arguments", context);
        }
        if (value.indexOf(44) != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not contain , : " + value, context);
        }
        if (value.indexOf(91) != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not contain [] : " + value, context);
        }
        if (value.charAt(0) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not start with | : " + value, context);
        }
        if (value.charAt(value.length() - 1) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not end with | : " + value, context);
        }
        if (value.indexOf("||") != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments uses double separator || : " + value, context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        HashSet<String> set = new HashSet<String>();
        while (tok.hasMoreTokens()) {
            String tokString = tok.nextToken();
            set.add(tokString);
        }
        SimpleChoiceSet scs = new SimpleChoiceSet(set, "|");
        BasicChooseInformation tc = new BasicChooseInformation(this.getTokenName(), scs);
        tc.setTitle("Choose an Item");
        tc.setChoiceActor(this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, tc);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation<?> tc = context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (tc == null) {
            return null;
        }
        if (!tc.getName().equals(this.getTokenName())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tc.getLSTformat());
        return new String[]{sb.toString()};
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public String decodeChoice(LoadContext context, String s) {
        return s;
    }

    @Override
    public String encodeChoice(String choice) {
        return choice;
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.removeAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.removeChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, String choice) {
        pc.addAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<String> chooseSelectionActor : actors) {
                this.applyChoice(owner, choice, pc, chooseSelectionActor);
            }
        }
    }

    @Override
    public boolean allow(String choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public void applyChoice(ChooseDriver owner, String choice, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, choice);
    }

    private void applyChoice(ChooseDriver owner, String st, PlayerCharacter pc, ChooseSelectionActor<String> ca) {
        ca.applyChoice(owner, st, pc);
    }

    @Override
    public List<String> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList(owner, this.getListKey());
    }

    protected AssociationListKey<String> getListKey() {
        return AssociationListKey.getKeyFor(String.class, "CHOOSE*STRING");
    }
}

