/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.choiceset.SpellCasterChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.BonusAddition;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpellCasterToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<PCClass> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;

    @Override
    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String getTokenName() {
        return "SPELLCASTER";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        if (this.isEmpty(value)) {
            return new ParseResult.Fail("Value in " + this.getFullName() + " may not be empty", context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor(activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', activeValue);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer tok = new StringTokenizer(activeValue, ",");
        boolean foundAny = false;
        boolean foundOther = false;
        ArrayList<CDOMGroupRef<PCClass>> groups = new ArrayList<CDOMGroupRef<PCClass>>();
        ArrayList<CDOMSingleRef<PCClass>> prims = new ArrayList<CDOMSingleRef<PCClass>>();
        ArrayList<String> spelltypes = new ArrayList<String>();
        CDOMGroupRef<PCClass> allRef = context.getReferenceContext().getCDOMAllReference(PCCLASS_CLASS);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("ANY".equalsIgnoreCase(token)) {
                foundAny = true;
                groups.add(allRef);
                continue;
            }
            foundOther = true;
            if (token.equals("Arcane") || token.equals("Divine") || token.equals("Psionic")) {
                spelltypes.add(token);
                continue;
            }
            if (token.startsWith("TYPE.") || token.startsWith("TYPE=")) {
                CDOMGroupRef<PCClass> ref = TokenUtilities.getTypeReference(context, PCCLASS_CLASS, token.substring(5));
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getFullName() + ": " + token + " is not a valid reference: " + value, context);
                }
                groups.add(ref);
                continue;
            }
            prims.add(context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, token));
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ReferenceChoiceSet<PCClass> grcs = groups.isEmpty() ? null : new ReferenceChoiceSet<PCClass>(groups);
        ReferenceChoiceSet<PCClass> prcs = prims.isEmpty() ? null : new ReferenceChoiceSet<PCClass>(prims);
        SpellCasterChoiceSet cs = new SpellCasterChoiceSet(allRef, spelltypes, grcs, prcs);
        cs.setTitle("Spell Caster Class Choice");
        ConcretePersistentTransitionChoice<PCClass> tc = new ConcretePersistentTransitionChoice<PCClass>(cs, count);
        context.getObjectContext().addToList(obj, ListKey.ADD, tc);
        tc.setChoiceActor(this);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<PersistentTransitionChoice<?>> grantChanges = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        Collection<PersistentTransitionChoice<?>> addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice transitionChoice : addedItems) {
            SelectableSet cs = transitionChoice.getChoices();
            if (!PCCLASS_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = transitionChoice.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            if (!cs.getGroupingState().isValid()) {
                context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + cs.getLSTformat());
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, PCClass choice, PlayerCharacter pc) {
        PCClass theClass = pc.getClassKeyed(choice.getKeyName());
        if (theClass == null) {
            pc.incrementClassLevel(0, choice);
            theClass = pc.getClassKeyed(choice.getKeyName());
            pc.setSpellLists(theClass);
        }
        BonusAddition.applyBonus("PCLEVEL|" + theClass.getKeyName() + "|1", "", pc, owner);
        pc.calcActiveBonuses();
        for (PCClass pcClass : pc.getClassSet()) {
            pc.calculateKnownSpellsForClassLevel(pcClass);
        }
    }

    @Override
    public boolean allow(PCClass choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public PCClass decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(PCCLASS_CLASS, s);
    }

    @Override
    public String encodeChoice(PCClass choice) {
        return choice.getKeyName();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, PCClass choice) {
        if (owner instanceof PCClassLevel) {
            return;
        }
        this.applyChoice(owner, choice, pc);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, PCClass choice) {
        PCClass theClass = pc.getClassKeyed(choice.getKeyName());
        if (theClass != null) {
            BonusAddition.removeBonus("PCLEVEL|" + theClass.getKeyName() + "|1", pc, owner);
            pc.calcActiveBonuses();
            for (PCClass pcClass : pc.getClassSet()) {
                pc.calculateKnownSpellsForClassLevel(pcClass);
            }
        }
    }
}

