/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.QualifiedDecorator;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class EquipToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<Equipment> {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    @Override
    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String getTokenName() {
        return "EQUIP";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String activeValue = sep.next();
        if (!sep.hasNext()) {
            count = FormulaFactory.ONE;
        } else {
            count = FormulaFactory.getFormulaFor(activeValue);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            activeValue = sep.next();
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail(this.getFullName() + " had too many pipe separated items: " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', activeValue);
        if (!pr.passed()) {
            return pr;
        }
        ArrayList<CDOMReference<Equipment>> refs = new ArrayList<CDOMReference<Equipment>>();
        StringTokenizer tok = new StringTokenizer(activeValue, ",");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMReference<Equipment> lang = TokenUtilities.getTypeOrPrimitive(context, EQUIPMENT_CLASS, tokText);
            if (lang == null) {
                return new ParseResult.Fail("  Error was encountered while parsing " + this.getFullName() + ": " + value + " had an invalid reference: " + tokText, context);
            }
            refs.add(lang);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), new QualifiedDecorator(rcs));
        cs.setTitle("Equipment Choice");
        ConcretePersistentTransitionChoice<Equipment> tc = new ConcretePersistentTransitionChoice<Equipment>(cs, count);
        context.getObjectContext().addToList(obj, ListKey.ADD, tc);
        tc.setChoiceActor(this);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<PersistentTransitionChoice<?>> grantChanges = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        Collection<PersistentTransitionChoice<?>> addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice transitionChoice : addedItems) {
            SelectableSet cs = transitionChoice.getChoices();
            if (!EQUIPMENT_CLASS.equals(cs.getChoiceClass())) continue;
            Formula f = transitionChoice.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, Equipment choice, PlayerCharacter pc) {
        Equipment bEquipment = choice.clone();
        bEquipment.setQty(1.0);
        pc.addEquipment(bEquipment);
    }

    @Override
    public boolean allow(Equipment choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public Equipment decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(EQUIPMENT_CLASS, s);
    }

    @Override
    public String encodeChoice(Equipment choice) {
        return choice.getKeyName();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, Equipment choice) {
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, Equipment choice) {
        pc.removeEquipment(choice);
    }
}

