/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMCompoundOrReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class TemplateLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject>,
ChooseSelectionActor<PCTemplate> {
    private static final String ADDCHOICE_COLON = "ADDCHOICE:";
    private static final Class<PCTemplate> PCTEMPLATE_CLASS = PCTemplate.class;

    @Override
    public String getTokenName() {
        return "TEMPLATE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject cdo, String value) {
        String remaining;
        ListKey<CDOMReference<PCTemplate>> lk;
        if (cdo instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + cdo.getClass().getSimpleName(), context);
        }
        boolean consolidate = false;
        boolean specialLegal = false;
        if (value.startsWith("CHOOSE:")) {
            lk = ListKey.TEMPLATE_CHOOSE;
            remaining = value.substring("CHOOSE:".length());
            consolidate = true;
        } else if (value.startsWith(ADDCHOICE_COLON)) {
            lk = ListKey.TEMPLATE_ADDCHOICE;
            remaining = value.substring(ADDCHOICE_COLON.length());
        } else {
            lk = ListKey.TEMPLATE;
            remaining = value;
            specialLegal = true;
        }
        if (this.isEmpty(remaining) || this.hasIllegalSeparator('|', remaining)) {
            return ParseResult.INTERNAL_ERROR;
        }
        StringTokenizer tok = new StringTokenizer(remaining, "|");
        ArrayList<CDOMReference<PCTemplate>> list = new ArrayList<CDOMReference<PCTemplate>>();
        ArrayList<CDOMSingleRef<PCTemplate>> removelist = new ArrayList<CDOMSingleRef<PCTemplate>>();
        while (tok.hasMoreTokens()) {
            String templKey = tok.nextToken();
            if (specialLegal && templKey.endsWith(".REMOVE")) {
                removelist.add(context.getReferenceContext().getCDOMReference(PCTEMPLATE_CLASS, templKey.substring(0, templKey.length() - 7)));
                continue;
            }
            if (specialLegal && templKey.equals("%LIST")) {
                context.getObjectContext().addToList(cdo, ListKey.NEW_CHOOSE_ACTOR, this);
                continue;
            }
            ReferenceManufacturer<PCTemplate> referenceManufacturer = context.getReferenceContext().getManufacturer(PCTEMPLATE_CLASS);
            CDOMReference<PCTemplate> cDOMReference = TokenUtilities.getTypeOrPrimitive(referenceManufacturer, templKey);
            if (cDOMReference == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            list.add(cDOMReference);
        }
        if (consolidate) {
            CDOMCompoundOrReference<PCTemplate> ref = new CDOMCompoundOrReference<PCTemplate>(PCTEMPLATE_CLASS, "CHOOSE:");
            for (CDOMReference cDOMReference : list) {
                ref.addReference(cDOMReference);
            }
            ref.trimToSize();
            list.clear();
            list.add(ref);
        }
        for (CDOMReference cDOMReference : list) {
            context.getObjectContext().addToList(cdo, lk, cDOMReference);
        }
        if (!removelist.isEmpty()) {
            for (CDOMReference cDOMReference : removelist) {
                context.getObjectContext().addToList(cdo, ListKey.REMOVE_TEMPLATES, cDOMReference);
            }
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        Collection<CDOMReference<PCTemplate>> radd;
        Changes<CDOMReference<PCTemplate>> addchanges;
        Collection<CDOMReference<PCTemplate>> addedItems;
        Changes<CDOMReference<PCTemplate>> choosechanges;
        Collection<CDOMReference<PCTemplate>> chadded;
        Collection<ChooseSelectionActor<?>> listAdded;
        Changes<CDOMReference<PCTemplate>> changes = context.getObjectContext().getListChanges(cdo, ListKey.TEMPLATE);
        Changes<CDOMReference<PCTemplate>> removechanges = context.getObjectContext().getListChanges(cdo, ListKey.REMOVE_TEMPLATES);
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(cdo, ListKey.NEW_CHOOSE_ACTOR);
        ArrayList<String> list = new ArrayList<String>();
        Collection<CDOMReference<PCTemplate>> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor<?> csa : listAdded) {
                if (!csa.equals(this)) continue;
                list.add("%LIST");
            }
        }
        if ((chadded = (choosechanges = context.getObjectContext().getListChanges(cdo, ListKey.TEMPLATE_CHOOSE)).getAdded()) != null && !chadded.isEmpty()) {
            for (CDOMReference<PCTemplate> ref : chadded) {
                list.add("CHOOSE:" + ref.getLSTformat(false).replaceAll(",", "\\|"));
            }
        }
        if ((addedItems = (addchanges = context.getObjectContext().getListChanges(cdo, ListKey.TEMPLATE_ADDCHOICE)).getAdded()) != null && !addedItems.isEmpty()) {
            list.add(ADDCHOICE_COLON + ReferenceUtilities.joinLstFormat(addedItems, "|"));
        }
        if ((radd = removechanges.getAdded()) != null && !radd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needPipe = false;
            for (CDOMReference<PCTemplate> ref : radd) {
                if (needPipe) {
                    sb.append("|");
                }
                needPipe = true;
                sb.append(ref.getLSTformat(false)).append(".REMOVE");
            }
            list.add(sb.toString());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void removeChoice(ChooseDriver owner, PCTemplate choice, PlayerCharacter pc) {
        pc.removeTemplate(choice);
    }

    @Override
    public void applyChoice(ChooseDriver owner, PCTemplate choice, PlayerCharacter pc) {
        pc.addTemplate(choice);
    }

    @Override
    public String getLstFormat() throws PersistenceLayerException {
        return "%LIST";
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public Class<PCTemplate> getChoiceClass() {
        return PCTEMPLATE_CLASS;
    }
}

