/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SpellListToken;
import pcgen.util.Delta;

public class SpellListClassToken
extends SpellListToken {
    public static final String TOKENNAME = "SPELLLISTCLASS";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringBuilder retValue = new StringBuilder();
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int i = Integer.parseInt(aTok.nextToken());
        PObject aObject = pc.getSpellClassAtIndex(i);
        if (aObject != null) {
            PCClass aClass = null;
            if (aObject instanceof PCClass) {
                aClass = (PCClass)aObject;
            }
            if (aClass != null) {
                if (tokenSource.endsWith(".CASTERLEVEL")) {
                    retValue.append(pc.getCasterLevelForClass(aClass));
                } else if (tokenSource.endsWith(".CONCENTRATION")) {
                    if (SettingsHandler.getGame().getSpellBaseConcentration() != "") {
                        Spell sp = new Spell();
                        CharacterSpell cs = new CharacterSpell(aClass, sp);
                        int concentration = pc.getConcentration(sp, cs, aClass, 0, 0, aClass);
                        retValue.append(Delta.toString(concentration));
                    }
                } else if (tokenSource.endsWith(".LEVEL")) {
                    retValue.append(String.valueOf(pc.getDisplay().getLevel(aClass) + (int)pc.getTotalBonusTo("PCLEVEL", aClass.getKeyName())));
                } else {
                    retValue.append(OutputNameFormatting.getOutputName(aObject));
                }
            }
        }
        return retValue.toString();
    }
}

