/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    private static final long serialVersionUID = 8756733358669554185L;
    private DecimalFormat doubleFormatter;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private boolean allowSign = false;
    private double lastVal;

    public DecimalNumberField(double value, int columns) {
        super(columns);
        this.doubleFormatter = new DecimalFormat();
        this.doubleFormatter.setParseIntegerOnly(false);
        this.setValue(value);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DecimalNumberField.this.lastVal = DecimalNumberField.this.doubleFormatter.parse(DecimalNumberField.this.getText()).floatValue();
                }
                catch (ParseException p) {
                    DecimalNumberField.this.setText(DecimalNumberField.this.doubleFormatter.format(DecimalNumberField.this.lastVal));
                    DecimalNumberField.this.toolkit.beep();
                }
            }
        });
    }

    public final void setValue(double value) {
        this.lastVal = value;
        this.setText(this.doubleFormatter.format(value));
    }

    public double getValue() {
        double retVal;
        try {
            String text = this.getText();
            if (text == null || text.trim().length() == 0) {
                text = "0";
            }
            this.lastVal = retVal = this.doubleFormatter.parse(text).doubleValue();
        }
        catch (ParseException e) {
            retVal = this.lastVal;
            this.setText(this.doubleFormatter.format(this.lastVal));
            this.toolkit.beep();
        }
        return retVal;
    }

    @Override
    protected Document createDefaultModel() {
        return new DecimalNumberDocument();
    }

    private class DecimalNumberDocument
    extends PlainDocument {
        private DecimalNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            String curText = "";
            try {
                curText = this.getText(0, this.getLength());
            }
            catch (BadLocationException n) {
                // empty catch block
            }
            boolean foundPoint = curText.indexOf(46) >= 0;
            boolean foundSign = curText.indexOf(45) >= 0;
            for (int i = 0; i < result.length; ++i) {
                char ch = source[i];
                if (!DecimalNumberField.this.allowSign && ch == '-') {
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (ch == '-' && i + offs == 0) {
                    if (!foundSign) {
                        result[j++] = ch;
                        continue;
                    }
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (foundSign && i + offs == 0) {
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (ch == '.' && !foundPoint) {
                    foundPoint = true;
                    result[j++] = ch;
                    continue;
                }
                if (Character.isDigit(ch)) {
                    result[j++] = ch;
                    continue;
                }
                DecimalNumberField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

