/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import pcgen.core.CustomData;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.gui2.PCGenUIManager;
import pcgen.gui2.SplashScreen;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.converter.TokenConverter;
import pcgen.gui2.dialog.OptionsPathDialog;
import pcgen.gui2.plaf.LookAndFeelManager;
import pcgen.gui2.tools.Utility;
import pcgen.io.ExportHandler;
import pcgen.io.PCGFile;
import pcgen.persistence.CampaignFileLoader;
import pcgen.persistence.GameModeFileLoader;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.pluginmgr.PluginManager;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.system.BatchExporter;
import pcgen.system.ConfigurationSettings;
import pcgen.system.ConsoleUIDelegate;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.system.LegacySettings;
import pcgen.system.PCGenPropBundle;
import pcgen.system.PCGenSettings;
import pcgen.system.PCGenTask;
import pcgen.system.PCGenTaskExecutor;
import pcgen.system.PluginClassLoader;
import pcgen.system.PropertyContextFactory;
import pcgen.util.Logging;
import pcgen.util.PJEP;

public final class Main {
    private static PropertyContextFactory configFactory;
    private static boolean startGMGen;
    private static boolean startNPCGen;
    private static boolean startInSheet;
    private static boolean doExport;
    private static boolean ignoreJavaVer;
    private static String settingsDir;
    private static String campaignMode;
    private static String characterSheet;
    private static String exportSheet;
    private static String partyFile;
    private static String characterFile;
    private static String outputFile;

    public static boolean shouldStartInGMGen() {
        return startGMGen;
    }

    public static boolean shouldStartInNPCGen() {
        return startNPCGen;
    }

    public static boolean shouldStartInCharacterSheet() {
        return startInSheet;
    }

    public static String getStartupCampaign() {
        return campaignMode;
    }

    public static String getStartupCharacterSheet() {
        return characterSheet;
    }

    public static String getStartupPartyFile() {
        return partyFile;
    }

    public static String getStartupCharacterFile() {
        return characterFile;
    }

    private static void logSystemProps() {
        Properties props = System.getProperties();
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        pwriter.println();
        pwriter.println("-- listing properties --");
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            pwriter.println(key + "=" + props.getProperty(key));
        }
        Logging.log(Level.CONFIG, writer.toString());
    }

    public static void main(String[] args) {
        Logging.log(Level.INFO, "Starting PCGen v" + PCGenPropBundle.getVersionNumber() + PCGenPropBundle.getAutobuildString() + PCGenPropBundle.getSvnRevisionString());
        Thread.setDefaultUncaughtExceptionHandler(new PCGenUncaughtExceptionHandler());
        Main.logSystemProps();
        configFactory = new PropertyContextFactory(Main.getConfigPath());
        configFactory.registerAndLoadPropertyContext(ConfigurationSettings.getInstance());
        Main.parseCommands(args);
        Main.validateCommands();
        if (!doExport) {
            Main.startupWithGUI();
        } else {
            Main.startupWithoutGUI();
            Main.shutdown();
        }
    }

    static String getConfigPath() {
        File testPath;
        String aPath = System.getProperty("pcgen.config");
        if (aPath != null && (testPath = new File(aPath)).exists() && testPath.isDirectory()) {
            return aPath;
        }
        return SystemUtils.USER_DIR;
    }

    public static boolean loadCharacterAndExport(String characterFile, String exportSheet, String outputFile, String configFile) {
        Main.characterFile = characterFile;
        Main.exportSheet = exportSheet;
        Main.outputFile = outputFile;
        configFactory = new PropertyContextFactory(SystemUtils.USER_DIR);
        configFactory.registerAndLoadPropertyContext(ConfigurationSettings.getInstance(configFile));
        return Main.startupWithoutGUI();
    }

    private static void parseCommands(String[] args) {
        for (int index = 0; index < args.length; ++index) {
            String arg = args[index];
            if (arg.equals("-V")) {
                Logging.log(Level.CONFIG, "PCGen v" + PCGenPropBundle.getVersionNumber());
                System.exit(0);
                continue;
            }
            if (arg.equals("-G")) {
                startGMGen = true;
                continue;
            }
            if (arg.equals("-N")) {
                startNPCGen = true;
                continue;
            }
            if (arg.equals("-v")) {
                Logging.setCurrentLoggingLevel(Logging.DEBUG);
                continue;
            }
            if (arg.equals("-s")) {
                if (++index == args.length) {
                    Logging.errorPrint("-s is missing argument");
                    System.exit(1);
                }
                settingsDir = args[index];
                continue;
            }
            if (arg.equals("-m")) {
                if (++index == args.length) {
                    Logging.errorPrint("-m is missing argument");
                    System.exit(1);
                }
                campaignMode = args[index];
                continue;
            }
            if (arg.equals("-D")) {
                startInSheet = true;
                if (index + 1 >= args.length || args[index + 1].startsWith("-")) continue;
                characterSheet = args[index + 1];
                ++index;
                continue;
            }
            if (arg.equals("-E")) {
                doExport = true;
                if (index + 1 >= args.length || args[index + 1].startsWith("-")) continue;
                exportSheet = args[index + 1];
                ++index;
                continue;
            }
            if (arg.equals("-p")) {
                if (++index == args.length) {
                    Logging.errorPrint("-p is missing argument");
                    System.exit(1);
                }
                partyFile = args[index];
                continue;
            }
            if (arg.equals("-c")) {
                if (++index == args.length) {
                    Logging.errorPrint("-c is missing argument");
                    System.exit(1);
                }
                characterFile = args[index];
                continue;
            }
            if (arg.equals("-o")) {
                if (++index == args.length) {
                    Logging.errorPrint("-o is missing argument");
                    System.exit(1);
                }
                outputFile = args[index];
                continue;
            }
            if (arg.equals("-J")) {
                ignoreJavaVer = true;
                continue;
            }
            Logging.errorPrint("Unrecognized argument: \"" + arg + "\"");
            System.exit(1);
        }
    }

    private static void validateCommands() {
        File file;
        if (!(startGMGen ^ startNPCGen ^ startInSheet) ^ (startGMGen & startNPCGen & startInSheet || !(startGMGen | startNPCGen | startInSheet))) {
            Logging.errorPrint("Multiple startup arguments");
            System.exit(1);
        }
        if (settingsDir != null && !(file = new File(settingsDir)).isDirectory()) {
            Logging.errorPrint("Invalid settings directory specified: " + file.getAbsolutePath());
            System.exit(1);
        }
        if (partyFile != null && !PCGFile.isPCGenPartyFile(file = new File(partyFile))) {
            Logging.errorPrint("Invalid party file specified: " + file.getAbsolutePath());
            System.exit(1);
        }
        if (characterFile != null && !PCGFile.isPCGenCharacterFile(file = new File(characterFile))) {
            Logging.errorPrint("Invalid character file specified: " + file.getAbsolutePath());
            System.exit(1);
        }
    }

    private static void startupWithGUI() {
        Main.configureUI();
        Main.validateEnvironment(true);
        Main.loadProperties(true);
        boolean showSplash = Boolean.parseBoolean(ConfigurationSettings.initSystemProperty("showSplash", "true"));
        SplashScreen splash = null;
        if (showSplash) {
            splash = new SplashScreen();
            splash.setVisible(true);
        }
        PCGenTaskExecutor executor = new PCGenTaskExecutor();
        executor.addPCGenTask(Main.createLoadPluginTask());
        executor.addPCGenTask(new GameModeFileLoader());
        executor.addPCGenTask(new CampaignFileLoader());
        if (splash != null) {
            executor.addPCGenTaskListener(splash);
        }
        executor.execute();
        if (splash != null) {
            splash.setMessage(LanguageBundle.getString("in_taskInitUi"));
        }
        FacadeFactory.initialize();
        PCGenUIManager.initializeGUI();
        if (splash != null) {
            splash.dispose();
        }
        PCGenUIManager.startGUI();
    }

    private static void configureUI() {
        String language = ConfigurationSettings.getLanguage();
        String country = ConfigurationSettings.getCountry();
        if (StringUtils.isNotEmpty(language) && StringUtils.isNotEmpty(country)) {
            Locale.setDefault(new Locale(language, country));
        }
        LanguageBundle.init();
        LookAndFeelManager.initLookAndFeel();
        Utility.setApplicationTitle("PCGen");
    }

    private static void validateEnvironment(boolean useGui) {
        String javaVerString = System.getProperty("java.version");
        String[] javaVer = javaVerString.split("\\.");
        int majorVar = Integer.parseInt(javaVer[0]);
        int minorVar = Integer.parseInt(javaVer[1]);
        if (!ignoreJavaVer) {
            String message;
            if (majorVar < 1 || majorVar == 1 && minorVar < 6) {
                message = "Java version " + javaVerString + " is too old. PCGen requires at least Java 1.6 to run.";
                Logging.errorPrint(message);
                if (useGui) {
                    JOptionPane.showMessageDialog(null, message, "PCGen", 0);
                }
                System.exit(1);
            }
            if (majorVar > 1 || majorVar == 1 && minorVar > 8) {
                int result;
                message = "Java version " + javaVerString + " is newer than PCGen supports. The program may not\n" + "work correctly. Java versions up to 1.8 are supported.";
                Logging.errorPrint(message);
                if (useGui && (result = JOptionPane.showConfirmDialog(null, message + "\n\nDo you wish to continue?", "PCGen", 2)) != 0) {
                    System.exit(1);
                }
            }
        }
        String[] neededDirs = new String[]{ConfigurationSettings.getSystemsDir(), ConfigurationSettings.getPccFilesDir(), ConfigurationSettings.getPluginsDir(), ConfigurationSettings.getPreviewDir(), ConfigurationSettings.getOutputSheetsDir()};
        StringBuilder missingDirs = new StringBuilder();
        for (String dirPath : neededDirs) {
            File dir = new File(dirPath);
            if (dir.exists()) continue;
            String path = dirPath;
            try {
                path = dir.getCanonicalPath();
            }
            catch (IOException e) {
                Logging.errorPrint("Unable to find canonical path for " + dir);
            }
            missingDirs.append("  ").append(path).append("\n");
        }
        if (missingDirs.length() > 0) {
            String message = "This installation of PCGen is missing the following required folders:\n" + missingDirs.toString();
            Logging.errorPrint(message);
            if (useGui) {
                JOptionPane.showMessageDialog(null, message + "\nPlease reinstall PCGen.", "PCGen", 0);
            }
            System.exit(1);
        }
    }

    public static void loadProperties(boolean useGui) {
        if (settingsDir == null && ConfigurationSettings.getSystemProperty("settingsPath") == null) {
            if (!useGui) {
                Logging.errorPrint("No settingsDir specified via -s in batch mode and no default exists.");
                System.exit(1);
            }
            String filePath = OptionsPathDialog.promptSettingsPath();
            ConfigurationSettings.setSystemProperty("settingsPath", filePath);
        }
        PropertyContextFactory.setDefaultFactory(settingsDir);
        PropertyContextFactory defaultFactory = PropertyContextFactory.getDefaultFactory();
        defaultFactory.registerPropertyContext(PCGenSettings.getInstance());
        defaultFactory.registerPropertyContext(UIPropertyContext.getInstance());
        defaultFactory.registerPropertyContext(LegacySettings.getInstance());
        defaultFactory.loadPropertyContexts();
    }

    public static PCGenTask createLoadPluginTask() {
        String pluginsDir = ConfigurationSettings.getPluginsDir();
        PluginClassLoader loader = new PluginClassLoader(new File(pluginsDir));
        loader.addPluginLoader(TokenLibrary.getInstance());
        loader.addPluginLoader(TokenStore.inst());
        try {
            loader.addPluginLoader(PreParserFactory.getInstance());
        }
        catch (PersistenceLayerException ex) {
            Logging.errorPrint("createLoadPluginTask failed", ex);
        }
        loader.addPluginLoader(PrerequisiteTestFactory.getInstance());
        loader.addPluginLoader(PrerequisiteWriterFactory.getInstance());
        loader.addPluginLoader(PJEP.getJepPluginLoader());
        loader.addPluginLoader(ExportHandler.getPluginLoader());
        loader.addPluginLoader(TokenConverter.getPluginLoader());
        loader.addPluginLoader(PluginManager.getInstance());
        return loader;
    }

    private static boolean startupWithoutGUI() {
        Main.loadProperties(false);
        Main.validateEnvironment(false);
        PCGenTaskExecutor executor = new PCGenTaskExecutor();
        executor.addPCGenTask(Main.createLoadPluginTask());
        executor.addPCGenTask(new GameModeFileLoader());
        executor.addPCGenTask(new CampaignFileLoader());
        executor.execute();
        ConsoleUIDelegate uiDelegate = new ConsoleUIDelegate();
        BatchExporter exporter = new BatchExporter(exportSheet, uiDelegate);
        boolean result = true;
        if (partyFile != null) {
            result = exporter.exportParty(partyFile, outputFile);
        }
        if (characterFile != null) {
            result = exporter.exportCharacter(characterFile, outputFile);
        }
        return result;
    }

    public static void shutdown() {
        configFactory.savePropertyContexts();
        BatchExporter.removeTemporaryFiles();
        PropertyContextFactory.getDefaultFactory().savePropertyContexts();
        if (PCGenSettings.OPTIONS_CONTEXT.getBoolean("saveCustomInLst")) {
            CustomData.writeCustomItems();
        }
        System.exit(0);
    }

    static {
        startGMGen = false;
        startNPCGen = false;
        startInSheet = false;
        doExport = false;
        ignoreJavaVer = false;
        settingsDir = null;
        campaignMode = null;
        characterSheet = null;
        exportSheet = null;
        partyFile = null;
        characterFile = null;
        outputFile = null;
    }

    private static class PCGenUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PCGenUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread arg0, Throwable arg1) {
            Logging.errorPrint("Uncaught error - ignoring", arg1);
        }
    }
}

