/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import freemarker.template.ObjectWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.facet.DataSetInitializationFacet;
import pcgen.cdom.facet.FacetInitialization;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.inst.ObjectCache;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.Campaign;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.ParsingSeparator;
import pcgen.output.library.ObjectWrapperLibrary;
import pcgen.output.wrapper.AgeSetWrapper;
import pcgen.output.wrapper.CDOMObjectWrapper;
import pcgen.output.wrapper.CDOMReferenceWrapper;
import pcgen.output.wrapper.CNAbilitySelectionWrapper;
import pcgen.output.wrapper.CategoryWrapper;
import pcgen.output.wrapper.EnumWrapper;
import pcgen.output.wrapper.OrderedPairWrapper;
import pcgen.output.wrapper.TypeSafeConstantWrapper;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AbstractListContext;
import pcgen.rules.context.AbstractObjectContext;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.ReferenceContextUtilities;
import pcgen.rules.persistence.ChoiceSetLoadUtilities;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.rules.persistence.TokenSupport;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.rules.persistence.token.PostValidationToken;
import pcgen.util.Logging;

public abstract class LoadContextInst
implements LoadContext {
    private static final PrerequisiteWriter PREREQ_WRITER = new PrerequisiteWriter();
    private final DataSetID datasetID = DataSetID.getID();
    private final AbstractListContext list;
    private final AbstractObjectContext obj;
    private final AbstractReferenceContext ref;
    private final List<Campaign> campaignList = new ArrayList<Campaign>();
    private int writeMessageCount = 0;
    private final TokenSupport support = new TokenSupport();
    private final List<Object> dontForget = new ArrayList<Object>();
    private URI sourceURI;
    private CDOMObject stateful;

    public LoadContextInst(AbstractReferenceContext rc, AbstractListContext lc, AbstractObjectContext oc) {
        if (rc == null) {
            throw new IllegalArgumentException("ReferenceContext cannot be null");
        }
        if (lc == null) {
            throw new IllegalArgumentException("ListContext cannot be null");
        }
        if (oc == null) {
            throw new IllegalArgumentException("ObjectContext cannot be null");
        }
        this.ref = rc;
        this.list = lc;
        this.obj = oc;
    }

    @Override
    public void addWriteMessage(String string) {
        Logging.errorPrint("!!" + string);
        ++this.writeMessageCount;
    }

    @Override
    public int getWriteMessageCount() {
        return this.writeMessageCount;
    }

    @Override
    public void setExtractURI(URI extractURI) {
        this.getObjectContext().setExtractURI(extractURI);
        this.getReferenceContext().setExtractURI(extractURI);
        this.getListContext().setExtractURI(extractURI);
    }

    @Override
    public void setSourceURI(URI sourceURI) {
        this.sourceURI = sourceURI;
        this.getObjectContext().setSourceURI(sourceURI);
        this.getReferenceContext().setSourceURI(sourceURI);
        this.getListContext().setSourceURI(sourceURI);
        this.clearStatefulInformation();
        Logging.debugPrint("Starting Load of " + sourceURI);
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    public abstract String getContextType();

    @Override
    public AbstractObjectContext getObjectContext() {
        return this.obj;
    }

    @Override
    public AbstractListContext getListContext() {
        return this.list;
    }

    @Override
    public void commit() {
        this.getListContext().commit();
        this.getObjectContext().commit();
    }

    @Override
    public void rollback() {
        this.getListContext().rollback();
        this.getObjectContext().rollback();
    }

    @Override
    public void resolveDeferredTokens() {
        for (DeferredToken<? extends Loadable> token : this.support.getDeferredTokens()) {
            this.processRes(token);
        }
        this.commit();
    }

    private <T extends Loadable> void processRes(DeferredToken<T> token) {
        Class<T> cl = token.getDeferredTokenClass();
        Collection<ReferenceManufacturer<?>> mfgs = this.getReferenceContext().getAllManufacturers();
        for (ReferenceManufacturer<?> rm : mfgs) {
            if (!cl.isAssignableFrom(rm.getReferenceClass())) continue;
            ReferenceManufacturer<?> trm = rm;
            for (Loadable po : trm.getAllObjects()) {
                token.process(this, po);
            }
            for (Loadable po : trm.getDerivativeObjects()) {
                token.process(this, po);
            }
        }
    }

    @Override
    public void resolvePostDeferredTokens() {
        Collection<? extends ReferenceManufacturer<?>> mfgs = this.getReferenceContext().getAllManufacturers();
        for (PostDeferredToken<? extends Loadable> token : TokenLibrary.getPostDeferredTokens()) {
            this.processPostRes(token, mfgs);
        }
    }

    private <T extends Loadable> void processPostRes(PostDeferredToken<T> token, Collection<? extends ReferenceManufacturer<?>> mfgs) {
        Class<T> cl = token.getDeferredTokenClass();
        for (ReferenceManufacturer<?> rm : mfgs) {
            if (!cl.isAssignableFrom(rm.getReferenceClass())) continue;
            ReferenceManufacturer<?> trm = rm;
            for (Loadable po : trm.getAllObjects()) {
                this.setSourceURI(po.getSourceURI());
                token.process(this, po);
            }
        }
    }

    @Override
    public void resolvePostValidationTokens() {
        Collection<? extends ReferenceManufacturer<?>> mfgs = this.getReferenceContext().getAllManufacturers();
        for (PostValidationToken<? extends Loadable> token : TokenLibrary.getPostValidationTokens()) {
            this.processPostVal(token, mfgs);
        }
    }

    private <T extends Loadable> void processPostVal(PostValidationToken<T> token, Collection<? extends ReferenceManufacturer> mfgs) {
        Class cl = token.getValidationTokenClass();
        for (ReferenceManufacturer referenceManufacturer : mfgs) {
            if (!cl.isAssignableFrom(referenceManufacturer.getReferenceClass())) continue;
            this.setSourceURI(null);
            token.process(this, referenceManufacturer.getAllObjects());
        }
    }

    @Override
    public <T extends CDOMObject> PrimitiveCollection<T> getChoiceSet(SelectionCreator<T> sc, String value) {
        try {
            return ChoiceSetLoadUtilities.getChoiceSet(this, sc, value);
        }
        catch (ParsingSeparator.GroupingMismatchException e) {
            Logging.errorPrint("Group Mismatch in getting ChoiceSet: " + e.getMessage());
            return null;
        }
    }

    @Override
    public <T extends CDOMObject> PrimitiveCollection<T> getPrimitiveChoiceFilter(SelectionCreator<T> sc, String key) {
        return ChoiceSetLoadUtilities.getPrimitive(this, sc, key);
    }

    @Override
    public <T> ParseResult processSubToken(T cdo, String tokenName, String key, String value) {
        return this.support.processSubToken(this, cdo, tokenName, key, value);
    }

    @Override
    public <T extends Loadable> boolean processToken(T derivative, String typeStr, String argument) throws PersistenceLayerException {
        return this.support.processToken(this, derivative, typeStr, argument);
    }

    @Override
    public <T extends Loadable> void unconditionallyProcess(T cdo, String key, String value) {
        try {
            if (this.processToken(cdo, key, value)) {
                this.commit();
            } else {
                this.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        catch (PersistenceLayerException e) {
            Logging.errorPrint("Error in token parse: " + e.getLocalizedMessage());
        }
    }

    @Override
    public <T> String[] unparseSubtoken(T cdo, String tokenName) {
        return this.support.unparseSubtoken(this, cdo, tokenName);
    }

    @Override
    public <T> Collection<String> unparse(T cdo) {
        return this.support.unparse(this, cdo);
    }

    @Override
    public <T extends CDOMObject> T cloneConstructedCDOMObject(T cdo, String newName) {
        T newObj = this.getObjectContext().cloneConstructedCDOMObject(cdo, newName);
        this.getReferenceContext().importObject(newObj);
        return newObj;
    }

    <T extends CDOMObject> T cloneInMasterLists(T cdo, String newName) {
        CDOMObject newObj;
        try {
            newObj = cdo.clone();
            newObj.setName(newName);
            this.getListContext().cloneInMasterLists(cdo, newObj);
        }
        catch (CloneNotSupportedException e) {
            Logging.errorPrint("Failed to clone " + cdo, e);
            return null;
        }
        return (T)newObj;
    }

    @Override
    public String getPrerequisiteString(Collection<Prerequisite> prereqs) {
        try {
            return PREREQ_WRITER.getPrerequisiteString(prereqs);
        }
        catch (PersistenceLayerException e) {
            this.addWriteMessage("Error writing Prerequisite: " + e);
            return null;
        }
    }

    @Override
    public CampaignSourceEntry getCampaignSourceEntry(Campaign source, String value) {
        return CampaignSourceEntry.getNewCSE(source, this.sourceURI, value);
    }

    @Override
    public void clearStatefulInformation() {
        this.stateful = null;
    }

    @Override
    public boolean addStatefulToken(String s) throws PersistenceLayerException {
        int colonLoc = s.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Found invalid stateful token: " + s);
            return false;
        }
        if (this.stateful == null) {
            this.stateful = new ObjectCache();
        }
        return this.processToken(this.stateful, s.substring(0, colonLoc).intern(), s.substring(colonLoc + 1).intern());
    }

    @Override
    public void addStatefulInformation(CDOMObject target) {
        if (this.stateful != null) {
            target.overlayCDOMObject(this.stateful);
        }
    }

    @Override
    public void setLoaded(List<Campaign> campaigns) {
        this.campaignList.clear();
        this.campaignList.addAll(campaigns);
    }

    @Override
    public abstract boolean consolidate();

    @Override
    public DataSetID getDataSetID() {
        return this.datasetID;
    }

    @Override
    public void loadCampaignFacets() {
        FacetLibrary.getFacet(DataSetInitializationFacet.class).initialize(this);
    }

    @Override
    public void forgetMeNot(CDOMReference<?> cdr) {
        this.dontForget.add(cdr);
    }

    @Override
    public AbstractReferenceContext getReferenceContext() {
        return this.ref;
    }

    @Override
    public List<Campaign> getLoadedCampaigns() {
        return Collections.unmodifiableList(this.campaignList);
    }

    @Override
    public ReferenceManufacturer<? extends Loadable> getManufacturer(String firstToken) {
        return ReferenceContextUtilities.getManufacturer(this.getReferenceContext(), firstToken);
    }

    @Override
    public <T extends CDOMObject> T performCopy(T object, String copyName) {
        T copy = this.ref.performCopy(object, copyName);
        this.list.cloneInMasterLists(object, copy);
        return copy;
    }

    @Override
    public void loadLocalToken(Object token) {
        this.support.loadLocalToken(token);
    }

    @Override
    public <T> GroupDefinition<T> getGroup(Class<T> cl, String s) {
        return this.support.getGroup(cl, s);
    }

    static {
        FacetInitialization.initialize();
        ObjectWrapperLibrary owl = ObjectWrapperLibrary.getInstance();
        owl.add(ObjectWrapper.SIMPLE_WRAPPER);
        owl.add(CDOMObjectWrapper.getInstance());
        owl.add(new AgeSetWrapper());
        owl.add(new CDOMReferenceWrapper());
        owl.add(new TypeSafeConstantWrapper());
        owl.add(new CNAbilitySelectionWrapper());
        owl.add(new CategoryWrapper());
        owl.add(new EnumWrapper());
        owl.add(new OrderedPairWrapper());
    }
}

