/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public abstract class AbstractPrerequisiteListParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    protected void convertKeysToSubKeys(Prerequisite prereq, String kind) {
        if (prereq == null) {
            return;
        }
        if (prereq.getKind() != null && prereq.getKind().equalsIgnoreCase(kind)) {
            String key = prereq.getKey().trim();
            int index = key.indexOf(40);
            int endIndex = key.lastIndexOf(41);
            if (index >= 0 && endIndex == key.length() - 1) {
                String subKey = key.substring(index + 1, endIndex).trim();
                key = key.substring(0, index).trim();
                prereq.setKey(key);
                prereq.setSubKey(subKey);
            }
        }
        for (Prerequisite element : prereq.getPrerequisites()) {
            this.convertKeysToSubKeys(element, kind);
        }
    }

    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.parsePrereqListType(prereq, kind, formula);
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        return prereq;
    }

    protected void parsePrereqListType(Prerequisite prereq, String kind, String formula) throws PersistenceLayerException {
        int numRequired;
        ParseResult parseResult = this.checkForIllegalSeparator(kind, ',', formula);
        if (!parseResult.passed()) {
            throw new PersistenceLayerException(parseResult.toString());
        }
        if (!(this.allowsNegate() || formula.indexOf("[") < 0 && formula.indexOf("]") < 0)) {
            throw new PersistenceLayerException("Prerequisite " + kind + " can not contain []: " + formula);
        }
        if (formula.indexOf("|") >= 0) {
            throw new PersistenceLayerException("Prerequisite " + kind + " can not contain |: " + formula);
        }
        String[] elements = formula.split(",");
        try {
            numRequired = Integer.parseInt(elements[0]);
            if (elements.length == 1) {
                throw new PersistenceLayerException("Prerequisite " + kind + " can not have only a count: " + formula);
            }
        }
        catch (NumberFormatException nfe) {
            throw new PersistenceLayerException("'" + elements[0] + "' is not a valid integer");
        }
        int elementsLength = elements.length;
        for (int i = elementsLength - 1; i >= 0; --i) {
            if (!"CHECKMULT".equalsIgnoreCase(elements[i])) continue;
            prereq.setCountMultiples(true);
            --elementsLength;
        }
        if (elementsLength > 2) {
            prereq.setOperator(PrerequisiteOperator.GTEQ);
            prereq.setOperand(Integer.toString(numRequired));
            prereq.setKind(null);
            boolean hasKeyValue = false;
            boolean hasKeyOnly = false;
            int min = -99;
            for (int i = 1; i < elements.length; ++i) {
                Prerequisite subreq;
                block34: {
                    String thisElement = elements[i];
                    if ("CHECKMULT".equals(thisElement)) continue;
                    boolean warnIgnored = this.isNoWarnElement(thisElement);
                    subreq = new Prerequisite();
                    subreq.setKind(kind.toLowerCase());
                    subreq.setCountMultiples(true);
                    if (thisElement.indexOf(61) >= 0) {
                        subreq.setOperator(PrerequisiteOperator.GTEQ);
                        String[] tokens = thisElement.split("=");
                        try {
                            int valueIndx = tokens.length - 1;
                            min = Integer.parseInt(tokens[valueIndx]);
                            subreq.setOperand(Integer.toString(min));
                            String requirementKey = this.getRequirementKey(tokens);
                            subreq.setKey(requirementKey);
                            for (Prerequisite p : new ArrayList<Prerequisite>(prereq.getPrerequisites())) {
                                if (!p.getOperand().equals("-99")) continue;
                                p.setOperand(Integer.toString(min));
                                if (!p.getKey().equals(requirementKey)) continue;
                                prereq.removePrerequisite(p);
                            }
                            if (!warnIgnored) {
                                hasKeyValue = true;
                            }
                            break block34;
                        }
                        catch (NumberFormatException nfe) {
                            subreq.setKey(thisElement);
                            if (!warnIgnored) {
                                hasKeyOnly = true;
                            }
                            break block34;
                        }
                    }
                    if (this.requiresValue()) {
                        throw new PersistenceLayerException("Prerequisites of kind " + kind + " require a target value, e.g. Key=Value");
                    }
                    String assumed = this.getAssumedValue();
                    if (assumed == null) {
                        subreq.setOperand(Integer.toString(min));
                    } else {
                        Logging.deprecationPrint("Old syntax detected: Prerequisites of kind " + kind + " now require a target value, " + "e.g. Key=Value.  Assuming Value=" + assumed);
                        subreq.setOperand(assumed);
                    }
                    if (!warnIgnored) {
                        hasKeyOnly = true;
                    }
                    subreq.setKey(thisElement);
                    subreq.setOperator(PrerequisiteOperator.GTEQ);
                }
                subreq.setOperand(Integer.toString(min));
                prereq.addPrerequisite(subreq);
            }
            for (Prerequisite element : prereq.getPrerequisites()) {
                if (!element.getOperand().equals("-99")) continue;
                element.setOperand("1");
            }
            if (hasKeyOnly && hasKeyValue) {
                Logging.deprecationPrint("You are using a deprecated syntax of PRE" + kind + ":" + formula + " ... Each item in the list should have a target value, e.g.: PRE" + kind + ":1,First=99,Second=5");
            }
        } else {
            Prerequisite subreq = prereq;
            if (elementsLength > 1) {
                for (int i = 1; i < elements.length; ++i) {
                    if ("CHECKMULT".equalsIgnoreCase(elements[i])) continue;
                    if (elements[i].indexOf(61) >= 0) {
                        String[] tokens = elements[i].split("=");
                        int valueIdx = tokens.length - 1;
                        try {
                            int iOper = Integer.parseInt(tokens[valueIdx]);
                            if (numRequired != 1) {
                                prereq.setOperator(PrerequisiteOperator.GTEQ);
                                prereq.setOperand(Integer.toString(numRequired));
                                prereq.setKind(null);
                                subreq = new Prerequisite();
                                prereq.addPrerequisite(subreq);
                                subreq.setCountMultiples(true);
                            }
                            subreq.setOperand(Integer.toString(iOper));
                            String requirementKey = this.getRequirementKey(tokens);
                            subreq.setKey(requirementKey);
                        }
                        catch (NumberFormatException nfe) {
                            if (tokens[valueIdx].equals("ANY")) {
                                if (this.isAnyLegal()) {
                                    subreq.setOperand(tokens[valueIdx]);
                                    subreq.setKey(this.getRequirementKey(tokens));
                                    break;
                                }
                                throw new PersistenceLayerException("Prerequisites of kind " + kind + " do not support 'ANY'");
                            }
                            subreq.setOperand(elements[0]);
                            subreq.setKey(elements[i]);
                        }
                        break;
                    }
                    if (this.requiresValue()) {
                        throw new PersistenceLayerException("Prerequisites of kind " + kind + " require a target value, e.g. Key=Value");
                    }
                    String assumed = this.getAssumedValue();
                    if (assumed == null) {
                        subreq.setOperand(elements[0]);
                    } else {
                        Logging.deprecationPrint("Old syntax detected: Prerequisites of kind " + kind + " now require a target value, " + "e.g. Key=Value.  Assuming Value=" + assumed);
                        subreq.setOperand(assumed);
                    }
                    subreq.setKey(elements[i]);
                    break;
                }
            } else {
                subreq.setOperand(elements[0]);
            }
            subreq.setKind(kind.toLowerCase());
            subreq.setOperator(PrerequisiteOperator.GTEQ);
        }
    }

    private String getRequirementKey(String[] tokens) {
        String reqKey;
        if (tokens.length == 2) {
            reqKey = tokens[0];
        } else {
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(Arrays.asList(tokens));
            parts.remove(parts.size() - 1);
            reqKey = StringUtils.join(parts, "=");
        }
        return reqKey;
    }

    protected boolean isNoWarnElement(String thisElement) {
        return false;
    }

    protected boolean isAnyLegal() {
        return true;
    }

    protected String getAssumedValue() {
        return null;
    }

    protected boolean requiresValue() {
        return false;
    }

    protected boolean allowsNegate() {
        return false;
    }

    protected void setNoNeedForChar(Prerequisite prereq) {
        if (prereq == null) {
            return;
        }
        prereq.setCharacterRequired(false);
        for (Prerequisite element : prereq.getPrerequisites()) {
            this.setNoNeedForChar(element);
        }
    }
}

