/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.rules.context.LoadContext;

public class LocationLoader
extends LstLineFileLoader {
    private int traitType = -1;

    @Override
    public void loadLstFile(LoadContext context, URI source) throws PersistenceLayerException {
        this.traitType = -1;
        super.loadLstFile(context, source);
    }

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) {
        if (lstLine.charAt(0) != '[') {
            switch (this.traitType) {
                case 0: {
                    SystemCollections.addToLocationList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 1: {
                    SystemCollections.addToBirthplaceList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 2: {
                    SystemCollections.addToCityList(lstLine.intern(), this.gameMode);
                    break;
                }
            }
        } else {
            this.traitType = lstLine.startsWith("[LOCATION]") ? 0 : (lstLine.startsWith("[BIRTHPLACE]") ? 1 : (lstLine.startsWith("[CITY]") ? 2 : -1));
        }
    }
}

