/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class AbilityLoader
extends LstObjectFileLoader<Ability> {
    @Override
    public Ability parseLine(LoadContext context, Ability ability, String lstLine, SourceEntry source) throws PersistenceLayerException {
        StringTokenizer colToken;
        Ability anAbility = ability;
        boolean isnew = false;
        if (anAbility == null) {
            anAbility = new Ability();
            isnew = true;
        }
        if ((colToken = new StringTokenizer(lstLine, "\t")).hasMoreTokens()) {
            anAbility.setName(colToken.nextToken().intern());
            anAbility.put(ObjectKey.SOURCE_CAMPAIGN, source.getCampaign());
            anAbility.setSourceURI(source.getURI());
            if (isnew) {
                context.addStatefulInformation(anAbility);
                context.getReferenceContext().importObject(anAbility);
            }
        }
        while (colToken.hasMoreTokens()) {
            LstUtils.processToken(context, anAbility, source, colToken.nextToken());
        }
        this.completeObject(context, source, anAbility);
        return null;
    }

    @Override
    protected Ability getObjectKeyed(LoadContext context, String aKey) {
        if (aKey == null || aKey.length() == 0) {
            return null;
        }
        String[] parts = aKey.split("\\|");
        if (parts.length != 2 || !parts[0].startsWith("CATEGORY=")) {
            String message = "Attempt to Modify/Copy/Forget an Ability (" + aKey + ") without a CATEGORY=\n" + "  Proper format is CATEGORY=cat|abilityKey";
            Logging.log(Logging.LST_ERROR, message);
            return null;
        }
        String abilityCatName = parts[0].substring(9);
        String abilityKey = parts[1];
        AbilityCategory ac = SettingsHandler.getGame().getAbilityCategory(abilityCatName);
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, ac, abilityKey);
    }

    @Override
    protected Ability getMatchingObject(LoadContext context, CDOMObject key) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, ((Ability)key).getCDOMCategory(), key.getKeyName());
    }

    @Override
    protected final boolean includeObject(SourceEntry source, CDOMObject cdo) {
        if (cdo == null || cdo.getDisplayName() == null || cdo.getDisplayName().trim().length() == 0 || cdo.getKeyName() == null || cdo.getKeyName().trim().length() == 0) {
            return false;
        }
        Ability ability = (Ability)cdo;
        List<String> includeItems = source.getIncludeItems();
        if (!includeItems.isEmpty()) {
            if (includeItems.contains(ability.getCategory() + "," + ability.getKeyName())) {
                return true;
            }
            if (includeItems.contains(ability.getKeyName())) {
                Logging.deprecationPrint("Deprecated INCLUDE value when loading " + source.getURI() + " . Abilities (including feats) must always have " + "categories (e.g. " + "INCLUDE:CATEGORY=cat1,key1,key2|CATEGORY=cat2,key3 ).");
                return true;
            }
            return false;
        }
        List<String> excludeItems = source.getExcludeItems();
        if (!excludeItems.isEmpty()) {
            if (excludeItems.contains(ability.getCategory() + "," + ability.getKeyName())) {
                return false;
            }
            if (excludeItems.contains(ability.getKeyName())) {
                Logging.deprecationPrint("Deprecated EXCLUDE value when loading " + source.getURI() + " . Abilities (including feats) must always have " + "categories (e.g. " + "EXCLUDE:CATEGORY=cat1,key1,key2|CATEGORY=cat2,key3 ).");
                return false;
            }
            return true;
        }
        return true;
    }
}

