/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.Collection;
import pcgen.base.lang.UnreachableError;
import pcgen.cdom.base.Constants;
import pcgen.cdom.content.Sponsor;
import pcgen.cdom.content.TabInfo;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.core.CustomData;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PaperInfo;
import pcgen.core.PointBuyCost;
import pcgen.core.QualifiedObject;
import pcgen.core.RuleCheck;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.BioSetLoader;
import pcgen.persistence.lst.EquipIconLoader;
import pcgen.persistence.lst.EquipSlotLoader;
import pcgen.persistence.lst.GameModeLoader;
import pcgen.persistence.lst.LevelLoader;
import pcgen.persistence.lst.LoadInfoLoader;
import pcgen.persistence.lst.LocationLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.MigrationLoader;
import pcgen.persistence.lst.PointBuyLoader;
import pcgen.persistence.lst.SimpleLoader;
import pcgen.persistence.lst.SimplePrefixLoader;
import pcgen.persistence.lst.SizeAdjustmentLoader;
import pcgen.persistence.lst.StatsAndChecksLoader;
import pcgen.persistence.lst.TraitLoader;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenTask;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class GameModeFileLoader
extends PCGenTask {
    private static final FilenameFilter gameModeFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File aFile, String aString) {
            try {
                File d = new File(aFile, aString);
                if (d.isDirectory()) {
                    return new File(d, "statsandchecks.lst").exists() && new File(d, "miscinfo.lst").exists();
                }
            }
            catch (SecurityException e) {
                Logging.errorPrint("GameModes.listGameFiles", e);
            }
            return false;
        }
    };
    private static UnitSet DEFAULT_UNIT_SET;
    private SimpleLoader<RuleCheck> ruleCheckLoader = new SimpleLoader<RuleCheck>(RuleCheck.class);
    private LoadInfoLoader loadInfoLoader = new LoadInfoLoader();
    private EquipSlotLoader eqSlotLoader = new EquipSlotLoader();
    private SimpleLoader<PaperInfo> paperLoader = new SimplePrefixLoader<PaperInfo>(PaperInfo.class, "NAME");
    private PointBuyLoader pointBuyLoader = new PointBuyLoader();
    private TraitLoader traitLoader = new TraitLoader();
    private LocationLoader locationLoader = new LocationLoader();
    private SizeAdjustmentLoader sizeLoader = new SizeAdjustmentLoader();
    private StatsAndChecksLoader statCheckLoader = new StatsAndChecksLoader();
    private MigrationLoader migrationLoader = new MigrationLoader();
    private BioSetLoader bioLoader = new BioSetLoader();
    private SimpleLoader<Sponsor> sponsorLoader = new SimplePrefixLoader<Sponsor>(Sponsor.class, "SPONSOR");
    private EquipIconLoader equipIconLoader = new EquipIconLoader();

    @Override
    public String getMessage() {
        return LanguageBundle.getString("in_taskLoadGameModes");
    }

    @Override
    public void execute() {
        String[] gameFiles = GameModeFileLoader.getGameFilesList();
        if (gameFiles != null && gameFiles.length > 0) {
            this.setMaximum(gameFiles.length + 1);
            this.loadGameModes(gameFiles);
        }
        this.loadSponsorsLstFile();
    }

    private static String[] getGameFilesList() {
        String aDirectory = ConfigurationSettings.getSystemsDir() + File.separator + "gameModes" + File.separator;
        return new File(aDirectory).list(gameModeFileFilter);
    }

    private void loadSponsorsLstFile() {
        File sponsorDir = new File(ConfigurationSettings.getSystemsDir(), "sponsors");
        File sponsorFile = new File(sponsorDir, "sponsors.lst");
        try {
            this.sponsorLoader.loadLstFile(Globals.getGlobalContext(), sponsorFile.toURI(), null);
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Warning: sponsors file is missing");
        }
    }

    private void loadGameModes(String[] gameFiles) {
        int progress = 0;
        SystemCollections.clearGameModeList();
        File gameModeDir = new File(ConfigurationSettings.getSystemsDir(), "gameModes");
        for (String gameFile : gameFiles) {
            File specGameModeDir = new File(gameModeDir, gameFile);
            File miscInfoFile = new File(specGameModeDir, "miscinfo.lst");
            GameMode gm = GameModeFileLoader.loadGameModeMiscInfo(gameFile, miscInfoFile.toURI());
            if (gm != null) {
                String gmName = gm.getName();
                LoadContext context = gm.getModeContext();
                this.loadGameModeInfoFile(gm, new File(specGameModeDir, "level.lst").toURI(), "level");
                this.loadGameModeInfoFile(gm, new File(specGameModeDir, "rules.lst").toURI(), "rules");
                this.loadGameModeLstFile(context, this.eqSlotLoader, gmName, gameFile, "equipmentslots.lst");
                this.loadGameModeLstFile(context, this.paperLoader, gmName, gameFile, "paperInfo.lst");
                this.loadGameModeLstFile(context, this.traitLoader, gmName, gameFile, "bio" + File.separator + "traits.lst");
                this.loadGameModeLstFile(context, this.locationLoader, gmName, gameFile, "bio" + File.separator + "locations.lst");
                this.loadGameModeLstFile(context, this.loadInfoLoader, gmName, gameFile, "load.lst");
                this.loadGameModeLstFile(context, this.sizeLoader, gmName, gameFile, "sizeAdjustment.lst");
                this.loadGameModeLstFile(context, this.statCheckLoader, gmName, gameFile, "statsandchecks.lst");
                this.loadGameModeLstFile(context, this.equipIconLoader, gmName, gameFile, "equipIcons.lst");
                this.loadPointBuyFile(context, gameFile, gmName);
                for (PointBuyCost pbc : context.getReferenceContext().getConstructedCDOMObjects(PointBuyCost.class)) {
                    gm.addPointBuyStatCost(pbc);
                }
                this.loadGameModeLstFile(context, this.migrationLoader, gmName, gameFile, "migration.lst");
                this.loadGameModeLstFile(context, this.bioLoader, gmName, gameFile, "bio" + File.separator + "biosettings.lst");
            }
            try {
                GameModeFileLoader.addDefaultWieldCategories(gm.getModeContext());
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint("Error Initializing PreParserFactory");
                Logging.errorPrint("  " + ple.getMessage(), ple);
                throw new UnreachableError();
            }
            this.setProgress(++progress);
        }
        SystemCollections.sortGameModeList();
    }

    private void loadGameModeLstFile(LoadContext context, LstLineFileLoader lstFileLoader, String gameModeName, String gameModeFolderName, String lstFileName) {
        this.loadGameModeLstFile(context, lstFileLoader, gameModeName, gameModeFolderName, lstFileName, true);
    }

    private boolean loadGameModeLstFile(LoadContext context, LstLineFileLoader lstFileLoader, String gameModeName, String gameModeFolderName, String lstFileName, boolean showMissing) {
        block6: {
            File gameModeFile;
            File specGameModeDir;
            File gameModeDir = new File(ConfigurationSettings.getSystemsDir(), "gameModes");
            try {
                specGameModeDir = new File(gameModeDir, gameModeFolderName);
                gameModeFile = new File(specGameModeDir, lstFileName);
                if (gameModeFile.exists()) {
                    lstFileLoader.loadLstFile(context, gameModeFile.toURI(), gameModeName);
                    return true;
                }
            }
            catch (PersistenceLayerException ple) {
                // empty catch block
            }
            try {
                specGameModeDir = new File(gameModeDir, "default");
                gameModeFile = new File(specGameModeDir, lstFileName);
                if (gameModeFile.exists()) {
                    lstFileLoader.loadLstFile(context, gameModeFile.toURI(), gameModeName);
                    return true;
                }
            }
            catch (PersistenceLayerException ple2) {
                if (!showMissing) break block6;
                Logging.errorPrint("Warning: game mode " + gameModeName + " is missing file " + lstFileName);
            }
        }
        return false;
    }

    private void loadGameModeInfoFile(GameMode gameMode, URI uri, String aType) {
        String data;
        try {
            data = LstFileLoader.readFromURI(uri).toString();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint(LanguageBundle.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uri, ple.getMessage()));
            return;
        }
        String[] fileLines = data.split("(\r\n?|\n)");
        String xpTable = "";
        for (int i = 0; i < fileLines.length; ++i) {
            String aLine = fileLines[i];
            if (aLine.length() > 0 && aLine.charAt(0) == '#' || aLine.length() == 0) continue;
            if (aType.equals("load")) {
                gameMode.addLoadString(aLine.intern());
                continue;
            }
            if (aType.equals("level")) {
                xpTable = LevelLoader.parseLine(gameMode, aLine, i + 1, uri, xpTable);
                continue;
            }
            if (!aType.equals("rules")) continue;
            try {
                this.ruleCheckLoader.parseLine(gameMode.getModeContext(), aLine, uri);
                continue;
            }
            catch (PersistenceLayerException e) {
                Logging.errorPrint(LanguageBundle.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uri, e.getMessage()));
            }
        }
    }

    private static GameMode loadGameModeMiscInfo(String aName, URI uri) {
        String data;
        GameMode gameMode = null;
        try {
            data = LstFileLoader.readFromURI(uri).toString();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint(LanguageBundle.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uri, ple.getMessage()));
            return gameMode;
        }
        String[] fileLines = data.split("(\r\n?|\n)");
        for (int i = 0; i < fileLines.length; ++i) {
            String aLine = fileLines[i];
            if (aLine.length() > 0 && aLine.charAt(0) == '#' || aLine.length() == 0) continue;
            if (gameMode == null) {
                gameMode = new GameMode(aName);
                SystemCollections.addToGameModeList(gameMode);
                gameMode.getModeContext().getReferenceContext().importObject(AbilityCategory.FEAT);
            }
            GameModeLoader.parseMiscGameInfoLine(gameMode, aLine, uri, i + 1);
        }
        AbilityCategory feat = new AbilityCategory();
        feat.copyFields(AbilityCategory.FEAT);
        gameMode.setFeatTemplate(feat);
        int[] dieSizes = gameMode.getDieSizes();
        if (dieSizes == null || dieSizes.length == 0) {
            int[] defaultDieSizes = new int[]{1, 2, 3, 4, 6, 8, 10, 12, 20, 100, 1000};
            gameMode.setDieSizes(defaultDieSizes);
            Logging.log(Logging.LST_ERROR, "GameMode (" + gameMode.getName() + ") : MiscInfo.lst did not contain any valid DIESIZES. " + "Using the system default DIESIZES.");
        }
        GameModeFileLoader.addDefaultUnitSet(gameMode);
        GameModeFileLoader.addDefaultTabInfo(gameMode);
        gameMode.applyPreferences();
        return gameMode;
    }

    private void loadPointBuyFile(LoadContext context, String gameFile, String gmName) {
        File pointBuyFile = new File(CustomData.customPurchaseModeFilePath(true, gmName));
        boolean useGameModeFile = true;
        if (pointBuyFile.exists()) {
            try {
                this.pointBuyLoader.loadLstFile(context, pointBuyFile.toURI(), gmName);
                useGameModeFile = false;
            }
            catch (PersistenceLayerException e) {
                // empty catch block
            }
        }
        if (useGameModeFile && !this.loadGameModeLstFile(context, this.pointBuyLoader, gmName, gameFile, "pointbuymethods.lst", false)) {
            this.loadGameModeLstFile(context, this.pointBuyLoader, gmName, gameFile, "pointbuymethods_system.lst", false);
        }
    }

    public static void addDefaultUnitSet(GameMode gameMode) {
        LoadContext context = gameMode.getModeContext();
        UnitSet us = context.getReferenceContext().silentlyGetConstructedCDOMObject(UnitSet.class, "Imperial");
        if (us == null) {
            gameMode.getModeContext().getReferenceContext().importObject(GameModeFileLoader.getDefaultUnitSet());
        }
    }

    private static synchronized UnitSet getDefaultUnitSet() {
        if (DEFAULT_UNIT_SET == null) {
            DEFAULT_UNIT_SET = new UnitSet();
            DEFAULT_UNIT_SET.setName("Imperial");
            DEFAULT_UNIT_SET.setInternal(true);
            DEFAULT_UNIT_SET.setHeightUnit("ftin");
            DEFAULT_UNIT_SET.setHeightFactor(Constants.STANDARD_UNITSET_HEIGHT_FACTOR);
            DEFAULT_UNIT_SET.setHeightDisplayPattern(Constants.STANDARD_UNITSET_HEIGHT_DISPLAY_PATTERN);
            DEFAULT_UNIT_SET.setDistanceUnit("~'");
            DEFAULT_UNIT_SET.setDistanceFactor(Constants.STANDARD_UNITSET_DISTANCE_FACTOR);
            DEFAULT_UNIT_SET.setDistanceDisplayPattern(Constants.STANDARD_UNITSET_DISTANCE_DISPLAY_PATTERN);
            DEFAULT_UNIT_SET.setWeightUnit("lbs.");
            DEFAULT_UNIT_SET.setWeightFactor(Constants.STANDARD_UNITSET_WEIGHT_FACTOR);
            DEFAULT_UNIT_SET.setWeightDisplayPattern(Constants.STANDARD_UNITSET_WEIGHT_DISPLAY_PATTERN);
        }
        return DEFAULT_UNIT_SET;
    }

    public static void addDefaultTabInfo(GameMode gameMode) {
        LoadContext context = gameMode.getModeContext();
        for (Tab aTab : Tab.values()) {
            TabInfo ti = context.getReferenceContext().silentlyGetConstructedCDOMObject(TabInfo.class, aTab.toString());
            if (ti != null) continue;
            ti = context.getReferenceContext().constructCDOMObject(TabInfo.class, aTab.toString());
            ti.setTabName(aTab.label());
        }
    }

    public static void addDefaultWieldCategories(LoadContext context) throws PersistenceLayerException {
        QualifiedObject<CDOMSingleRef<WieldCategory>> qo;
        Prerequisite p;
        PreParserFactory prereqParser;
        try {
            prereqParser = PreParserFactory.getInstance();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Error Initializing PreParserFactory");
            Logging.errorPrint("  " + ple.getMessage(), ple);
            throw new UnreachableError();
        }
        AbstractReferenceContext refContext = context.getReferenceContext();
        Collection<WieldCategory> categories = refContext.getConstructedCDOMObjects(WieldCategory.class);
        WieldCategory light = null;
        WieldCategory twoHanded = null;
        WieldCategory oneHanded = null;
        WieldCategory tooLarge = null;
        WieldCategory tooSmall = null;
        for (WieldCategory wc : categories) {
            String name = wc.getKeyName();
            if ("Light".equalsIgnoreCase(name)) {
                light = wc;
            }
            if ("TwoHanded".equalsIgnoreCase(name)) {
                twoHanded = wc;
            }
            if ("OneHanded".equalsIgnoreCase(name)) {
                oneHanded = wc;
            }
            if ("TooLarge".equalsIgnoreCase(name)) {
                tooLarge = wc;
            }
            if (!"TooSmall".equalsIgnoreCase(name)) continue;
            tooSmall = wc;
        }
        boolean buildLight = false;
        boolean buildTwoHanded = false;
        boolean buildOneHanded = false;
        boolean buildTooLarge = false;
        boolean buildTooSmall = false;
        if (light == null) {
            light = new WieldCategory();
            light.setName("Light");
            refContext.importObject(light);
            buildLight = true;
        }
        if (twoHanded == null) {
            twoHanded = new WieldCategory();
            twoHanded.setName("TwoHanded");
            refContext.importObject(twoHanded);
            buildTwoHanded = true;
        }
        if (oneHanded == null) {
            oneHanded = new WieldCategory();
            oneHanded.setName("OneHanded");
            refContext.importObject(oneHanded);
            buildOneHanded = true;
        }
        if (tooLarge == null) {
            tooLarge = new WieldCategory();
            tooLarge.setName("TooLarge");
            refContext.importObject(tooLarge);
            buildTooLarge = true;
        }
        if (tooSmall == null) {
            tooSmall = new WieldCategory();
            tooSmall.setName("TooSmall");
            refContext.importObject(tooSmall);
            buildTooSmall = true;
        }
        CDOMDirectSingleRef<Object> tooSmallRef = CDOMDirectSingleRef.getRef(tooSmall);
        CDOMDirectSingleRef<WieldCategory> lightRef = CDOMDirectSingleRef.getRef(light);
        CDOMDirectSingleRef<WieldCategory> oneHandedRef = CDOMDirectSingleRef.getRef(oneHanded);
        CDOMDirectSingleRef<WieldCategory> twoHandedRef = CDOMDirectSingleRef.getRef(twoHanded);
        CDOMDirectSingleRef<WieldCategory> tooLargeRef = CDOMDirectSingleRef.getRef(tooLarge);
        if (buildLight) {
            light.setHandsRequired(1);
            light.setFinessable(true);
            light.addDamageMult(1, 1.0f);
            light.addDamageMult(2, 1.0f);
            p = prereqParser.parse("PREVARLTEQ:EQUIP.SIZE.INT,PC.SIZE.INT-1");
            qo = new QualifiedObject<CDOMDirectSingleRef<Object>>(tooSmallRef);
            qo.addPrerequisite(p);
            light.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(oneHandedRef);
            qo.addPrerequisite(p);
            light.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+2");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(twoHandedRef);
            qo.addPrerequisite(p);
            light.addCategorySwitch(qo);
            p = prereqParser.parse("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+3");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(tooLargeRef);
            qo.addPrerequisite(p);
            light.addCategorySwitch(qo);
            light.setWieldCategoryStep(1, oneHandedRef);
            light.setWieldCategoryStep(2, twoHandedRef);
        }
        if (buildTwoHanded) {
            twoHanded.setFinessable(false);
            twoHanded.setHandsRequired(2);
            twoHanded.addDamageMult(2, 1.5f);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-3");
            qo = new QualifiedObject<CDOMSingleRef<WieldCategory>>(tooSmallRef);
            qo.addPrerequisite(p);
            twoHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-2");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(lightRef);
            qo.addPrerequisite(p);
            twoHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(oneHandedRef);
            qo.addPrerequisite(p);
            twoHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(tooLargeRef);
            qo.addPrerequisite(p);
            twoHanded.addCategorySwitch(qo);
            twoHanded.setWieldCategoryStep(-2, lightRef);
            twoHanded.setWieldCategoryStep(-1, oneHandedRef);
        }
        if (buildOneHanded) {
            oneHanded.setHandsRequired(1);
            oneHanded.setFinessable(false);
            oneHanded.addDamageMult(1, 1.0f);
            oneHanded.addDamageMult(2, 1.5f);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-2");
            qo = new QualifiedObject<CDOMDirectSingleRef<Object>>(tooSmallRef);
            qo.addPrerequisite(p);
            oneHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(lightRef);
            qo.addPrerequisite(p);
            oneHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT+1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(twoHandedRef);
            qo.addPrerequisite(p);
            oneHanded.addCategorySwitch(qo);
            p = prereqParser.parse("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+2");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(tooLargeRef);
            qo.addPrerequisite(p);
            oneHanded.addCategorySwitch(qo);
            oneHanded.setWieldCategoryStep(-1, lightRef);
            oneHanded.setWieldCategoryStep(1, twoHandedRef);
        }
        if (buildTooLarge) {
            tooLarge.setFinessable(false);
            tooLarge.setHandsRequired(999);
            tooLarge.setWieldCategoryStep(-3, lightRef);
            tooLarge.setWieldCategoryStep(-2, oneHandedRef);
            tooLarge.setWieldCategoryStep(-1, twoHandedRef);
            tooLarge.setWieldCategoryStep(0, twoHandedRef);
        }
        if (buildTooSmall) {
            tooSmall.setFinessable(false);
            tooSmall.setHandsRequired(2);
            tooSmall.addDamageMult(2, 1.5f);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-3");
            qo = new QualifiedObject<CDOMDirectSingleRef<Object>>(tooSmallRef);
            qo.addPrerequisite(p);
            tooSmall.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-2");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(lightRef);
            qo.addPrerequisite(p);
            tooSmall.addCategorySwitch(qo);
            p = prereqParser.parse("PREVAREQ:EQUIP.SIZE.INT,PC.SIZE.INT-1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(oneHandedRef);
            qo.addPrerequisite(p);
            tooSmall.addCategorySwitch(qo);
            p = prereqParser.parse("PREVARGTEQ:EQUIP.SIZE.INT,PC.SIZE.INT+1");
            qo = new QualifiedObject<CDOMDirectSingleRef<WieldCategory>>(tooLargeRef);
            qo.addPrerequisite(p);
            tooSmall.addCategorySwitch(qo);
            tooSmall.setWieldCategoryStep(-2, lightRef);
            tooSmall.setWieldCategoryStep(-1, oneHandedRef);
        }
    }
}

